/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.config;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.geoserver.util.DimensionWarning;
import org.geowebcache.storage.blobstore.memory.CacheConfiguration;
import org.geowebcache.storage.blobstore.memory.guava.GuavaCacheProvider;

public class GWCConfig
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3287178222706781438L;
    private String version;
    private boolean directWMSIntegrationEnabled;
    private Boolean requireTiledParameter = true;
    private boolean WMSCEnabled;
    private boolean TMSEnabled;
    private Boolean WMTSEnabled;
    private boolean securityEnabled;
    private boolean innerCachingEnabled;
    private boolean persistenceEnabled;
    private String cacheProviderClass;
    private Map<String, CacheConfiguration> cacheConfigurations;
    private boolean cacheLayersByDefault = true;
    private boolean cacheNonDefaultStyles;
    private int metaTilingX;
    private int metaTilingY;
    private Integer metaTilingThreads;
    private int gutter;
    private HashSet<String> defaultCachingGridSetIds;
    private HashSet<String> defaultCoverageCacheFormats;
    private HashSet<String> defaultVectorCacheFormats;
    private HashSet<String> defaultOtherCacheFormats;
    private String lockProviderName;
    Set<DimensionWarning.WarningType> cacheWarningSkips;

    public GWCConfig() {
        this.setOldDefaults();
        String png = "image/png";
        String jpeg = "image/jpeg";
        this.setDefaultCoverageCacheFormats(Collections.singleton(jpeg));
        this.setDefaultOtherCacheFormats(new HashSet<String>(Arrays.asList(png, jpeg)));
        this.setDefaultVectorCacheFormats(Collections.singleton(png));
        this.setCacheWarningSkips(Collections.emptySet());
        HashMap<String, CacheConfiguration> map = new HashMap<String, CacheConfiguration>();
        map.put(GuavaCacheProvider.class.toString(), new CacheConfiguration());
        this.setCacheConfigurations(map);
        this.setRequireTiledParameter(true);
        this.readResolve();
    }

    protected Object readResolve() {
        if (null == this.version) {
            this.version = "0.0.1";
        }
        if (this.defaultCachingGridSetIds == null) {
            this.defaultCachingGridSetIds = new HashSet();
        }
        if (this.defaultCoverageCacheFormats == null) {
            this.defaultCoverageCacheFormats = new HashSet();
        }
        if (this.defaultOtherCacheFormats == null) {
            this.defaultOtherCacheFormats = new HashSet();
        }
        if (this.defaultVectorCacheFormats == null) {
            this.defaultVectorCacheFormats = new HashSet();
        }
        if (this.cacheConfigurations == null) {
            this.cacheConfigurations = new HashMap<String, CacheConfiguration>();
            this.cacheConfigurations.put(GuavaCacheProvider.class.toString(), new CacheConfiguration());
        }
        if (this.cacheWarningSkips == null) {
            this.cacheWarningSkips = new LinkedHashSet<DimensionWarning.WarningType>();
        }
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isCacheLayersByDefault() {
        return this.cacheLayersByDefault;
    }

    public void setCacheLayersByDefault(boolean cacheLayersByDefault) {
        this.cacheLayersByDefault = cacheLayersByDefault;
    }

    public boolean isDirectWMSIntegrationEnabled() {
        return this.directWMSIntegrationEnabled;
    }

    public void setDirectWMSIntegrationEnabled(boolean directWMSIntegrationEnabled) {
        this.directWMSIntegrationEnabled = directWMSIntegrationEnabled;
    }

    public boolean isRequireTiledParameter() {
        if (this.requireTiledParameter == null) {
            return true;
        }
        return this.requireTiledParameter;
    }

    public void setRequireTiledParameter(boolean requireTiledParameter) {
        this.requireTiledParameter = requireTiledParameter;
    }

    public boolean isWMSCEnabled() {
        return this.WMSCEnabled;
    }

    public void setWMSCEnabled(boolean wMSCEnabled) {
        this.WMSCEnabled = wMSCEnabled;
    }

    public boolean isTMSEnabled() {
        return this.TMSEnabled;
    }

    public void setTMSEnabled(boolean tMSEnabled) {
        this.TMSEnabled = tMSEnabled;
    }

    public void setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public boolean isCacheNonDefaultStyles() {
        return this.cacheNonDefaultStyles;
    }

    public void setCacheNonDefaultStyles(boolean cacheNonDefaultStyles) {
        this.cacheNonDefaultStyles = cacheNonDefaultStyles;
    }

    public Set<String> getDefaultCachingGridSetIds() {
        return this.defaultCachingGridSetIds;
    }

    public void setDefaultCachingGridSetIds(Set<String> defaultCachingGridSetIds) {
        this.defaultCachingGridSetIds = new HashSet<String>(defaultCachingGridSetIds);
    }

    public Set<String> getDefaultCoverageCacheFormats() {
        return this.defaultCoverageCacheFormats;
    }

    public void setDefaultCoverageCacheFormats(Set<String> defaultCoverageCacheFormats) {
        this.defaultCoverageCacheFormats = new HashSet<String>(defaultCoverageCacheFormats);
    }

    public Set<String> getDefaultVectorCacheFormats() {
        return this.defaultVectorCacheFormats;
    }

    public void setDefaultVectorCacheFormats(Set<String> defaultVectorCacheFormats) {
        this.defaultVectorCacheFormats = new HashSet<String>(defaultVectorCacheFormats);
    }

    public Set<String> getDefaultOtherCacheFormats() {
        return this.defaultOtherCacheFormats;
    }

    public void setDefaultOtherCacheFormats(Set<String> defaultOtherCacheFormats) {
        this.defaultOtherCacheFormats = new HashSet<String>(defaultOtherCacheFormats);
    }

    public GWCConfig saneConfig() {
        if (this.isSane()) {
            return this;
        }
        GWCConfig sane = GWCConfig.getOldDefaults();
        sane.setRequireTiledParameter(true);
        if (this.metaTilingX > 0) {
            sane.setMetaTilingX(this.metaTilingX);
        }
        if (this.metaTilingY > 0) {
            sane.setMetaTilingY(this.metaTilingY);
        }
        if (this.gutter >= 0) {
            sane.setGutter(this.gutter);
        }
        if (!this.defaultCachingGridSetIds.isEmpty()) {
            sane.setDefaultCachingGridSetIds(this.defaultCachingGridSetIds);
        }
        if (!this.defaultCoverageCacheFormats.isEmpty()) {
            sane.setDefaultCoverageCacheFormats(this.defaultCoverageCacheFormats);
        }
        if (!this.defaultOtherCacheFormats.isEmpty()) {
            sane.setDefaultOtherCacheFormats(this.defaultOtherCacheFormats);
        }
        if (!this.defaultVectorCacheFormats.isEmpty()) {
            sane.setDefaultVectorCacheFormats(this.defaultVectorCacheFormats);
        }
        if (this.metaTilingThreads != null && this.metaTilingThreads > 0) {
            sane.setMetaTilingThreads(this.metaTilingThreads);
        }
        return sane;
    }

    public boolean isSane() {
        return this.metaTilingX > 0 && this.metaTilingY > 0 && (this.metaTilingThreads == null || this.metaTilingThreads >= 0) && this.gutter >= 0 && !this.defaultCachingGridSetIds.isEmpty() && !this.defaultCoverageCacheFormats.isEmpty() && !this.defaultOtherCacheFormats.isEmpty() && !this.defaultVectorCacheFormats.isEmpty();
    }

    public static GWCConfig getOldDefaults() {
        GWCConfig config = new GWCConfig();
        config.setOldDefaults();
        return config;
    }

    private void setOldDefaults() {
        this.setCacheLayersByDefault(true);
        this.setMetaTilingX(4);
        this.setMetaTilingY(4);
        this.setGutter(0);
        this.setCacheNonDefaultStyles(true);
        this.setRequireTiledParameter(true);
        this.setDefaultCachingGridSetIds(new HashSet<String>(Arrays.asList("EPSG:4326", "EPSG:900913")));
        HashSet<String> oldDefaultFormats = new HashSet<String>(Arrays.asList("image/png", "image/jpeg"));
        this.setDefaultCoverageCacheFormats(oldDefaultFormats);
        this.setDefaultOtherCacheFormats(oldDefaultFormats);
        this.setDefaultVectorCacheFormats(oldDefaultFormats);
        this.setDirectWMSIntegrationEnabled(false);
        this.setWMSCEnabled(true);
        this.setTMSEnabled(true);
        this.setEnabledPersistence(true);
        this.setInnerCachingEnabled(false);
        HashMap<String, CacheConfiguration> map = new HashMap<String, CacheConfiguration>();
        map.put(GuavaCacheProvider.class.toString(), new CacheConfiguration());
        this.setCacheConfigurations(map);
        this.setCacheProviderClass(GuavaCacheProvider.class.toString());
        this.setCacheWarningSkips(new LinkedHashSet<DimensionWarning.WarningType>());
    }

    public int getMetaTilingX() {
        return this.metaTilingX;
    }

    public void setMetaTilingX(int metaFactorX) {
        this.metaTilingX = metaFactorX;
    }

    public int getMetaTilingY() {
        return this.metaTilingY;
    }

    public void setMetaTilingY(int metaFactorY) {
        this.metaTilingY = metaFactorY;
    }

    public Integer getMetaTilingThreads() {
        return this.metaTilingThreads;
    }

    public void setMetaTilingThreads(Integer metaTilingThreads) {
        this.metaTilingThreads = metaTilingThreads;
    }

    public int getGutter() {
        return this.gutter;
    }

    public void setGutter(int gutter) {
        this.gutter = gutter;
    }

    public GWCConfig clone() {
        GWCConfig clone;
        try {
            clone = (GWCConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.setDefaultCachingGridSetIds(this.getDefaultCachingGridSetIds());
        clone.setDefaultCoverageCacheFormats(this.getDefaultCoverageCacheFormats());
        clone.setDefaultVectorCacheFormats(this.getDefaultVectorCacheFormats());
        clone.setDefaultOtherCacheFormats(this.getDefaultOtherCacheFormats());
        clone.setCacheConfigurations(this.getCacheConfigurations());
        clone.setRequireTiledParameter(this.isRequireTiledParameter());
        clone.setCacheWarningSkips(this.getCacheWarningSkips());
        return clone;
    }

    public boolean isEnabled(String serviceId) {
        Preconditions.checkNotNull((Object)serviceId);
        if ("wms".equalsIgnoreCase(serviceId)) {
            return this.isWMSCEnabled();
        }
        if ("wmts".equalsIgnoreCase(serviceId)) {
            throw new RuntimeException("To check if WMTS service is enable or disable use service info.");
        }
        if ("tms".equalsIgnoreCase(serviceId)) {
            return this.isTMSEnabled();
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GWCConfig gwcConfig = (GWCConfig)o;
        return this.directWMSIntegrationEnabled == gwcConfig.directWMSIntegrationEnabled && Objects.equals(this.requireTiledParameter, gwcConfig.requireTiledParameter) && this.WMSCEnabled == gwcConfig.WMSCEnabled && this.TMSEnabled == gwcConfig.TMSEnabled && this.securityEnabled == gwcConfig.securityEnabled && this.innerCachingEnabled == gwcConfig.innerCachingEnabled && this.persistenceEnabled == gwcConfig.persistenceEnabled && this.cacheLayersByDefault == gwcConfig.cacheLayersByDefault && this.cacheNonDefaultStyles == gwcConfig.cacheNonDefaultStyles && this.metaTilingX == gwcConfig.metaTilingX && this.metaTilingY == gwcConfig.metaTilingY && Objects.equals(this.metaTilingThreads, gwcConfig.metaTilingThreads) && this.gutter == gwcConfig.gutter && Objects.equals(this.version, gwcConfig.version) && Objects.equals(this.WMTSEnabled, gwcConfig.WMTSEnabled) && Objects.equals(this.cacheProviderClass, gwcConfig.cacheProviderClass) && Objects.equals(this.cacheConfigurations, gwcConfig.cacheConfigurations) && Objects.equals(this.defaultCachingGridSetIds, gwcConfig.defaultCachingGridSetIds) && Objects.equals(this.defaultCoverageCacheFormats, gwcConfig.defaultCoverageCacheFormats) && Objects.equals(this.defaultVectorCacheFormats, gwcConfig.defaultVectorCacheFormats) && Objects.equals(this.defaultOtherCacheFormats, gwcConfig.defaultOtherCacheFormats) && Objects.equals(this.lockProviderName, gwcConfig.lockProviderName) && Objects.equals(this.cacheWarningSkips, gwcConfig.cacheWarningSkips);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.directWMSIntegrationEnabled, this.requireTiledParameter, this.WMSCEnabled, this.TMSEnabled, this.WMTSEnabled, this.securityEnabled, this.innerCachingEnabled, this.persistenceEnabled, this.cacheProviderClass, this.cacheConfigurations, this.cacheLayersByDefault, this.cacheNonDefaultStyles, this.metaTilingX, this.metaTilingY, this.metaTilingThreads, this.gutter, this.defaultCachingGridSetIds, this.defaultCoverageCacheFormats, this.defaultVectorCacheFormats, this.defaultOtherCacheFormats, this.lockProviderName, this.cacheWarningSkips);
    }

    public String getLockProviderName() {
        return this.lockProviderName;
    }

    public void setLockProviderName(String lockProviderName) {
        this.lockProviderName = lockProviderName;
    }

    public boolean isInnerCachingEnabled() {
        return this.innerCachingEnabled;
    }

    public void setInnerCachingEnabled(boolean innerCachingEnabled) {
        this.innerCachingEnabled = innerCachingEnabled;
    }

    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    public void setEnabledPersistence(boolean persistenceEnabled) {
        this.persistenceEnabled = persistenceEnabled;
    }

    public String getCacheProviderClass() {
        return this.cacheProviderClass;
    }

    public void setCacheProviderClass(String cacheProviderClass) {
        this.cacheProviderClass = cacheProviderClass;
    }

    public Map<String, CacheConfiguration> getCacheConfigurations() {
        return this.cacheConfigurations;
    }

    public void setCacheConfigurations(Map<String, CacheConfiguration> cacheConfigurations) {
        this.cacheConfigurations = new HashMap<String, CacheConfiguration>(cacheConfigurations);
    }

    public Boolean isWMTSEnabled() {
        return this.WMTSEnabled;
    }

    public void setWMTSEnabled(Boolean WMTSEnabled) {
        this.WMTSEnabled = WMTSEnabled;
    }

    public Set<DimensionWarning.WarningType> getCacheWarningSkips() {
        return this.cacheWarningSkips;
    }

    public void setCacheWarningSkips(Set<DimensionWarning.WarningType> cacheWarningSkips) {
        this.cacheWarningSkips = new LinkedHashSet<DimensionWarning.WarningType>(cacheWarningSkips);
    }
}

