/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.util.Map;
import java.util.Properties;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.GeoServerExtensions;
import org.geowebcache.GeoWebCacheEnvironment;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GWCSynchEnv
implements ApplicationContextAware {
    private GeoWebCacheEnvironment gwcEnvironment;
    GeoServerEnvironment gsEnvironment;
    private boolean forceSync = false;

    public GWCSynchEnv(GeoServerEnvironment gsEnvironment) {
        this.gsEnvironment = gsEnvironment;
    }

    protected void setGsEnvironment(GeoServerEnvironment gsEnvironment) {
        this.gsEnvironment = gsEnvironment;
    }

    protected void setGwcEnvironment(GeoWebCacheEnvironment gwcEnvironment) {
        this.gwcEnvironment = gwcEnvironment;
    }

    protected void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.gwcEnvironment = (GeoWebCacheEnvironment)GeoServerExtensions.bean(GeoWebCacheEnvironment.class);
        this.syncEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncEnv() throws IllegalArgumentException {
        if (this.needsSynchronization()) {
            GWCSynchEnv gWCSynchEnv = this;
            synchronized (gWCSynchEnv) {
                if (this.needsSynchronization()) {
                    Properties gwcProps = this.gwcEnvironment.getProps();
                    if (gwcProps == null) {
                        gwcProps = new Properties();
                    }
                    gwcProps.putAll((Map<?, ?>)this.gsEnvironment.getProps());
                    this.gwcEnvironment.setProps(gwcProps);
                }
            }
        }
    }

    private boolean needsSynchronization() {
        return !(!GeoServerEnvironment.allowEnvParametrization() && !this.forceSync || this.gsEnvironment == null || this.gsEnvironment.getProps() == null || this.gwcEnvironment == null || !this.gsEnvironment.isStale() && this.gwcEnvironment.getProps() != null);
    }
}

