/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.gwc.ServletDebugException;
import org.geotools.util.logging.Logging;

public class FakeHttpServletResponse
implements HttpServletResponse {
    private static Logger log = Logging.getLogger((String)HttpServletResponse.class.toString());
    private FakeServletOutputStream fos = new FakeServletOutputStream();
    private String contentType;
    private HashMap<String, String> headers = new HashMap();
    private List<Cookie> cookies;
    private int responseCode = 200;

    public byte[] getBytes() {
        return this.fos.getBytes();
    }

    public Cookie[] getCachedCookies() {
        return this.cookies == null ? new Cookie[]{} : this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public void addCookie(Cookie cookie) {
        if (this.cookies == null) {
            this.cookies = new ArrayList<Cookie>(2);
        }
        this.cookies.add(cookie);
    }

    public void addDateHeader(String arg0, long arg1) {
        log.finer("Added date header: " + arg0 + " : " + arg1);
        this.headers.put(arg0, Long.toString(arg1));
    }

    public void addHeader(String arg0, String arg1) {
        log.finer("Added string header: " + arg0 + " : " + arg1);
        this.headers.put(arg0, arg1);
    }

    public void addIntHeader(String arg0, int arg1) {
        log.finer("Added integer header: " + arg0 + " : " + arg1);
        this.headers.put(arg0, Integer.toString(arg1));
    }

    public boolean containsHeader(String arg0) {
        return this.headers.containsKey(arg0);
    }

    public String encodeRedirectURL(String arg0) {
        throw new ServletDebugException();
    }

    public String encodeRedirectUrl(String arg0) {
        throw new ServletDebugException();
    }

    public String encodeURL(String arg0) {
        throw new ServletDebugException();
    }

    public String encodeUrl(String arg0) {
        throw new ServletDebugException();
    }

    public void sendError(int arg0) throws IOException {
        this.responseCode = arg0;
    }

    public void sendError(int arg0, String arg1) throws IOException {
        this.responseCode = arg0;
    }

    public void sendRedirect(String arg0) throws IOException {
        throw new ServletDebugException();
    }

    public void setDateHeader(String arg0, long arg1) {
        throw new ServletDebugException();
    }

    public void setHeader(String arg0, String arg1) {
        this.addHeader(arg0, arg1);
    }

    public void setIntHeader(String arg0, int arg1) {
        throw new ServletDebugException();
    }

    public void setStatus(int arg0) {
        throw new ServletDebugException();
    }

    public void setStatus(int arg0, String arg1) {
        throw new ServletDebugException();
    }

    public int getStatus() {
        return this.responseCode;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Collection<String> getHeaders(String name) {
        return this.headers.containsKey(name) ? Arrays.asList(this.headers.get(name)) : Collections.emptyList();
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public void flushBuffer() throws IOException {
        throw new ServletDebugException();
    }

    public int getBufferSize() {
        throw new ServletDebugException();
    }

    public String getCharacterEncoding() {
        throw new ServletDebugException();
    }

    public String getContentType() {
        return this.contentType;
    }

    public Locale getLocale() {
        throw new ServletDebugException();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        log.finer("Returning output stream");
        return this.fos;
    }

    public PrintWriter getWriter() throws IOException {
        throw new ServletDebugException();
    }

    public boolean isCommitted() {
        throw new ServletDebugException();
    }

    public void reset() {
        throw new ServletDebugException();
    }

    public void resetBuffer() {
        throw new ServletDebugException();
    }

    public void setBufferSize(int arg0) {
        throw new ServletDebugException();
    }

    public void setCharacterEncoding(String arg0) {
    }

    public void setContentLength(int arg0) {
        throw new ServletDebugException();
    }

    public void setContentLengthLong(long l) {
    }

    public void setContentType(String arg0) {
        log.finer("Content type set to " + arg0);
        this.contentType = arg0;
    }

    public void setLocale(Locale arg0) {
        throw new ServletDebugException();
    }

    private static class FakeServletOutputStream
    extends ServletOutputStream {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(20480);

        private FakeServletOutputStream() {
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }

        public byte[] getBytes() {
            return this.outputStream.toByteArray();
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

