/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.RenderedOp;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CoverageInfoImpl;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.LegendInfoImpl;
import org.geoserver.catalog.impl.MetadataLinkInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.ResourceInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.GWCSynchEnv;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.dispatch.GwcServiceDispatcherCallback;
import org.geoserver.gwc.layer.DynamicGridSubset;
import org.geoserver.gwc.layer.GeoServerMetaTile;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.LegacyTileLayerInfoLoader;
import org.geoserver.gwc.layer.StyleParameterFilter;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.Request;
import org.geoserver.util.DimensionWarning;
import org.geoserver.util.HTTPWarningAppender;
import org.geoserver.wms.GetLegendGraphicOutputFormat;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.capabilities.LegendSample;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geoserver.wms.map.RenderedImageTimeDecorator;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.config.legends.LegendInfo;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.ExpirationRule;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.meta.MetadataURL;
import org.geowebcache.layer.meta.TileJSON;
import org.geowebcache.layer.meta.VectorLayerMetadata;
import org.geowebcache.locks.MemoryLockProvider;
import org.geowebcache.mime.ApplicationMime;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.TileObject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class GeoServerTileLayerTest {
    static final Logger LOGGER = Logging.getLogger(GeoServerTileLayerTest.class);
    private static final int MAX_AGE_VALUE = 123;
    private LayerInfoImpl layerInfo;
    private GeoServerTileLayer layerInfoTileLayer;
    private LayerGroupInfoImpl layerGroup;
    private GeoServerTileLayer layerGroupInfoTileLayer;
    private Catalog catalog;
    private GridSetBroker gridSetBroker;
    private GWCConfig defaults;
    private GWC mockGWC;
    private GWCSynchEnv mockGWCSynchEnv;
    private FeatureTypeInfoImpl resource;
    private NamespaceInfoImpl ns;

    @After
    public void tearDown() throws Exception {
        GWC.set(null, null);
        Dispatcher.REQUEST.remove();
    }

    @Before
    public void setUp() throws Exception {
        this.mockGWC = (GWC)Mockito.mock(GWC.class);
        this.mockGWCSynchEnv = (GWCSynchEnv)Mockito.mock(GWCSynchEnv.class);
        MemoryLockProvider lockProvider = new MemoryLockProvider();
        Mockito.when((Object)this.mockGWC.getLockProvider()).thenReturn((Object)lockProvider);
        GWC.set((GWC)this.mockGWC, (GWCSynchEnv)this.mockGWCSynchEnv);
        String layerInfoId = "mock-layer-info";
        this.ns = new NamespaceInfoImpl();
        this.ns.setPrefix("test");
        this.ns.setURI("http://goserver.org/test");
        WorkspaceInfoImpl workspaceInfo = new WorkspaceInfoImpl();
        workspaceInfo.setName("workspace");
        DataStoreInfoImpl storeInfo = new DataStoreInfoImpl(null);
        storeInfo.setId("mock-store-info");
        storeInfo.setEnabled(true);
        storeInfo.setWorkspace((WorkspaceInfo)workspaceInfo);
        this.resource = new FeatureTypeInfoImpl(null);
        this.resource.setStore((StoreInfo)storeInfo);
        this.resource.setId("mock-resource-info");
        this.resource.setName("MockLayerInfoName");
        this.resource.setNamespace((NamespaceInfo)this.ns);
        this.resource.setTitle("Test resource title");
        this.resource.setAbstract("Test resource abstract");
        this.resource.setEnabled(true);
        this.resource.setDescription("Test resource description");
        this.resource.setLatLonBoundingBox(new ReferencedEnvelope(-180.0, -90.0, 0.0, 0.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        this.resource.setNativeBoundingBox(new ReferencedEnvelope(-180.0, -90.0, 0.0, 0.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        this.resource.setSRS("EPSG:4326");
        this.resource.setKeywords(Arrays.asList(new Keyword("kwd1"), new Keyword("kwd2")));
        MetadataLinkInfoImpl metadataLinkInfo = new MetadataLinkInfoImpl();
        metadataLinkInfo.setAbout("metadata-about");
        metadataLinkInfo.setContent("metadata-content");
        metadataLinkInfo.setId("metadata-id");
        metadataLinkInfo.setMetadataType("metadata-type");
        metadataLinkInfo.setType("metadata-format");
        this.resource.setMetadataLinks(Collections.singletonList(metadataLinkInfo));
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("testType");
        builder.setNamespaceURI(this.ns.getURI());
        builder.setSRS("EPSG:4326");
        builder.add("stringField", String.class);
        builder.add("numberField", Number.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        ResourcePool resourcePool = (ResourcePool)Mockito.mock(ResourcePool.class);
        Style style = (Style)Mockito.mock(Style.class);
        Mockito.when((Object)style.featureTypeStyles()).thenReturn(Collections.emptyList());
        Mockito.when((Object)resourcePool.getStyle((StyleInfo)ArgumentMatchers.any(StyleInfo.class))).thenReturn((Object)style);
        this.catalog = (Catalog)Mockito.mock(Catalog.class);
        Mockito.when((Object)this.catalog.getResourcePool()).thenReturn((Object)resourcePool);
        Mockito.when((Object)resourcePool.getFeatureType((FeatureTypeInfo)ArgumentMatchers.eq((Object)this.resource))).thenReturn((Object)featureType);
        this.layerInfo = new LayerInfoImpl();
        this.layerInfo.setId("mock-layer-info");
        this.layerInfo.setResource((ResourceInfo)this.resource);
        this.layerInfo.setEnabled(true);
        this.layerInfo.setName("MockLayerInfoName");
        this.layerInfo.setType(PublishedType.VECTOR);
        StyleInfoImpl defaultStyle = new StyleInfoImpl(this.catalog);
        defaultStyle.setName("default_style");
        this.layerInfo.setDefaultStyle((StyleInfo)defaultStyle);
        StyleInfoImpl alternateStyle1 = new StyleInfoImpl(this.catalog);
        alternateStyle1.setName("alternateStyle-1");
        StyleInfoImpl alternateStyle2 = new StyleInfoImpl(this.catalog);
        alternateStyle2.setName("alternateStyle-2");
        HashSet<StyleInfo> alternateStyles = new HashSet<StyleInfo>(Arrays.asList(alternateStyle1, alternateStyle2));
        LegendInfoImpl legendInfo = new LegendInfoImpl();
        legendInfo.setWidth(150);
        legendInfo.setHeight(200);
        legendInfo.setFormat("image/png");
        legendInfo.setOnlineResource("some-url                                                                                         ");
        alternateStyle2.setLegend((org.geoserver.catalog.LegendInfo)legendInfo);
        this.layerInfo.setStyles(alternateStyles);
        this.layerGroup = new LayerGroupInfoImpl();
        String layerGroupId = "mock-layergroup-id";
        this.layerGroup.setId("mock-layergroup-id");
        this.layerGroup.setName("MockLayerGroup");
        this.layerGroup.setTitle("Group title");
        this.layerGroup.setAbstract("Group abstract");
        this.layerGroup.setLayers(Collections.singletonList(this.layerInfo));
        this.defaults = GWCConfig.getOldDefaults();
        Mockito.when((Object)this.catalog.getLayer((String)ArgumentMatchers.eq((Object)"mock-layer-info"))).thenReturn((Object)this.layerInfo);
        Mockito.when((Object)this.catalog.getLayerGroup((String)ArgumentMatchers.eq((Object)"mock-layergroup-id"))).thenReturn((Object)this.layerGroup);
        this.gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true)));
    }

    @Test
    public void testEnabled() {
        this.layerInfo.setEnabled(true);
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        Assert.assertTrue((boolean)this.layerInfoTileLayer.isEnabled());
        this.layerInfo.setEnabled(false);
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        Assert.assertFalse((boolean)this.layerInfoTileLayer.isEnabled());
        this.layerInfo.setEnabled(true);
        this.layerInfoTileLayer.setEnabled(true);
        Assert.assertTrue((boolean)this.layerInfoTileLayer.isEnabled());
        Assert.assertTrue((boolean)this.layerInfoTileLayer.getInfo().isEnabled());
        this.layerInfoTileLayer.setConfigErrorMessage("fake error message");
        Assert.assertFalse((boolean)this.layerInfoTileLayer.isEnabled());
        this.layerInfoTileLayer.setConfigErrorMessage(null);
        this.layerInfoTileLayer.setEnabled(false);
        Assert.assertFalse((boolean)this.layerInfoTileLayer.isEnabled());
        Assert.assertFalse((boolean)this.layerInfoTileLayer.getInfo().isEnabled());
        this.layerGroupInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        Assert.assertTrue((boolean)this.layerGroupInfoTileLayer.isEnabled());
    }

    @Test
    public void testGetMetaTilingFactors() {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        int[] metaTilingFactors = this.layerInfoTileLayer.getMetaTilingFactors();
        Assert.assertEquals((long)this.defaults.getMetaTilingX(), (long)metaTilingFactors[0]);
        Assert.assertEquals((long)this.defaults.getMetaTilingY(), (long)metaTilingFactors[1]);
        GeoServerTileLayerInfo info = this.layerInfoTileLayer.getInfo();
        info.setMetaTilingX(1 + this.defaults.getMetaTilingX());
        info.setMetaTilingY(2 + this.defaults.getMetaTilingY());
        LegacyTileLayerInfoLoader.save((GeoServerTileLayerInfo)info, (MetadataMap)this.layerInfo.getMetadata());
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        metaTilingFactors = this.layerInfoTileLayer.getMetaTilingFactors();
        Assert.assertEquals((long)(1 + this.defaults.getMetaTilingX()), (long)metaTilingFactors[0]);
        Assert.assertEquals((long)(2 + this.defaults.getMetaTilingY()), (long)metaTilingFactors[1]);
    }

    @Test
    public void testIsQueryable() {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        Mockito.when((Object)this.mockGWC.isQueryable((GeoServerTileLayer)ArgumentMatchers.same((Object)this.layerInfoTileLayer))).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.layerInfoTileLayer.isQueryable());
        Mockito.when((Object)this.mockGWC.isQueryable((GeoServerTileLayer)ArgumentMatchers.same((Object)this.layerInfoTileLayer))).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.layerInfoTileLayer.isQueryable());
        ((GWC)Mockito.verify((Object)this.mockGWC, (VerificationMode)Mockito.times((int)2))).isQueryable((GeoServerTileLayer)ArgumentMatchers.same((Object)this.layerInfoTileLayer));
    }

    @Test
    public void testGetName() {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        Assert.assertEquals((Object)GWC.tileLayerName((LayerInfo)this.layerInfo), (Object)this.layerInfoTileLayer.getName());
        this.layerGroupInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        Assert.assertEquals((Object)GWC.tileLayerName((LayerGroupInfo)this.layerGroup), (Object)this.layerGroupInfoTileLayer.getName());
    }

    @Test
    public void testGetParameterFilters() {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        List parameterFilters = this.layerInfoTileLayer.getParameterFilters();
        Assert.assertNotNull((Object)parameterFilters);
        Assert.assertEquals((long)1L, (long)parameterFilters.size());
        Assert.assertTrue((boolean)(parameterFilters.get(0) instanceof StyleParameterFilter));
        StyleParameterFilter styleFilter = (StyleParameterFilter)parameterFilters.get(0);
        Assert.assertEquals((Object)"STYLES", (Object)styleFilter.getKey());
        Assert.assertEquals((Object)"default_style", (Object)styleFilter.getDefaultValue());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("default_style", "alternateStyle-1", "alternateStyle-2")), new HashSet(styleFilter.getLegalValues()));
    }

    @Test
    public void testGetDefaultParameterFilters() {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        Map defaultFilters = this.layerInfoTileLayer.getDefaultParameterFilters();
        Assert.assertEquals((long)1L, (long)defaultFilters.size());
        Assert.assertEquals((Object)"default_style", defaultFilters.get("STYLES"));
    }

    @Test
    public void testGetModifiableParameters() throws GeoWebCacheException {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        ParameterFilter stylesParamFilter = (ParameterFilter)this.layerInfoTileLayer.getParameterFilters().get(0);
        List legalValues = stylesParamFilter.getLegalValues();
        Map<String, String> requestParams = Collections.singletonMap("sTyLeS", "");
        Map modifiedParams = this.layerInfoTileLayer.getModifiableParameters(requestParams, "UTF-8");
        Assert.assertEquals((long)0L, (long)modifiedParams.size());
        for (String legalStyle : legalValues) {
            requestParams = new HashMap<String, String>();
            requestParams.put("sTyLeS", legalStyle);
            modifiedParams = this.layerInfoTileLayer.getModifiableParameters(requestParams, "UTF-8");
            if (legalStyle.equals(stylesParamFilter.getDefaultValue())) {
                Assert.assertEquals((long)0L, (long)modifiedParams.size());
                continue;
            }
            Assert.assertEquals(Collections.singletonMap("STYLES", legalStyle), (Object)modifiedParams);
        }
    }

    @Test
    public void testGetMetaInformation() {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        this.layerGroupInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        LayerMetaInformation metaInformation = this.layerInfoTileLayer.getMetaInformation();
        Assert.assertNotNull((Object)metaInformation);
        String title = metaInformation.getTitle();
        String description = metaInformation.getDescription();
        List keywords = metaInformation.getKeywords();
        Assert.assertEquals((Object)this.layerInfo.getResource().getTitle(), (Object)title);
        Assert.assertEquals((Object)this.layerInfo.getResource().getAbstract(), (Object)description);
        Assert.assertEquals((long)this.layerInfo.getResource().getKeywords().size(), (long)keywords.size());
        for (String kw : keywords) {
            Assert.assertTrue((boolean)this.layerInfo.getResource().getKeywords().contains(new Keyword(kw)));
        }
        metaInformation = this.layerGroupInfoTileLayer.getMetaInformation();
        Assert.assertNotNull((Object)metaInformation);
        title = metaInformation.getTitle();
        description = metaInformation.getDescription();
        keywords = metaInformation.getKeywords();
        Assert.assertEquals((Object)"Group title", (Object)title);
        Assert.assertEquals((Object)"Group abstract", (Object)description);
        Assert.assertEquals((long)0L, (long)keywords.size());
    }

    @Test
    public void testGetStyles() {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        this.layerGroupInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        Assert.assertEquals((Object)"default_style", (Object)this.layerInfoTileLayer.getStyles());
        Assert.assertNull((Object)this.layerGroupInfoTileLayer.getStyles());
        StyleInfoImpl newDefaultStyle = new StyleInfoImpl(null);
        newDefaultStyle.setName("newDefault");
        this.layerInfo.setDefaultStyle((StyleInfo)newDefaultStyle);
        Assert.assertEquals((Object)"newDefault", (Object)this.layerInfoTileLayer.getStyles());
    }

    @Test
    public void testGetGridSubsets() throws Exception {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        Set gridSubsets = this.layerInfoTileLayer.getGridSubsets();
        Assert.assertNotNull((Object)gridSubsets);
        Assert.assertEquals((long)2L, (long)gridSubsets.size());
        Set subsets = this.layerInfoTileLayer.getInfo().getGridSubsets();
        subsets.clear();
        XMLGridSubset xmlGridSubset = new XMLGridSubset();
        xmlGridSubset.setGridSetName("EPSG:900913");
        subsets.add(xmlGridSubset);
        LegacyTileLayerInfoLoader.save((GeoServerTileLayerInfo)this.layerInfoTileLayer.getInfo(), (MetadataMap)this.layerInfo.getMetadata());
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        gridSubsets = this.layerInfoTileLayer.getGridSubsets();
        Assert.assertNotNull((Object)gridSubsets);
        Assert.assertEquals((long)1L, (long)gridSubsets.size());
        this.layerGroup.setBounds(this.layerInfo.getResource().getLatLonBoundingBox());
        this.layerGroupInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        gridSubsets = this.layerGroupInfoTileLayer.getGridSubsets();
        Assert.assertNotNull((Object)gridSubsets);
        Assert.assertEquals((long)2L, (long)gridSubsets.size());
    }

    @Test
    public void testGetGridSubsetsDynamic() throws Exception {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        GridSubset subset = this.layerInfoTileLayer.getGridSubset("EPSG:4326");
        MatcherAssert.assertThat((Object)subset, (Matcher)Matchers.instanceOf(DynamicGridSubset.class));
        MatcherAssert.assertThat((Object)subset, (Matcher)Matchers.hasProperty((String)"originalExtent", (Matcher)Matchers.hasProperty((String)"minX", (Matcher)Matchers.closeTo((double)-180.0, (double)1.0E-7))));
        this.layerInfoTileLayer.removeGridSubset("EPSG:4326");
        this.layerInfoTileLayer.addGridSubset(subset);
        this.resource.setLatLonBoundingBox(new ReferencedEnvelope(-90.0, -90.0, 0.0, 0.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        this.resource.setNativeBoundingBox(new ReferencedEnvelope(-90.0, -90.0, 0.0, 0.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        GridSubset subset2 = this.layerInfoTileLayer.getGridSubset("EPSG:4326");
        MatcherAssert.assertThat((Object)subset2, (Matcher)Matchers.hasProperty((String)"originalExtent", (Matcher)Matchers.hasProperty((String)"minX", (Matcher)Matchers.closeTo((double)-90.0, (double)1.0E-7))));
    }

    @Test
    public void testGetGridSubsetsStatic() throws Exception {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        GridSubset subset = this.layerInfoTileLayer.getGridSubset("EPSG:4326");
        MatcherAssert.assertThat((Object)subset, (Matcher)Matchers.instanceOf(DynamicGridSubset.class));
        MatcherAssert.assertThat((Object)subset, (Matcher)Matchers.hasProperty((String)"originalExtent", (Matcher)Matchers.hasProperty((String)"minX", (Matcher)Matchers.closeTo((double)-180.0, (double)1.0E-7))));
        this.layerInfoTileLayer.removeGridSubset("EPSG:4326");
        this.layerInfoTileLayer.addGridSubset(new GridSubset(subset));
        this.resource.setLatLonBoundingBox(new ReferencedEnvelope(-90.0, -90.0, 0.0, 0.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        this.resource.setNativeBoundingBox(new ReferencedEnvelope(-90.0, -90.0, 0.0, 0.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        GridSubset subset2 = this.layerInfoTileLayer.getGridSubset("EPSG:4326");
        MatcherAssert.assertThat((Object)subset2, (Matcher)Matchers.hasProperty((String)"originalExtent", (Matcher)Matchers.hasProperty((String)"minX", (Matcher)Matchers.closeTo((double)-180.0, (double)1.0E-7))));
    }

    @Test
    public void testGridSubsetBoundsClippedToTargetCrsAreaOfValidity() throws Exception {
        CoordinateReferenceSystem nativeCrs = CRS.decode((String)"EPSG:4326", (boolean)true);
        ReferencedEnvelope nativeBounds = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, nativeCrs);
        this.layerGroup.setBounds(nativeBounds);
        this.defaults.getDefaultCachingGridSetIds().clear();
        this.defaults.getDefaultCachingGridSetIds().add("EPSG:900913");
        this.layerGroupInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        this.layerGroupInfoTileLayer.getGridSubset("EPSG:900913");
        XMLGridSubset savedSubset = (XMLGridSubset)this.layerGroupInfoTileLayer.getInfo().getGridSubsets().iterator().next();
        BoundingBox gridSubsetExtent = savedSubset.getExtent();
        BoundingBox expected = this.gridSetBroker.getWorldEpsg3857().getOriginalExtent();
        double threshold = 1.0E-16;
        Assert.assertTrue((String)("Expected " + expected + ", got " + gridSubsetExtent), (boolean)expected.equals(gridSubsetExtent, threshold));
    }

    @Test
    public void testGetFeatureInfo() throws Exception {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        ConveyorTile convTile = new ConveyorTile(null, null, null, null);
        convTile.setTileLayer((TileLayer)this.layerInfoTileLayer);
        convTile.setMimeType(MimeType.createFromFormat((String)"image/png"));
        convTile.setGridSetId("EPSG:4326");
        convTile.servletReq = new MockHttpServletRequest();
        BoundingBox bbox = new BoundingBox(0.0, 0.0, 10.0, 10.0);
        Resource mockResult = (Resource)Mockito.mock(Resource.class);
        ArgumentCaptor argument = ArgumentCaptor.forClass(Map.class);
        Mockito.when((Object)this.mockGWC.dispatchOwsRequest((Map)argument.capture(), (Cookie[])ArgumentMatchers.any())).thenReturn((Object)mockResult);
        Resource result = this.layerInfoTileLayer.getFeatureInfo(convTile, bbox, 100, 100, 50, 50);
        Assert.assertSame((Object)mockResult, (Object)result);
        Map capturedParams = (Map)argument.getValue();
        Assert.assertEquals((Object)"image/png", capturedParams.get("INFO_FORMAT"));
        Assert.assertEquals((Object)"0.0,0.0,10.0,10.0", capturedParams.get("BBOX"));
        Assert.assertEquals((Object)"test:MockLayerInfoName", capturedParams.get("QUERY_LAYERS"));
        Assert.assertEquals((Object)"WMS", capturedParams.get("SERVICE"));
        Assert.assertEquals((Object)"100", capturedParams.get("HEIGHT"));
        Assert.assertEquals((Object)"100", capturedParams.get("WIDTH"));
        Assert.assertEquals((Object)"GetFeatureInfo", capturedParams.get("REQUEST"));
        Assert.assertEquals((Object)"default_style", capturedParams.get("STYLES"));
        Assert.assertEquals((Object)"SE_XML", capturedParams.get("EXCEPTIONS"));
        Assert.assertEquals((Object)"1.1.1", capturedParams.get("VERSION"));
        Assert.assertEquals((Object)"image/png", capturedParams.get("FORMAT"));
        Assert.assertEquals((Object)"test:MockLayerInfoName", capturedParams.get("LAYERS"));
        Assert.assertEquals((Object)"EPSG:4326", capturedParams.get("SRS"));
        Assert.assertEquals((Object)"50", capturedParams.get("X"));
        Assert.assertEquals((Object)"50", capturedParams.get("Y"));
        ((GWC)Mockito.verify((Object)this.mockGWC, (VerificationMode)Mockito.times((int)1))).dispatchOwsRequest((Map)ArgumentMatchers.any(), (Cookie[])ArgumentMatchers.any());
        Mockito.when((Object)this.mockGWC.dispatchOwsRequest((Map)ArgumentMatchers.any(), (Cookie[])ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException("mock exception")});
        try {
            this.layerInfoTileLayer.getFeatureInfo(convTile, bbox, 100, 100, 50, 50);
            Assert.fail((String)"Expected GeoWebCacheException");
        }
        catch (GeoWebCacheException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testGetTileJSON() throws Exception {
        this.layerInfoTileLayer = new GeoServerTileLayer(this.catalog, this.layerInfo.getId(), this.gridSetBroker, (GeoServerTileLayerInfo)TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layerInfo, (GWCConfig)this.defaults));
        ConveyorTile convTile = new ConveyorTile(null, null, null, null);
        convTile.setTileLayer((TileLayer)this.layerInfoTileLayer);
        convTile.setMimeType((MimeType)ApplicationMime.mapboxVector);
        convTile.setGridSetId("EPSG:900913");
        convTile.servletReq = new MockHttpServletRequest();
        Resource mockResult = (Resource)Mockito.mock(Resource.class);
        ArgumentCaptor argument = ArgumentCaptor.forClass(Map.class);
        Mockito.when((Object)this.mockGWC.dispatchOwsRequest((Map)argument.capture(), (Cookie[])ArgumentMatchers.any())).thenReturn((Object)mockResult);
        TileJSON result = this.layerInfoTileLayer.getTileJSON();
        Assert.assertEquals((Object)"test:MockLayerInfoName", (Object)result.getName());
        Assert.assertEquals((Object)"Test resource abstract", (Object)result.getDescription());
        Assert.assertArrayEquals((double[])new double[]{-180.0, 0.0, -90.0, 0.0}, (double[])result.getBounds(), (double)1.0E-6);
        List layers = result.getLayers();
        Assert.assertEquals((long)1L, (long)layers.size());
        VectorLayerMetadata layer = (VectorLayerMetadata)layers.get(0);
        Assert.assertEquals((Object)"MockLayerInfoName", (Object)layer.getId());
        Map fields = layer.getFields();
        Assert.assertEquals((Object)"String", fields.get("stringField"));
        Assert.assertEquals((Object)"Number", fields.get("numberField"));
    }

    @Test
    public void testGetTileJSONLayerGroup() throws Exception {
        WorkspaceInfoImpl workspaceInfo = new WorkspaceInfoImpl();
        workspaceInfo.setName("workspace");
        DataStoreInfoImpl storeInfo = new DataStoreInfoImpl(null);
        storeInfo.setId("mock-store-info");
        storeInfo.setEnabled(true);
        storeInfo.setWorkspace((WorkspaceInfo)workspaceInfo);
        ResourcePool resourcePool = (ResourcePool)Mockito.mock(ResourcePool.class);
        this.catalog = (Catalog)Mockito.mock(Catalog.class);
        Mockito.when((Object)this.catalog.getResourcePool()).thenReturn((Object)resourcePool);
        LayerInfoImpl layerInfo1 = this.createMockVectorLayer(storeInfo, resourcePool, 1);
        LayerInfoImpl layerInfo2 = this.createMockVectorLayer(storeInfo, resourcePool, 2);
        LayerGroupInfoImpl layerGroupVectors = new LayerGroupInfoImpl();
        String layerGroupVectorsId = "mock-layergroup-vectors-id";
        layerGroupVectors.setId("mock-layergroup-vectors-id");
        layerGroupVectors.setName("MockLayerGroupVectors");
        layerGroupVectors.setTitle("Group title");
        layerGroupVectors.setAbstract("Group abstract");
        layerGroupVectors.setLayers(Arrays.asList(layerInfo1, layerInfo2));
        Mockito.when((Object)this.catalog.getLayerGroup((String)ArgumentMatchers.eq((Object)"mock-layergroup-vectors-id"))).thenReturn((Object)layerGroupVectors);
        CoordinateReferenceSystem nativeCrs = CRS.decode((String)"EPSG:4326", (boolean)true);
        ReferencedEnvelope nativeBounds = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, nativeCrs);
        layerGroupVectors.setBounds(nativeBounds);
        GeoServerTileLayer layerGroupInfoVectorTileLayer = new GeoServerTileLayer(this.catalog, layerGroupVectors.getId(), this.gridSetBroker, (GeoServerTileLayerInfo)TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)layerGroupVectors, (GWCConfig)this.defaults));
        ConveyorTile convTile = new ConveyorTile(null, null, null, null);
        convTile.setTileLayer((TileLayer)layerGroupInfoVectorTileLayer);
        convTile.setMimeType((MimeType)ApplicationMime.mapboxVector);
        convTile.setGridSetId("EPSG:900913");
        convTile.servletReq = new MockHttpServletRequest();
        Resource mockResult = (Resource)Mockito.mock(Resource.class);
        ArgumentCaptor argument = ArgumentCaptor.forClass(Map.class);
        Mockito.when((Object)this.mockGWC.dispatchOwsRequest((Map)argument.capture(), (Cookie[])ArgumentMatchers.any())).thenReturn((Object)mockResult);
        TileJSON result = layerGroupInfoVectorTileLayer.getTileJSON();
        Assert.assertEquals((Object)"MockLayerGroupVectors", (Object)result.getName());
        Assert.assertEquals((Object)"Group abstract", (Object)result.getDescription());
        List layers = result.getLayers();
        Assert.assertEquals((long)2L, (long)layers.size());
        int id = 1;
        for (VectorLayerMetadata vectorLayerMetadata : layers) {
            Assert.assertEquals((Object)("MockLayerInfoName" + id), (Object)vectorLayerMetadata.getId());
            Map fields = vectorLayerMetadata.getFields();
            Assert.assertEquals((Object)"String", fields.get("stringField" + id));
            Assert.assertEquals((Object)"Number", fields.get("numberField" + id));
            ++id;
        }
    }

    @Test
    public void testGetTileJSONLayerGroupMixed() throws Exception {
        WorkspaceInfoImpl workspaceInfo = new WorkspaceInfoImpl();
        workspaceInfo.setName("workspace");
        DataStoreInfoImpl storeInfo = new DataStoreInfoImpl(null);
        storeInfo.setId("mock-store-info");
        storeInfo.setEnabled(true);
        storeInfo.setWorkspace((WorkspaceInfo)workspaceInfo);
        ResourcePool resourcePool = (ResourcePool)Mockito.mock(ResourcePool.class);
        this.catalog = (Catalog)Mockito.mock(Catalog.class);
        Mockito.when((Object)this.catalog.getResourcePool()).thenReturn((Object)resourcePool);
        LayerInfoImpl layerInfo1 = this.createMockVectorLayer(storeInfo, resourcePool, 1);
        LayerInfoImpl layerInfo = new LayerInfoImpl();
        CoverageInfoImpl resource = new CoverageInfoImpl(null);
        resource.setId("mock-resource-info");
        resource.setName("MockLayerInfoName");
        resource.setNamespace((NamespaceInfo)this.ns);
        resource.setEnabled(true);
        String layerInfoId = "mock-layer-info";
        layerInfo.setId("mock-layer-info");
        layerInfo.setResource((ResourceInfo)resource);
        layerInfo.setEnabled(true);
        layerInfo.setName("MockLayerInfoName");
        layerInfo.setType(PublishedType.RASTER);
        Mockito.when((Object)this.catalog.getLayer((String)ArgumentMatchers.eq((Object)"mock-layer-info"))).thenReturn((Object)layerInfo);
        LayerGroupInfoImpl layerGroupMixed = new LayerGroupInfoImpl();
        String layerGroupVectorsId = "mock-layergroup-mixed-id";
        layerGroupMixed.setId("mock-layergroup-mixed-id");
        layerGroupMixed.setName("MockLayerGroupMixed");
        layerGroupMixed.setTitle("Group title");
        layerGroupMixed.setAbstract("Group abstract");
        layerGroupMixed.setLayers(Arrays.asList(layerInfo1, layerInfo));
        Mockito.when((Object)this.catalog.getLayerGroup((String)ArgumentMatchers.eq((Object)"mock-layergroup-mixed-id"))).thenReturn((Object)layerGroupMixed);
        CoordinateReferenceSystem nativeCrs = CRS.decode((String)"EPSG:4326", (boolean)true);
        ReferencedEnvelope nativeBounds = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, nativeCrs);
        layerGroupMixed.setBounds(nativeBounds);
        GeoServerTileLayer layerGroupInfoVectorTileLayer = new GeoServerTileLayer(this.catalog, layerGroupMixed.getId(), this.gridSetBroker, (GeoServerTileLayerInfo)TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)layerGroupMixed, (GWCConfig)this.defaults));
        ConveyorTile convTile = new ConveyorTile(null, null, null, null);
        convTile.setTileLayer((TileLayer)layerGroupInfoVectorTileLayer);
        convTile.setMimeType(MimeType.createFromFormat((String)"image/png"));
        convTile.setGridSetId("EPSG:900913");
        convTile.servletReq = new MockHttpServletRequest();
        Resource mockResult = (Resource)Mockito.mock(Resource.class);
        ArgumentCaptor argument = ArgumentCaptor.forClass(Map.class);
        Mockito.when((Object)this.mockGWC.dispatchOwsRequest((Map)argument.capture(), (Cookie[])ArgumentMatchers.any())).thenReturn((Object)mockResult);
        TileJSON result = layerGroupInfoVectorTileLayer.getTileJSON();
        Assert.assertEquals((Object)"MockLayerGroupMixed", (Object)result.getName());
        Assert.assertEquals((Object)"Group abstract", (Object)result.getDescription());
        List layers = result.getLayers();
        Assert.assertEquals((long)0L, (long)layers.size());
    }

    private LayerInfoImpl createMockVectorLayer(DataStoreInfoImpl storeInfo, ResourcePool resourcePool, int id) throws IOException {
        LayerInfoImpl layerInfo = new LayerInfoImpl();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("testType");
        builder.setNamespaceURI("http://goserver.org/test");
        builder.setSRS("EPSG:4326");
        builder.add("stringField" + id, String.class);
        builder.add("numberField" + id, Number.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        FeatureTypeInfoImpl resource = new FeatureTypeInfoImpl(null);
        resource.setStore((StoreInfo)storeInfo);
        resource.setId("mock-resource-info");
        resource.setName("MockLayerInfoName" + id);
        resource.setNamespace((NamespaceInfo)this.ns);
        resource.setTitle("Test resource title");
        resource.setAbstract("Test resource abstract");
        resource.setEnabled(true);
        resource.setDescription("Test resource description");
        resource.setLatLonBoundingBox(new ReferencedEnvelope(-180.0, -90.0, 0.0, 0.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        resource.setNativeBoundingBox(new ReferencedEnvelope(-180.0, -90.0, 0.0, 0.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        resource.setSRS("EPSG:4326");
        String layerInfoId = "mock-layer-info" + id;
        layerInfo.setId(layerInfoId);
        layerInfo.setResource((ResourceInfo)resource);
        layerInfo.setEnabled(true);
        layerInfo.setName("MockLayerInfoName" + id);
        layerInfo.setType(PublishedType.VECTOR);
        Mockito.when((Object)resourcePool.getFeatureType((FeatureTypeInfo)ArgumentMatchers.eq((Object)resource))).thenReturn((Object)featureType);
        Mockito.when((Object)this.catalog.getLayer((String)ArgumentMatchers.eq((Object)layerInfoId))).thenReturn((Object)layerInfo);
        return layerInfo;
    }

    @Test
    public void testGetTilePreconditions() throws Exception {
        long[][] outsideTiles;
        StorageBroker storageBroker = (StorageBroker)Mockito.mock(StorageBroker.class);
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        MockHttpServletRequest servletReq = new MockHttpServletRequest();
        MockHttpServletResponse servletResp = new MockHttpServletResponse();
        ConveyorTile tile = new ConveyorTile(storageBroker, this.layerInfoTileLayer.getName(), (HttpServletRequest)servletReq, (HttpServletResponse)servletResp);
        tile.setMimeType(MimeType.createFromFormat((String)"image/gif"));
        try {
            this.layerInfoTileLayer.getTile(tile);
            Assert.fail((String)"Expected exception, requested mime is invalid for the layer");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is not a supported format"));
        }
        tile.setMimeType(MimeType.createFromFormat((String)"image/png"));
        tile.setGridSetId("EPSG:2003");
        try {
            this.layerInfoTileLayer.getTile(tile);
            Assert.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("gridset not found"));
        }
        for (long[] tileIndex : outsideTiles = new long[][]{{0L, 1L, 1L}, {1L, 1L, 1L}, {1L, 0L, 1L}}) {
            MimeType mimeType = MimeType.createFromFormat((String)"image/png");
            tile = new ConveyorTile(storageBroker, this.layerInfoTileLayer.getName(), "EPSG:900913", tileIndex, mimeType, null, (HttpServletRequest)servletReq, (HttpServletResponse)servletResp);
            try {
                this.layerInfoTileLayer.getTile(tile);
                Assert.fail((String)"Expected outside coverage exception");
            }
            catch (OutsideCoverageException e) {
                Assert.assertTrue((boolean)true);
            }
        }
    }

    @Test
    public void testGetTile() throws Exception {
        long[] tileIndex = new long[]{0L, 0L, 0L};
        GetTileMockTester tester = new GetTileMockTester();
        GeoServerTileLayer tileLayer = tester.prepareTileLayer();
        ConveyorTile conveyorTile = tester.prepareConveyorTile(tileLayer, tileIndex);
        GeoServerTileLayer.WEB_MAP.set(tester.prepareFakeMap());
        ConveyorTile result = tileLayer.getTile(conveyorTile);
        tester.performAssertions(result);
    }

    private FeatureTypeInfo getMockTimeFeatureType() {
        FeatureTypeInfo resource = (FeatureTypeInfo)Mockito.mock(FeatureTypeInfo.class);
        MetadataMap metadata = new MetadataMap();
        DimensionInfoImpl dimension = new DimensionInfoImpl();
        dimension.setUnits("mockUnit");
        metadata.put("time", (Serializable)dimension);
        Mockito.when((Object)resource.getMetadata()).thenReturn((Object)metadata);
        return resource;
    }

    @Test
    public void testGetTileWarningNoSkip() throws Exception {
        long[] tileIndex = new long[]{0L, 0L, 0L};
        GetTileMockTester tester = new GetTileMockTester();
        GeoServerTileLayer tileLayer = tester.prepareTileLayer();
        tileLayer.getInfo().setCacheWarningSkips(Collections.emptySet());
        FeatureTypeInfo resource = this.getMockTimeFeatureType();
        HTTPWarningAppender.addWarning((DimensionWarning)DimensionWarning.defaultValue((ResourceInfo)resource, (String)"time", (Object)new Date()));
        ConveyorTile conveyorTile = tester.prepareConveyorTile(tileLayer, tileIndex);
        GeoServerTileLayer.WEB_MAP.set(tester.prepareFakeMap());
        ConveyorTile result = tileLayer.getTile(conveyorTile);
        tester.performAssertions(result);
    }

    @Test
    public void testGetTileWarningMismatchedSkip() throws Exception {
        long[] tileIndex = new long[]{0L, 0L, 0L};
        GetTileMockTester tester = new GetTileMockTester();
        GeoServerTileLayer tileLayer = tester.prepareTileLayer();
        tileLayer.getInfo().setCacheWarningSkips(Collections.singleton(DimensionWarning.WarningType.Nearest));
        FeatureTypeInfo resource = this.getMockTimeFeatureType();
        HTTPWarningAppender.addWarning((DimensionWarning)DimensionWarning.defaultValue((ResourceInfo)resource, (String)"time", (Object)new Date()));
        ConveyorTile conveyorTile = tester.prepareConveyorTile(tileLayer, tileIndex);
        GeoServerTileLayer.WEB_MAP.set(tester.prepareFakeMap());
        ConveyorTile result = tileLayer.getTile(conveyorTile);
        tester.performAssertions(result);
    }

    @Test
    public void testGetTileWarningSkip() throws Exception {
        long[] tileIndex = new long[]{0L, 0L, 0L};
        GetTileMockTester tester = new GetTileMockTester();
        GeoServerTileLayer tileLayer = tester.prepareTileLayer();
        tileLayer.getInfo().setCacheWarningSkips(new HashSet<DimensionWarning.WarningType>(Arrays.asList(DimensionWarning.WarningType.Nearest, DimensionWarning.WarningType.Default)));
        FeatureTypeInfo resource = this.getMockTimeFeatureType();
        HTTPWarningAppender.addWarning((DimensionWarning)DimensionWarning.defaultValue((ResourceInfo)resource, (String)"time", (Object)new Date()));
        ConveyorTile conveyorTile = tester.prepareConveyorTile(tileLayer, tileIndex);
        GeoServerTileLayer.WEB_MAP.set(tester.prepareFakeMap());
        ConveyorTile result = tileLayer.getTile(conveyorTile);
        ((StorageBroker)Mockito.verify((Object)result.getStorageBroker(), (VerificationMode)Mockito.atLeastOnce())).get((TileObject)ArgumentMatchers.any());
        ((StorageBroker)Mockito.verify((Object)result.getStorageBroker(), (VerificationMode)Mockito.never())).put((TileObject)Mockito.any());
        ((StorageBroker)Mockito.verify((Object)result.getStorageBroker(), (VerificationMode)Mockito.times((int)1))).putTransient((TileObject)Mockito.any());
        ((GWC)Mockito.verify((Object)this.mockGWC, (VerificationMode)Mockito.times((int)1))).getResponseEncoder((MimeType)ArgumentMatchers.eq((Object)result.getMimeType()), (RenderedImageMap)ArgumentMatchers.isA(RenderedImageMap.class));
    }

    @Test
    public void testGetTileWithMetaTilingExecutor() throws Exception {
        GetTileMockTester tester = new GetTileMockTester();
        GeoServerTileLayer tileLayer = tester.prepareTileLayer();
        ExecutorService executorServiceSpy = (ExecutorService)Mockito.spy((Object)Executors.newFixedThreadPool(2));
        Mockito.when((Object)this.mockGWC.getMetaTilingExecutor()).thenReturn((Object)executorServiceSpy);
        this.resource.setLatLonBoundingBox(new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        this.resource.setNativeBoundingBox(new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        int zoomLevel = 4;
        long[] coverage = tileLayer.getGridSubset("EPSG:4326").getCoverage(zoomLevel);
        long[] tileIndex = new long[]{coverage[0], coverage[1], zoomLevel};
        ConveyorTile conveyorTile = tester.prepareConveyorTile(tileLayer, tileIndex);
        Dispatcher.REQUEST.set(new Request());
        GeoServerTileLayer.WEB_MAP.set(tester.prepareFakeMap(1024, 1024));
        ConveyorTile result = tileLayer.getTile(conveyorTile);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getBlob());
        Assert.assertEquals((Object)Conveyor.CacheResult.MISS, (Object)result.getCacheResult());
        Assert.assertEquals((long)200L, (long)result.getStatus());
        executorServiceSpy.awaitTermination(2L, TimeUnit.SECONDS);
        ((ExecutorService)Mockito.verify((Object)executorServiceSpy, (VerificationMode)Mockito.times((int)17))).execute((Runnable)ArgumentMatchers.any());
        ((StorageBroker)Mockito.verify((Object)result.getStorageBroker(), (VerificationMode)Mockito.times((int)16))).put((TileObject)Mockito.any());
    }

    @Test
    public void testGetTileWithMetaTilingExecutorButNoDispatcherRequest() throws Exception {
        GetTileMockTester tester = new GetTileMockTester();
        GeoServerTileLayer tileLayer = tester.prepareTileLayer();
        ExecutorService executorServiceSpy = (ExecutorService)Mockito.spy((Object)Executors.newFixedThreadPool(2));
        Mockito.when((Object)this.mockGWC.getMetaTilingExecutor()).thenReturn((Object)executorServiceSpy);
        this.resource.setLatLonBoundingBox(new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        this.resource.setNativeBoundingBox(new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        int zoomLevel = 4;
        long[] coverage = tileLayer.getGridSubset("EPSG:4326").getCoverage(zoomLevel);
        long[] tileIndex = new long[]{coverage[0], coverage[1], zoomLevel};
        ConveyorTile conveyorTile = tester.prepareConveyorTile(tileLayer, tileIndex);
        Dispatcher.REQUEST.remove();
        GeoServerTileLayer.WEB_MAP.set(tester.prepareFakeMap(1024, 1024));
        ConveyorTile result = tileLayer.getTile(conveyorTile);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getBlob());
        Assert.assertEquals((Object)Conveyor.CacheResult.MISS, (Object)result.getCacheResult());
        Assert.assertEquals((long)200L, (long)result.getStatus());
        executorServiceSpy.awaitTermination(2L, TimeUnit.SECONDS);
        ((ExecutorService)Mockito.verify((Object)executorServiceSpy, (VerificationMode)Mockito.times((int)0))).execute((Runnable)ArgumentMatchers.any());
        ((StorageBroker)Mockito.verify((Object)result.getStorageBroker(), (VerificationMode)Mockito.times((int)16))).put((TileObject)Mockito.any());
    }

    @Test
    public void testGetTileWithNullMetaTilingExecutor() throws Exception {
        GetTileMockTester tester = new GetTileMockTester();
        GeoServerTileLayer tileLayer = tester.prepareTileLayer();
        Mockito.when((Object)this.mockGWC.getMetaTilingExecutor()).thenReturn(null);
        this.resource.setLatLonBoundingBox(new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        this.resource.setNativeBoundingBox(new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        int zoomLevel = 4;
        long[] coverage = tileLayer.getGridSubset("EPSG:4326").getCoverage(zoomLevel);
        long[] tileIndex = new long[]{coverage[0], coverage[1], zoomLevel};
        ConveyorTile conveyorTile = tester.prepareConveyorTile(tileLayer, tileIndex);
        GeoServerTileLayer.WEB_MAP.set(tester.prepareFakeMap(1024, 1024));
        ConveyorTile result = tileLayer.getTile(conveyorTile);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getBlob());
        Assert.assertEquals((Object)Conveyor.CacheResult.MISS, (Object)result.getCacheResult());
        Assert.assertEquals((long)200L, (long)result.getStatus());
        ((StorageBroker)Mockito.verify((Object)result.getStorageBroker(), (VerificationMode)Mockito.times((int)16))).put((TileObject)Mockito.any());
    }

    @Test
    public void testExpireClientsDisabledLayer() {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        int expire = this.layerInfoTileLayer.getExpireClients(0);
        Assert.assertEquals((long)0L, (long)expire);
    }

    @Test
    public void testExpireClientsEnabledLayer() {
        ((ResourceInfoImpl)this.layerInfo.getResource()).setMetadata(this.getCachingEnabledMetadata(123));
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        int expire = this.layerInfoTileLayer.getExpireClients(0);
        Assert.assertEquals((long)123L, (long)expire);
    }

    @Test
    public void testExpireClientsDisabledLayerGroup() {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        int expire = this.layerInfoTileLayer.getExpireClients(0);
        Assert.assertEquals((long)0L, (long)expire);
    }

    @Test
    public void testExpireClientsEnabledLayerGroup() {
        this.layerGroup.setMetadata(this.getCachingEnabledMetadata(123));
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        int expire = this.layerInfoTileLayer.getExpireClients(0);
        Assert.assertEquals((long)123L, (long)expire);
    }

    @Test
    public void testExpireClientsEnabledLayerGroupLayerInfoLower() {
        ((ResourceInfoImpl)this.layerInfo.getResource()).setMetadata(this.getCachingEnabledMetadata(122));
        this.layerGroup.setMetadata(this.getCachingEnabledMetadata(123));
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        int expire = this.layerInfoTileLayer.getExpireClients(0);
        Assert.assertEquals((long)123L, (long)expire);
    }

    @Test
    public void testExpireClientsEnabledLayerGroupLayerInfoHigher() {
        ((ResourceInfoImpl)this.layerInfo.getResource()).setMetadata(this.getCachingEnabledMetadata(124));
        this.layerGroup.setMetadata(this.getCachingEnabledMetadata(123));
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        int expire = this.layerInfoTileLayer.getExpireClients(0);
        Assert.assertEquals((long)123L, (long)expire);
    }

    private MetadataMap getCachingEnabledMetadata(int maxAgeValue) {
        HashMap<String, Comparable<Boolean>> mapItems = new HashMap<String, Comparable<Boolean>>();
        mapItems.put("cachingEnabled", Boolean.TRUE);
        mapItems.put("cacheAgeMax", Integer.valueOf(maxAgeValue));
        return new MetadataMap(mapItems);
    }

    @Test
    public void testGetMimeTypes() throws Exception {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        List mimeTypes = this.layerInfoTileLayer.getMimeTypes();
        Assert.assertEquals((long)this.defaults.getDefaultOtherCacheFormats().size(), (long)mimeTypes.size());
        this.layerInfoTileLayer.getInfo().getMimeFormats().clear();
        this.layerInfoTileLayer.getInfo().getMimeFormats().add("image/gif");
        mimeTypes = this.layerInfoTileLayer.getMimeTypes();
        Assert.assertEquals((long)1L, (long)mimeTypes.size());
        Assert.assertEquals((Object)MimeType.createFromFormat((String)"image/gif"), mimeTypes.get(0));
    }

    @Test
    public void testTileExpirationList() {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        ArrayList<ExpirationRule> list = new ArrayList<ExpirationRule>();
        list.add(new ExpirationRule(0, 10));
        list.add(new ExpirationRule(10, 20));
        this.layerInfoTileLayer.getInfo().setExpireCacheList(list);
        Assert.assertEquals((long)10L, (long)this.layerInfoTileLayer.getExpireCache(0));
        Assert.assertEquals((long)10L, (long)this.layerInfoTileLayer.getExpireCache(9));
        Assert.assertEquals((long)20L, (long)this.layerInfoTileLayer.getExpireCache(10));
        Assert.assertEquals((long)20L, (long)this.layerInfoTileLayer.getExpireCache(15));
        Assert.assertEquals((long)0L, (long)this.layerInfoTileLayer.getExpireCache(-1));
    }

    @Test
    public void testCacheExpiration() {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        Assert.assertEquals((long)0L, (long)this.layerInfoTileLayer.getInfo().getExpireCache());
        this.layerInfoTileLayer.getInfo().setExpireCache(40);
        Assert.assertEquals((long)40L, (long)this.layerInfoTileLayer.getInfo().getExpireCache());
    }

    @Test
    public void testAdvertised() {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        Assert.assertTrue((boolean)this.layerInfoTileLayer.isAdvertised());
    }

    @Test
    public void testTransient() {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        Assert.assertFalse((boolean)this.layerInfoTileLayer.isTransientLayer());
    }

    @Test
    public void testGetPublishedInfo() {
        this.layerInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        MatcherAssert.assertThat((Object)this.layerInfoTileLayer.getPublishedInfo(), (Matcher)Matchers.instanceOf(LayerInfo.class));
        this.layerGroupInfoTileLayer = new GeoServerTileLayer((PublishedInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        MatcherAssert.assertThat((Object)this.layerGroupInfoTileLayer.getPublishedInfo(), (Matcher)Matchers.instanceOf(LayerGroupInfo.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetLayerNameForGetCapabilitiesRequest() throws NoSuchFieldException, IllegalAccessException {
        NamespaceInfoImpl nameSpaceA = new NamespaceInfoImpl();
        nameSpaceA.setPrefix("workspace-a");
        nameSpaceA.setURI("http://goserver.org/test");
        WorkspaceInfoImpl workspaceA = new WorkspaceInfoImpl();
        workspaceA.setName("workspace-a");
        Mockito.when((Object)this.catalog.getWorkspaceByName("workspace-a")).thenReturn((Object)workspaceA);
        FeatureTypeInfoImpl resourceA = new FeatureTypeInfoImpl(null);
        resourceA.setNamespace((NamespaceInfo)nameSpaceA);
        LayerInfoImpl layerA = new LayerInfoImpl();
        layerA.setResource((ResourceInfo)resourceA);
        layerA.setName("layer-a");
        layerA.setId("layer-a");
        Mockito.when((Object)this.catalog.getLayer("layer-a")).thenReturn((Object)layerA);
        LayerGroupInfoImpl layerGroupA = new LayerGroupInfoImpl();
        layerGroupA.setName("random-prefix:layer-group-a");
        layerGroupA.setId("layer-group-a");
        layerGroupA.setLayers(Collections.singletonList(layerA));
        Mockito.when((Object)this.catalog.getLayerGroup("layer-group-a")).thenReturn((Object)layerGroupA);
        GeoServerTileLayer tileLayerA = new GeoServerTileLayer((PublishedInfo)layerA, this.defaults, this.gridSetBroker);
        GeoServerTileLayer tileLayerB = new GeoServerTileLayer((PublishedInfo)layerGroupA, this.defaults, this.gridSetBroker);
        Field catalogField = GeoServerTileLayer.class.getDeclaredField("catalog");
        catalogField.setAccessible(true);
        catalogField.set(tileLayerA, this.catalog);
        catalogField.set(tileLayerB, this.catalog);
        GwcServiceDispatcherCallback.GWC_OPERATION.remove();
        MatcherAssert.assertThat((Object)tileLayerA.getName(), (Matcher)Matchers.is((Object)"workspace-a:layer-a"));
        MatcherAssert.assertThat((Object)tileLayerB.getName(), (Matcher)Matchers.is((Object)"random-prefix:layer-group-a"));
        GwcServiceDispatcherCallback.GWC_OPERATION.set("some-operation");
        MatcherAssert.assertThat((Object)tileLayerA.getName(), (Matcher)Matchers.is((Object)"workspace-a:layer-a"));
        MatcherAssert.assertThat((Object)tileLayerB.getName(), (Matcher)Matchers.is((Object)"random-prefix:layer-group-a"));
        GwcServiceDispatcherCallback.GWC_OPERATION.set("GetCapabilities");
        MatcherAssert.assertThat((Object)tileLayerA.getName(), (Matcher)Matchers.is((Object)"workspace-a:layer-a"));
        MatcherAssert.assertThat((Object)tileLayerB.getName(), (Matcher)Matchers.is((Object)"random-prefix:layer-group-a"));
        try {
            LocalWorkspace.set((WorkspaceInfo)workspaceA);
            GwcServiceDispatcherCallback.GWC_OPERATION.remove();
            MatcherAssert.assertThat((Object)tileLayerA.getName(), (Matcher)Matchers.is((Object)"workspace-a:layer-a"));
            MatcherAssert.assertThat((Object)tileLayerB.getName(), (Matcher)Matchers.is((Object)"random-prefix:layer-group-a"));
            GwcServiceDispatcherCallback.GWC_OPERATION.set("some-operation");
            MatcherAssert.assertThat((Object)tileLayerA.getName(), (Matcher)Matchers.is((Object)"workspace-a:layer-a"));
            MatcherAssert.assertThat((Object)tileLayerB.getName(), (Matcher)Matchers.is((Object)"random-prefix:layer-group-a"));
            GwcServiceDispatcherCallback.GWC_OPERATION.set("GetCapabilities");
            MatcherAssert.assertThat((Object)tileLayerA.getName(), (Matcher)Matchers.is((Object)"layer-a"));
            MatcherAssert.assertThat((Object)tileLayerB.getName(), (Matcher)Matchers.is((Object)"random-prefix:layer-group-a"));
        }
        finally {
            LocalWorkspace.remove();
        }
    }

    @Test
    public void testGetMetadataUrlsFromLayer() throws MalformedURLException {
        this.setupUrlContext();
        GeoServerTileLayer tileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        List metadata = tileLayer.getMetadataURLs();
        MatcherAssert.assertThat((Object)metadata.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MetadataURL)metadata.get(0)).getType(), (Matcher)Matchers.is((Object)"metadata-type"));
        MatcherAssert.assertThat((Object)((MetadataURL)metadata.get(0)).getFormat(), (Matcher)Matchers.is((Object)"metadata-format"));
        MatcherAssert.assertThat((Object)((MetadataURL)metadata.get(0)).getUrl(), (Matcher)Matchers.is((Object)new URL("http://localhost:8080/geoserver/metadata-content")));
    }

    @Test
    public void testGetMetadataUrlsFromLayerGroup() throws MalformedURLException {
        this.setupUrlContext();
        GeoServerTileLayer tileLayer = new GeoServerTileLayer((PublishedInfo)this.layerGroup, this.defaults, this.gridSetBroker);
        List metadata = tileLayer.getMetadataURLs();
        MatcherAssert.assertThat((Object)metadata.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((MetadataURL)metadata.get(0)).getType(), (Matcher)Matchers.is((Object)"metadata-type"));
        MatcherAssert.assertThat((Object)((MetadataURL)metadata.get(0)).getFormat(), (Matcher)Matchers.is((Object)"metadata-format"));
        MatcherAssert.assertThat((Object)((MetadataURL)metadata.get(0)).getUrl(), (Matcher)Matchers.is((Object)new URL("http://localhost:8080/geoserver/metadata-content")));
    }

    @Test
    public void testGetLegendsLayer() throws Exception {
        this.setupUrlContext();
        LegendSample legendSample = (LegendSample)Mockito.mock(LegendSample.class);
        Mockito.when((Object)legendSample.getLegendURLSize((StyleInfo)ArgumentMatchers.any(StyleInfo.class))).thenReturn((Object)new Dimension(120, 150));
        WMS wms = (WMS)Mockito.mock(WMS.class);
        GetLegendGraphicOutputFormat outputFormat = (GetLegendGraphicOutputFormat)Mockito.mock(GetLegendGraphicOutputFormat.class);
        Mockito.when((Object)wms.getLegendGraphicOutputFormat("image/png")).thenReturn((Object)outputFormat);
        GeoServerTileLayer tileLayer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        tileLayer.setLegendSample(legendSample);
        tileLayer.setWms(wms);
        Map legendsInfo = tileLayer.getLayerLegendsInfo();
        MatcherAssert.assertThat((Object)legendsInfo.size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)((LegendInfo)legendsInfo.get("default_style")), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)((LegendInfo)legendsInfo.get("default_style")).getWidth(), (Matcher)Matchers.is((Object)120));
        MatcherAssert.assertThat((Object)((LegendInfo)legendsInfo.get("default_style")).getHeight(), (Matcher)Matchers.is((Object)150));
        MatcherAssert.assertThat((Object)((LegendInfo)legendsInfo.get("default_style")).getFormat(), (Matcher)Matchers.is((Object)"image/png"));
        MatcherAssert.assertThat((Object)((LegendInfo)legendsInfo.get("default_style")).getLegendUrl(), (Matcher)Matchers.is((Object)"http://localhost:8080/geoserver/ows?service=WMS&request=GetLegendGraphic&version=1.1.0&format=image%2Fpng&width=120&height=150&layer=workspace%3AMockLayerInfoName"));
        MatcherAssert.assertThat((Object)((LegendInfo)legendsInfo.get("alternateStyle-1")), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)((LegendInfo)legendsInfo.get("alternateStyle-1")).getWidth(), (Matcher)Matchers.is((Object)120));
        MatcherAssert.assertThat((Object)((LegendInfo)legendsInfo.get("alternateStyle-1")).getHeight(), (Matcher)Matchers.is((Object)150));
        MatcherAssert.assertThat((Object)((LegendInfo)legendsInfo.get("alternateStyle-1")).getFormat(), (Matcher)Matchers.is((Object)"image/png"));
        MatcherAssert.assertThat((Object)((LegendInfo)legendsInfo.get("alternateStyle-1")).getLegendUrl(), (Matcher)Matchers.is((Object)"http://localhost:8080/geoserver/ows?service=WMS&request=GetLegendGraphic&version=1.1.0&format=image%2Fpng&width=120&height=150&layer=workspace%3AMockLayerInfoName&style=alternateStyle-1"));
        MatcherAssert.assertThat((Object)((LegendInfo)legendsInfo.get("alternateStyle-2")), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)((LegendInfo)legendsInfo.get("alternateStyle-2")).getWidth(), (Matcher)Matchers.is((Object)150));
        MatcherAssert.assertThat((Object)((LegendInfo)legendsInfo.get("alternateStyle-2")).getHeight(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)((LegendInfo)legendsInfo.get("alternateStyle-2")).getFormat(), (Matcher)Matchers.is((Object)"image/png"));
        MatcherAssert.assertThat((Object)((LegendInfo)legendsInfo.get("alternateStyle-2")).getLegendUrl().trim(), (Matcher)Matchers.is((Object)"http://localhost:8080/geoserver/some-url"));
    }

    @Test
    public void testReaderDisposeCalledOnMetaTileImage() {
        Object reader = Mockito.mock(ImageReader.class);
        RenderedImageTimeDecorator metaTile = this.getMockRenderedImageTimeDecoratorWithParameters(reader);
        GeoServerMetaTile gsMetaTile = this.getTestGeoServerMetaTile();
        gsMetaTile.setImage((RenderedImage)metaTile);
        gsMetaTile.dispose();
        ((ImageReader)Mockito.verify((Object)((ImageReader)reader), (VerificationMode)Mockito.times((int)1))).dispose();
    }

    @Test
    public void testImageInputStreamIsClosedForMetaTileImage() {
        Object imageInputStream = Mockito.mock(ImageInputStream.class);
        RenderedImageTimeDecorator metaTile = this.getMockRenderedImageTimeDecoratorWithParameters(imageInputStream);
        GeoServerMetaTile gsMetaTile = this.getTestGeoServerMetaTile();
        gsMetaTile.setImage((RenderedImage)metaTile);
        gsMetaTile.dispose();
        try {
            ((ImageInputStream)Mockito.verify((Object)((ImageInputStream)imageInputStream), (VerificationMode)Mockito.times((int)1))).close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "", e);
        }
    }

    private RenderedImageTimeDecorator getMockRenderedImageTimeDecoratorWithParameters(Object param) {
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(param);
        RenderedOp image = (RenderedOp)Mockito.mock(RenderedOp.class);
        Mockito.when((Object)image.getParameterBlock()).thenReturn((Object)parameterBlock);
        RenderedImageTimeDecorator metaTile = (RenderedImageTimeDecorator)Mockito.mock(RenderedImageTimeDecorator.class);
        Mockito.when((Object)metaTile.getDelegate()).thenReturn((Object)image);
        return metaTile;
    }

    private GeoServerMetaTile getTestGeoServerMetaTile() {
        long[] testArray = new long[]{1L, 1L, 1L, 1L, 1L};
        GridSubset mockGridSubset = (GridSubset)Mockito.mock(GridSubset.class);
        Mockito.when((Object)mockGridSubset.getTileWidth()).thenReturn((Object)0);
        Mockito.when((Object)mockGridSubset.getTileHeight()).thenReturn((Object)0);
        Mockito.when((Object)mockGridSubset.getCoverage(1)).thenReturn((Object)testArray);
        Mockito.when((Object)mockGridSubset.boundsFromRectangle(testArray)).thenReturn((Object)((BoundingBox)Mockito.mock(BoundingBox.class)));
        GeoServerMetaTile gsMetaTile = new GeoServerMetaTile(mockGridSubset, (MimeType)Mockito.mock(MimeType.class), (FormatModifier)Mockito.mock(FormatModifier.class), testArray, 1, 1, Integer.valueOf(4));
        return gsMetaTile;
    }

    private void setupUrlContext() {
        Request request = (Request)Mockito.mock(Request.class);
        HttpServletRequest httpRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getHttpRequest()).thenReturn((Object)httpRequest);
        Mockito.when((Object)httpRequest.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)httpRequest.getServerName()).thenReturn((Object)"localhost");
        Mockito.when((Object)httpRequest.getServerPort()).thenReturn((Object)8080);
        Mockito.when((Object)httpRequest.getContextPath()).thenReturn((Object)"/geoserver");
        Dispatcher.REQUEST.set(request);
    }

    @Test
    public void testGridsetNames() {
        this.resource.setLatLonBoundingBox(new ReferencedEnvelope());
        GeoServerTileLayer layer = new GeoServerTileLayer((PublishedInfo)this.layerInfo, this.defaults, this.gridSetBroker);
        MatcherAssert.assertThat((Object)layer.getGridSubsets(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"EPSG:4326", "EPSG:900913"}));
        this.resource.setLatLonBoundingBox(new ReferencedEnvelope(-180.0, 0.0, -90.0, 0.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        GridSubset subset = layer.getGridSubset("EPSG:4326");
        Assert.assertArrayEquals((long[])new long[]{0L, 1L, 0L, 0L, 1L}, (long[])subset.getCoverage(1));
    }

    @Test
    public void testGetPublishedInfoOnRaceCondition() throws Exception {
        GeoServerTileLayer tileLayer = new GeoServerTileLayer(this.catalog, this.layerInfo.getId(), this.gridSetBroker, (GeoServerTileLayerInfo)TileLayerInfoUtil.loadOrCreate((LayerInfo)this.layerInfo, (GWCConfig)this.defaults));
        int parallelism = Runtime.getRuntime().availableProcessors();
        ExecutorService pool = Executors.newFixedThreadPool(parallelism);
        List results = IntStream.range(0, parallelism).mapToObj(i -> pool.submit(() -> ((GeoServerTileLayer)tileLayer).getPublishedInfo())).collect(Collectors.toList());
        for (Future result : results) {
            Assert.assertNotNull(result.get());
        }
        pool.shutdown();
    }

    protected class GetTileMockTester {
        protected GetTileMockTester() {
        }

        public GeoServerTileLayer prepareTileLayer() throws Exception {
            Resource mockResult = (Resource)Mockito.mock(Resource.class);
            ArgumentCaptor argument = ArgumentCaptor.forClass(Map.class);
            Mockito.when((Object)GeoServerTileLayerTest.this.mockGWC.dispatchOwsRequest((Map)argument.capture(), (Cookie[])ArgumentMatchers.any())).thenReturn((Object)mockResult);
            return new GeoServerTileLayer((PublishedInfo)GeoServerTileLayerTest.this.layerInfo, GeoServerTileLayerTest.this.defaults, GeoServerTileLayerTest.this.gridSetBroker);
        }

        public RenderedImageMap prepareFakeMap() {
            return this.prepareFakeMap(256, 256);
        }

        public RenderedImageMap prepareFakeMap(int width, int height) {
            BufferedImage image = new BufferedImage(width, height, 2);
            return new RenderedImageMap(new WMSMapContent(), (RenderedImage)image, "image/png");
        }

        public ConveyorTile prepareConveyorTile(GeoServerTileLayer tileLayer, long[] tileIndex) throws Exception {
            MockHttpServletRequest servletReq = new MockHttpServletRequest();
            MockHttpServletResponse servletResp = new MockHttpServletResponse();
            RenderedImageMapResponse fakeResponseEncoder = (RenderedImageMapResponse)Mockito.mock(RenderedImageMapResponse.class);
            MimeType mimeType = MimeType.createFromFormat((String)"image/png");
            Mockito.when((Object)GeoServerTileLayerTest.this.mockGWC.getResponseEncoder((MimeType)ArgumentMatchers.eq((Object)mimeType), (RenderedImageMap)ArgumentMatchers.any())).thenReturn((Object)fakeResponseEncoder);
            StorageBroker storageBroker = (StorageBroker)Mockito.mock(StorageBroker.class);
            Mockito.when((Object)storageBroker.get((TileObject)ArgumentMatchers.any())).thenReturn((Object)false);
            return new ConveyorTile(storageBroker, tileLayer.getName(), "EPSG:4326", tileIndex, mimeType, null, (HttpServletRequest)servletReq, (HttpServletResponse)servletResp);
        }

        protected void performAssertions(ConveyorTile result) throws Exception {
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull((Object)result.getBlob());
            Assert.assertEquals((Object)Conveyor.CacheResult.MISS, (Object)result.getCacheResult());
            Assert.assertEquals((long)200L, (long)result.getStatus());
            ((StorageBroker)Mockito.verify((Object)result.getStorageBroker(), (VerificationMode)Mockito.atLeastOnce())).get((TileObject)ArgumentMatchers.any());
            ((StorageBroker)Mockito.verify((Object)result.getStorageBroker(), (VerificationMode)Mockito.times((int)1))).put((TileObject)Mockito.any());
            ((StorageBroker)Mockito.verify((Object)result.getStorageBroker(), (VerificationMode)Mockito.never())).putTransient((TileObject)Mockito.any());
            ((GWC)Mockito.verify((Object)GeoServerTileLayerTest.this.mockGWC, (VerificationMode)Mockito.times((int)1))).getResponseEncoder((MimeType)ArgumentMatchers.eq((Object)result.getMimeType()), (RenderedImageMap)ArgumentMatchers.isA(RenderedImageMap.class));
        }
    }
}

