/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import java.beans.Introspector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.gwc.GWCTestHelpers;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.filter.parameters.FloatParameterFilter;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.grid.BoundingBox;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GeoServerTileLayerInfoSerializableTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private GeoServerTileLayerInfo info;
    private GWCConfig defaults;
    private GeoServerTileLayerInfo defaultVectorInfo;

    @Before
    public void setUp() throws Exception {
        this.info = new GeoServerTileLayerInfoImpl();
        this.defaults = GWCConfig.getOldDefaults();
        this.defaultVectorInfo = TileLayerInfoUtil.create((GWCConfig)this.defaults);
        this.defaultVectorInfo.getMimeFormats().clear();
        this.defaultVectorInfo.getMimeFormats().addAll(this.defaults.getDefaultVectorCacheFormats());
    }

    <T> Matcher<T> sameProperty(T expected, String property) throws Exception {
        return this.sameProperty(expected, property, Matchers::is);
    }

    <T> Matcher<T> sameProperty(T expected, String property, Function<?, Matcher<?>> valueMatcher) throws Exception {
        Object value = Arrays.stream(Introspector.getBeanInfo(expected.getClass()).getPropertyDescriptors()).filter(p -> p.getName().equals(property)).findAny().orElseThrow(() -> new IllegalArgumentException("bean expected lacks the property " + property)).getReadMethod().invoke(expected, new Object[0]);
        return Matchers.hasProperty((String)property, valueMatcher.apply(value));
    }

    private GeoServerTileLayerInfo testMarshaling(GeoServerTileLayerInfo info) throws Exception {
        GeoServerTileLayerInfo unmarshalled;
        File f = this.temp.newFile();
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(f));){
            out.writeObject(info);
        }
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(f));){
            unmarshalled = (GeoServerTileLayerInfo)in.readObject();
        }
        MatcherAssert.assertThat((Object)unmarshalled, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)unmarshalled, this.sameProperty(info, "enabled"));
        MatcherAssert.assertThat((Object)unmarshalled, this.sameProperty(info, "autoCacheStyles"));
        MatcherAssert.assertThat((Object)unmarshalled, this.sameProperty(info, "gutter"));
        MatcherAssert.assertThat((Object)unmarshalled, this.sameProperty(info, "metaTilingX"));
        MatcherAssert.assertThat((Object)unmarshalled, this.sameProperty(info, "metaTilingY"));
        MatcherAssert.assertThat((Object)unmarshalled, this.sameProperty(info, "gridSubsets"));
        MatcherAssert.assertThat((Object)unmarshalled, this.sameProperty(info, "mimeFormats"));
        MatcherAssert.assertThat((Object)unmarshalled, this.sameProperty(info, "parameterFilters"));
        MatcherAssert.assertThat((Object)unmarshalled, (Matcher)Matchers.equalTo((Object)info));
        MatcherAssert.assertThat((String)"cachedStyles", (Object)unmarshalled.cachedStyles(), (Matcher)Matchers.equalTo((Object)info.cachedStyles()));
        return unmarshalled;
    }

    @Test
    public void testMarshallingDefaults() throws Exception {
        GWCConfig oldDefaults = GWCConfig.getOldDefaults();
        LayerInfoImpl layerInfo = GWCTestHelpers.mockLayer("testLayer", new String[0], PublishedType.RASTER);
        this.info = TileLayerInfoUtil.loadOrCreate((LayerInfo)layerInfo, (GWCConfig)oldDefaults);
        this.testMarshaling(this.info);
    }

    @Test
    public void testMarshallingBlobStoreId() throws Exception {
        GWCConfig oldDefaults = GWCConfig.getOldDefaults();
        LayerInfoImpl layerInfo = GWCTestHelpers.mockLayer("testLayer", new String[0], PublishedType.RASTER);
        this.info = TileLayerInfoUtil.loadOrCreate((LayerInfo)layerInfo, (GWCConfig)oldDefaults);
        this.info.setBlobStoreId("myBlobStore");
        GeoServerTileLayerInfo unmarshalled = this.testMarshaling(this.info);
        MatcherAssert.assertThat((Object)unmarshalled, (Matcher)Matchers.hasProperty((String)"blobStoreId", (Matcher)Matchers.is((Object)"myBlobStore")));
    }

    @Test
    public void testMarshallingGridSubsets() throws Exception {
        ArrayList<XMLGridSubset> subsets = new ArrayList<XMLGridSubset>();
        XMLGridSubset subset = new XMLGridSubset();
        subset.setGridSetName("EPSG:4326");
        subset.setZoomStart(Integer.valueOf(1));
        subset.setZoomStop(Integer.valueOf(10));
        subset.setExtent(new BoundingBox(0.0, 0.0, 180.0, 90.0));
        subsets.add(subset);
        subset = new XMLGridSubset();
        subset.setGridSetName("EPSG:900913");
        subsets.add(subset);
        subset = new XMLGridSubset();
        subset.setGridSetName("GlobalCRS84Scale");
        subset.setZoomStart(Integer.valueOf(4));
        subset.setExtent(new BoundingBox(-100.0, -40.0, 100.0, 40.0));
        subsets.add(subset);
        this.info.getGridSubsets().add((XMLGridSubset)subsets.get(0));
        this.testMarshaling(this.info);
        this.info.getGridSubsets().clear();
        this.info.getGridSubsets().add((XMLGridSubset)subsets.get(1));
        this.testMarshaling(this.info);
        this.info.getGridSubsets().clear();
        this.info.getGridSubsets().add((XMLGridSubset)subsets.get(2));
        this.testMarshaling(this.info);
        this.info.getGridSubsets().addAll(subsets);
        this.testMarshaling(this.info);
    }

    @Test
    public void testMarshallingParameterFilters() throws Exception {
        StringParameterFilter strParam = new StringParameterFilter();
        strParam.setKey("TIME");
        strParam.setDefaultValue("now");
        ArrayList<String> strValues = new ArrayList<String>(strParam.getValues());
        strValues.addAll(Arrays.asList("today", "yesterday", "tomorrow"));
        strParam.setValues(strValues);
        RegexParameterFilter regExParam = new RegexParameterFilter();
        regExParam.setKey("CQL_FILTER");
        regExParam.setDefaultValue("INCLUDE");
        regExParam.setRegex(".*");
        FloatParameterFilter floatParam = new FloatParameterFilter();
        floatParam.setKey("ENV");
        floatParam.setThreshold(Float.valueOf(1.0E-4f));
        ArrayList<Float> floatValues = new ArrayList<Float>(floatParam.getValues());
        floatValues.addAll(Arrays.asList(Float.valueOf(1.0f), Float.valueOf(1.5f), Float.valueOf(2.0f), Float.valueOf(2.5f)));
        floatParam.setValues(floatValues);
        this.info.getParameterFilters().clear();
        this.testMarshaling(this.info);
        this.info.getParameterFilters().clear();
        this.info.getParameterFilters().add(strParam);
        this.testMarshaling(this.info);
        this.info.getParameterFilters().clear();
        this.info.getParameterFilters().add(regExParam);
        this.testMarshaling(this.info);
        this.info.getParameterFilters().clear();
        this.info.getParameterFilters().add(floatParam);
        this.testMarshaling(this.info);
        this.info.getParameterFilters().clear();
        this.info.getParameterFilters().add(strParam);
        this.info.getParameterFilters().add(regExParam);
        this.info.getParameterFilters().add(floatParam);
        this.testMarshaling(this.info);
        StringParameterFilter strParam2 = new StringParameterFilter();
        strParam2.setKey("ELEVATION");
        strParam2.setDefaultValue("1");
        ArrayList<String> strValues2 = new ArrayList<String>(strParam2.getValues());
        strValues2.addAll(Arrays.asList("1", "2", "3"));
        strParam2.setValues(strValues2);
        this.info.getParameterFilters().add(strParam2);
        this.testMarshaling(this.info);
    }
}

