/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.GWCSynchEnv;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.gwc.layer.DefaultTileLayerCatalog;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.TileLayerCatalog;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.MockWepAppContextRule;
import org.geowebcache.config.ConfigurationResourceProvider;
import org.geowebcache.config.LayerConfigurationTest;
import org.geowebcache.config.TileLayerConfiguration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.layer.AbstractTileLayer;
import org.geowebcache.layer.TileLayer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CatalogConfigurationLayerConformanceTest
extends LayerConfigurationTest {
    @Rule
    public MockWepAppContextRule context = new MockWepAppContextRule();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private GWCConfig gwcConfig;
    private GridSetBroker gsBroker;
    Map<String, PublishedInfo> layerCatalog = new HashMap<String, PublishedInfo>();
    private GWC mediator;
    private GWCSynchEnv synchEnv;
    private Catalog catalog;
    private File dataDir;

    protected void doModifyInfo(TileLayer info, int rand) throws Exception {
        info.setBlobStoreId(Integer.toString(rand));
    }

    protected TileLayer getGoodInfo(String id, int rand) throws Exception {
        PublishedInfo pinfo = this.layerCatalog.computeIfAbsent(id, name -> {
            LayerGroupInfo info = (LayerGroupInfo)EasyMock.createMock((String)("TestPublished_" + id), LayerGroupInfo.class);
            MetadataMap mMap = new MetadataMap();
            EasyMock.expect((Object)info.getMetadata()).andStubReturn((Object)mMap);
            EasyMock.expect((Object)info.prefixedName()).andStubReturn((Object)id);
            EasyMock.expect((Object)info.getId()).andStubReturn((Object)id);
            EasyMock.replay((Object[])new Object[]{info});
            return info;
        });
        GeoServerTileLayer layer = new GeoServerTileLayer(pinfo, this.gwcConfig, this.gsBroker);
        this.doModifyInfo((TileLayer)layer, rand);
        return layer;
    }

    protected TileLayer getBadInfo(final String id, int rand) throws Exception {
        return new AbstractTileLayer(){

            public String getName() {
                return id;
            }

            protected boolean initializeInternal(GridSetBroker gridSetBroker) {
                return false;
            }

            public String getStyles() {
                return null;
            }

            public ConveyorTile getTile(ConveyorTile tile) throws GeoWebCacheException, IOException, OutsideCoverageException {
                return null;
            }

            public ConveyorTile getNoncachedTile(ConveyorTile tile) throws GeoWebCacheException {
                return null;
            }

            public void seedTile(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException, IOException {
            }

            public ConveyorTile doNonMetatilingRequest(ConveyorTile tile) throws GeoWebCacheException {
                return null;
            }
        };
    }

    protected String getExistingInfo() {
        Assume.assumeTrue((boolean)false);
        return null;
    }

    protected TileLayerConfiguration getConfig() throws Exception {
        this.catalog = (Catalog)EasyMock.createMock((String)"catalog", Catalog.class);
        this.gsBroker = (GridSetBroker)EasyMock.createMock((String)"gsBroker", GridSetBroker.class);
        this.mediator = (GWC)EasyMock.createMock((String)"mediator", GWC.class);
        this.synchEnv = (GWCSynchEnv)EasyMock.createMock((String)"synchEnv", GWCSynchEnv.class);
        EasyMock.expect((Object)this.mediator.getGwcSynchEnv()).andReturn((Object)this.synchEnv).anyTimes();
        this.synchEnv.syncEnv();
        EasyMock.expectLastCall().andVoid().anyTimes();
        this.mediator.layerAdded((String)EasyMock.anyObject(String.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)this.mediator.layerRemoved((String)EasyMock.anyObject(String.class))).andStubReturn((Object)true);
        this.mediator.layerRenamed((String)EasyMock.anyObject(String.class), (String)EasyMock.anyObject(String.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.catalog, this.gsBroker, this.mediator, this.synchEnv});
        this.context.addBean("mediator", (Object)this.mediator, new Class[]{GWC.class});
        GWC.set((GWC)this.mediator, (GWCSynchEnv)this.synchEnv);
        this.gwcConfig = new GWCConfig();
        this.dataDir = this.temp.newFolder();
        GeoServerResourceLoader resourceLoader = new GeoServerResourceLoader(this.dataDir);
        XMLConfiguration xmlConfig = new XMLConfiguration(this.context.getContextProvider(), (ConfigurationResourceProvider)null);
        DefaultTileLayerCatalog tlCatalog = new DefaultTileLayerCatalog(resourceLoader, xmlConfig);
        tlCatalog.initialize();
        return new CatalogConfiguration(this.catalog, (TileLayerCatalog)tlCatalog, this.gsBroker);
    }

    @After
    public void removeMediator() throws Exception {
        GWC.set(null, null);
    }

    protected TileLayerConfiguration getSecondConfig() throws Exception {
        this.gwcConfig = new GWCConfig();
        GeoServerResourceLoader resourceLoader = new GeoServerResourceLoader(this.dataDir);
        XMLConfiguration xmlConfig = new XMLConfiguration(this.context.getContextProvider(), (ConfigurationResourceProvider)null);
        DefaultTileLayerCatalog tlCatalog = new DefaultTileLayerCatalog(resourceLoader, xmlConfig);
        tlCatalog.initialize();
        return new CatalogConfiguration(this.catalog, (TileLayerCatalog)tlCatalog, this.gsBroker);
    }

    protected Matcher<TileLayer> infoEquals(TileLayer expected) {
        return Matchers.hasProperty((String)"blobStoreId", (Matcher)Matchers.equalTo((Object)expected.getBlobStoreId()));
    }

    protected Matcher<TileLayer> infoEquals(int rand) {
        return Matchers.hasProperty((String)"blobStoreId", (Matcher)Matchers.equalTo((Object)rand));
    }

    public void failNextRead() {
        Assume.assumeTrue((boolean)false);
    }

    public void failNextWrite() {
        Assume.assumeTrue((boolean)false);
    }

    @Ignore
    @Test
    public void testModifyCallRequiredToChangeInfoFromGetInfo() throws Exception {
        super.testModifyCallRequiredToChangeInfoFromGetInfo();
    }

    @Ignore
    @Test
    public void testModifyCallRequiredToChangeInfoFromGetInfos() throws Exception {
        super.testModifyCallRequiredToChangeInfoFromGetInfos();
    }

    @Ignore
    @Test
    public void testModifyCallRequiredToChangeExistingInfoFromGetInfo() throws Exception {
        super.testModifyCallRequiredToChangeExistingInfoFromGetInfo();
    }

    @Ignore
    @Test
    public void testModifyCallRequiredToChangeExistingInfoFromGetInfos() throws Exception {
        super.testModifyCallRequiredToChangeExistingInfoFromGetInfos();
    }
}

