/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.dispatch;

import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class GeoServerSecurityFilterTest
extends GeoServerSystemTestSupport {
    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Test
    public void testGwcRootAnonymous() throws Exception {
        this.doTestHomePage(false, false);
    }

    @Test
    public void testGwcHomeAnonymous() throws Exception {
        this.doTestHomePage(true, false);
    }

    @Test
    public void testGwcRootUser() throws Exception {
        this.login("user", "password", new String[]{"ROLE_USER"});
        this.doTestHomePage(false, false);
    }

    @Test
    public void testGwcHomeUser() throws Exception {
        this.login("user", "password", new String[]{"ROLE_USER"});
        this.doTestHomePage(true, false);
    }

    @Test
    public void testGwcRootAdmin() throws Exception {
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
        this.doTestHomePage(false, true);
    }

    @Test
    public void testGwcHomeAdmin() throws Exception {
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
        this.doTestHomePage(true, true);
    }

    private void doTestHomePage(boolean home, boolean isAdmin) throws Exception {
        String html = this.getAsString("gwc" + (home ? "/home" : ""));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"GWC Home"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"Welcome to GeoWebCache"));
        if (isAdmin) {
            MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)" version "));
            MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)" build "));
            MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"Runtime Statistics"));
            MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"Storage Locations"));
        } else {
            MatcherAssert.assertThat((Object)html, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)" version ")));
            MatcherAssert.assertThat((Object)html, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)" build ")));
            MatcherAssert.assertThat((Object)html, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Runtime Statistics")));
            MatcherAssert.assertThat((Object)html, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Storage Locations")));
        }
    }
}

