/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;

public class GWCTestHelpers {
    public static LayerInfoImpl mockLayer(String resourceName, String[] extraStyles, PublishedType type) {
        return GWCTestHelpers.mockLayer(resourceName, null, extraStyles, type);
    }

    public static LayerInfoImpl mockLayer(String resourceName, String workSpaceName, String[] extraStyles, PublishedType type) {
        DataStoreInfoImpl store = new DataStoreInfoImpl(null);
        store.setName(resourceName + "-store");
        store.setEnabled(true);
        if (workSpaceName != null) {
            WorkspaceInfoImpl workspace = new WorkspaceInfoImpl();
            workspace.setName(workSpaceName);
            store.setWorkspace((WorkspaceInfo)workspace);
        }
        NamespaceInfoImpl ns = new NamespaceInfoImpl();
        ns.setPrefix("test");
        ns.setURI("http://example.com");
        FeatureTypeInfoImpl resource = new FeatureTypeInfoImpl(null);
        resource.setName(resourceName);
        resource.setNamespace((NamespaceInfo)ns);
        ReferencedEnvelope box = new ReferencedEnvelope(-180.0, 0.0, 0.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        resource.setLatLonBoundingBox(box);
        resource.setNativeBoundingBox(box);
        resource.setEnabled(true);
        resource.setStore((StoreInfo)store);
        LayerInfoImpl layer = new LayerInfoImpl();
        layer.setId("id-" + resource.prefixedName());
        layer.setResource((ResourceInfo)resource);
        layer.setEnabled(true);
        StyleInfoImpl defaultStyle = new StyleInfoImpl(null);
        defaultStyle.setName("default");
        layer.setDefaultStyle((StyleInfo)defaultStyle);
        if (extraStyles != null) {
            HashSet<StyleInfoImpl> styles = new HashSet<StyleInfoImpl>();
            for (String name : extraStyles) {
                StyleInfoImpl extra = new StyleInfoImpl(null);
                extra.setName(name);
                styles.add(extra);
            }
            layer.setStyles(styles);
        }
        layer.setType(type);
        return layer;
    }

    public static LayerGroupInfoImpl mockGroup(String name, PublishedInfo ... layers) {
        LayerGroupInfoImpl lg = new LayerGroupInfoImpl();
        lg.setId("id-" + name);
        lg.setName(name);
        lg.setLayers((List)Lists.newArrayList((Object[])layers));
        lg.setBounds(new ReferencedEnvelope(-180.0, -90.0, 180.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        return lg;
    }
}

