/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.io.File;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.gwc.ConfigurableQuotaStoreProvider;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class GWCQuotaStoreDisabledTest
extends GeoServerSystemTestSupport {
    protected void setUpTestData(SystemTestData testData) throws Exception {
        System.setProperty("GWC_DISKQUOTA_DISABLED", "true");
        testData.setUpSecurity();
    }

    @After
    public void resetSystemProperties() throws Exception {
        System.clearProperty("GWC_DISKQUOTA_DISABLED");
    }

    @Test
    public void testQuotaDisabled() throws Exception {
        ConfigurableQuotaStoreProvider provider = (ConfigurableQuotaStoreProvider)GeoServerExtensions.bean(ConfigurableQuotaStoreProvider.class);
        Assert.assertNull((Object)provider.getQuotaStore());
        File hsqlQuotaStore = new File("diskquota_page_store_hsql");
        Assert.assertFalse((boolean)hsqlQuotaStore.exists());
    }

    @Test
    public void testQuotaDisabledOnDestroy() throws Exception {
        ConfigurableQuotaStoreProvider provider = (ConfigurableQuotaStoreProvider)GeoServerExtensions.bean(ConfigurableQuotaStoreProvider.class);
        try {
            provider.destroy();
        }
        catch (NullPointerException e) {
            Assert.fail((String)"NullPointerException was thrown when destroying ConfigurableQuotaStoreProvider");
        }
    }
}

