/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.gwc.GWC;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessMode;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.wms.WMSTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletResponse;

public class GWCDataSecurityChallengeIntegrationTest
extends WMSTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        DataAccessRuleDAO dao = (DataAccessRuleDAO)GeoServerExtensions.bean(DataAccessRuleDAO.class, (ApplicationContext)applicationContext);
        dao.setCatalogMode(CatalogMode.CHALLENGE);
        GWC.get().getConfig().setDirectWMSIntegrationEnabled(true);
        GWC.get().getConfig().setSecurityEnabled(true);
        this.addUser("cite", "cite", null, Arrays.asList("ROLE_CITE_LAKES_VIEWER"));
        this.addUser("other", "other", null, Arrays.asList("OTHER_VIEWER"));
        this.addLayerAccessRule("*", "*", AccessMode.READ, new String[]{"*"});
        this.addLayerAccessRule("*", "*", AccessMode.WRITE, new String[]{"*"});
        this.addLayerAccessRule("cite", "Lakes", AccessMode.READ, new String[]{"ROLE_CITE_LAKES_VIEWER"});
    }

    protected List<Filter> getFilters() {
        return Collections.singletonList((Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    @Test
    public void testDirectWMSIntegration() throws Exception {
        String path = "wms?service=WMS&request=GetMap&version=1.1.1&format=image/png&layers=" + this.getLayerId(MockData.LAKES) + "&srs=EPSG:4326&width=256&height=256&styles=&bbox=-180.0,-90.0,0.0,90.0&tiled=true";
        this.setRequestAuth(null, null);
        MockHttpServletResponse response = this.getAsServletResponse(path);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        this.setRequestAuth("cite", "cite");
        response = this.getAsServletResponse(path);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        MatcherAssert.assertThat((Object)response.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"MISS"));
        response = this.getAsServletResponse(path);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
        MatcherAssert.assertThat((Object)response.getHeader("geowebcache-cache-result"), (Matcher)Matchers.equalToIgnoringCase((String)"HIT"));
        this.setRequestAuth("other", "other");
        response = this.getAsServletResponse(path);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        this.setRequestAuth(null, null);
        response = this.getAsServletResponse(path);
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }
}

