/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.login.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.geoserver.geofence.api.dto.GrantedAuths;
import org.geoserver.geofence.api.exception.AuthException;
import org.geoserver.geofence.login.util.TokenEncoder;

public class SessionManager {
    private static final Logger LOGGER = LogManager.getLogger(SessionManager.class);
    private static final int MAXSESSIONS = 100;
    private final SessionMap activeSessions = new SessionMap(100);

    public String createSession(String username, GrantedAuths grantedAuths) {
        String token = TokenEncoder.encode(username + grantedAuths.hashCode(), ("" + System.nanoTime() + "" + System.currentTimeMillis()).substring(0, 16));
        LoggedInMember loggedInMember = new LoggedInMember();
        loggedInMember.grantedAuths = grantedAuths;
        loggedInMember.username = username;
        this.activeSessions.put(token, loggedInMember);
        return token;
    }

    public void closeSession(String token) {
        LoggedInMember member = (LoggedInMember)this.activeSessions.remove(token);
        if (member == null) {
            LOGGER.warn((Object)("Tried to close non existent session. Token " + token));
        } else {
            LOGGER.info((Object)("Closing session for user [" + member.username + "] token " + token));
        }
    }

    public GrantedAuths getGrantedAuthorities(String token) throws AuthException {
        LoggedInMember loggedInMember = (LoggedInMember)this.activeSessions.get(token);
        if (loggedInMember != null) {
            return loggedInMember.grantedAuths;
        }
        throw new AuthException("No active session for token " + token);
    }

    class SessionMap
    extends LinkedHashMap<String, LoggedInMember> {
        private final int MAX_ENTRIES;

        public SessionMap(int maxEntries) {
            this.MAX_ENTRIES = maxEntries;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            if (this.size() > this.MAX_ENTRIES) {
                LoggedInMember member = (LoggedInMember)eldest.getValue();
                LOGGER.info((Object)("Removing stale token " + eldest.getKey() + " for member " + member.username));
                return true;
            }
            return false;
        }
    }

    private static class LoggedInMember {
        public GrantedAuths grantedAuths;
        public String username;

        private LoggedInMember() {
        }
    }
}

