/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.login.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.geoserver.geofence.api.exception.AuthException;

public class MD5Util {
    private static final Logger LOGGER = LogManager.getLogger(MD5Util.class);

    public static String getHash(String password) throws AuthException {
        MessageDigest md;
        byte[] passwordByteArr;
        try {
            passwordByteArr = password.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new AuthException(e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            md = MessageDigest.getInstance("MD5");
            md.reset();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new AuthException(e.getLocalizedMessage(), (Throwable)e);
        }
        byte[] thedigest = md.digest(passwordByteArr);
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < thedigest.length; ++i) {
            String hexByte = Integer.toHexString(0xFF & thedigest[i]);
            if (hexByte.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hexByte);
        }
        return hexString.toString();
    }
}

