/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.login;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.geoserver.geofence.api.AuthProvider;
import org.geoserver.geofence.api.dto.Authority;
import org.geoserver.geofence.api.dto.GrantedAuths;
import org.geoserver.geofence.api.exception.AuthException;
import org.geoserver.geofence.login.LoginService;
import org.geoserver.geofence.login.util.GrantAll;
import org.geoserver.geofence.login.util.SessionManager;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class LoginServiceImpl
implements LoginService,
InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LogManager.getLogger(LoginServiceImpl.class);
    private AuthProvider authProvider = new GrantAll();
    private SessionManager sessionManager;

    public LoginServiceImpl() {
        LOGGER.info((Object)("Creating " + this.getClass().getSimpleName() + " instance"));
    }

    public void afterPropertiesSet() {
        LOGGER.debug((Object)"afterPropertiesSet()");
    }

    public void destroy() throws Exception {
        LOGGER.debug((Object)"destroy()");
    }

    @PostConstruct
    public void postConstruct() {
        LOGGER.debug((Object)"postConstruct()");
    }

    @PreDestroy
    public void preDestroy() {
        LOGGER.debug((Object)"preDestroy()");
    }

    public String login(String username, String password, String pwFromDb) throws AuthException {
        LOGGER.info((Object)("LOGIN REQUEST FOR " + username));
        if (username == null) {
            throw new AuthException("Null username");
        }
        try {
            GrantedAuths ga = this.authProvider.login(username, password, pwFromDb);
            if (!ga.getAuthorities().contains(Authority.LOGIN)) {
                LOGGER.warn((Object)("Login not granted to user [" + username + "]"));
                throw new AuthException("User " + username + " can't log in");
            }
            String token = this.sessionManager.createSession(username, ga);
            return token;
        }
        catch (AuthException ex) {
            LOGGER.warn((Object)("Authentication Failed for user [" + username + "]: " + ex.getLocalizedMessage()));
            throw new AuthException("Authentication error", (Throwable)ex);
        }
    }

    public void logout(String token) {
        LOGGER.info((Object)("LOGOUT:" + token));
        this.sessionManager.closeSession(token);
    }

    public GrantedAuths getGrantedAuthorities(String token) {
        LOGGER.info((Object)("getGrantedAuthorities:" + token));
        return this.sessionManager.getGrantedAuthorities(token);
    }

    public void setAuthProvider(AuthProvider authProvider) {
        LOGGER.info((Object)("Setting AuthProvider: " + authProvider.getClass()));
        this.authProvider = authProvider;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }
}

