/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.login.cxf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.geoserver.geofence.api.AuthProvider;
import org.geoserver.geofence.api.dto.Authority;
import org.geoserver.geofence.api.dto.GrantedAuths;
import org.geoserver.geofence.login.util.GrantAll;

public class BasicAuthInterceptor
extends AbstractInDatabindingInterceptor {
    protected Logger LOGGER = LogManager.getLogger(((Object)((Object)this)).getClass());
    private AuthProvider authProvider = new GrantAll();
    private String realm = "Geofence";

    public BasicAuthInterceptor() {
        super("unmarshal");
    }

    public void handleMessage(Message message) throws Fault {
        AuthorizationPolicy policy = (AuthorizationPolicy)message.get(AuthorizationPolicy.class);
        if (policy == null) {
            this.sendErrorResponse(message, 401);
            return;
        }
        GrantedAuths ga = null;
        try {
            ga = this.authProvider.login(policy.getUserName(), policy.getPassword(), "");
        }
        catch (Exception ex) {
            this.LOGGER.warn((Object)("Login failed:" + ex.getMessage()));
            this.sendErrorResponse(message, 403);
            return;
        }
        if (!ga.getAuthorities().contains(Authority.REMOTE)) {
            this.sendErrorResponse(message, 403);
            return;
        }
        message.put((Object)"grantedAuths", (Object)ga);
    }

    private void sendErrorResponse(Message message, int responseCode) {
        Message outMessage = this.getOutMessage(message);
        outMessage.put((Object)Message.RESPONSE_CODE, (Object)responseCode);
        Map responseHeaders = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
        if (responseHeaders != null) {
            responseHeaders.put("WWW-Authenticate", Arrays.asList("Basic realm=\"" + this.realm + "\""));
            responseHeaders.put("Content-Length", Arrays.asList("0"));
        }
        message.getInterceptorChain().abort();
        try {
            message.getExchange().getConduit(message).prepare(outMessage);
            OutputStream os = (OutputStream)outMessage.getContent(OutputStream.class);
            String errmsg = "Error " + responseCode + ": ";
            os.write(errmsg.getBytes());
            this.LOGGER.info((Object)("Sending error " + responseCode));
            this.close(outMessage);
        }
        catch (IOException e) {
            this.LOGGER.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Message getOutMessage(Message inMessage) {
        Exchange exchange = inMessage.getExchange();
        Message outMessage = exchange.getOutMessage();
        if (outMessage == null) {
            Endpoint endpoint = (Endpoint)exchange.get(Endpoint.class);
            outMessage = endpoint.getBinding().createMessage();
            exchange.setOutMessage(outMessage);
        }
        outMessage.putAll((Map)inMessage);
        return outMessage;
    }

    private void close(Message outMessage) throws IOException {
        OutputStream os = (OutputStream)outMessage.getContent(OutputStream.class);
        os.flush();
        os.close();
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setAuthProvider(AuthProvider authProvider) {
        this.authProvider = authProvider;
    }
}

