/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.kml.KMLEncoder;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.kml.iterator.IteratorFactory;
import org.geoserver.kml.iterator.IteratorList;
import org.geoserver.kml.iterator.WFSFeatureIteratorFactory;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wps.ppio.CDataPPIO;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.kml.v22.KMLConfiguration;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.StreamingParser;
import org.locationtech.jts.geom.Geometry;

public class KMLPPIO
extends CDataPPIO {
    private static final Logger LOGGER = Logging.getLogger(KMLPPIO.class);
    GeoServer gs;
    EntityResolverProvider resolverProvider;
    Configuration xml;
    SimpleFeatureType type;

    public KMLPPIO(GeoServer gs, EntityResolverProvider resolverProvider) {
        super(FeatureCollection.class, FeatureCollection.class, "application/vnd.google-earth.kml+xml");
        this.gs = gs;
        this.resolverProvider = resolverProvider;
        this.xml = new KMLConfiguration();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("puregeometries");
        b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        b.add("location", Geometry.class);
        this.type = b.buildFeatureType();
    }

    private static final Map<Name, Class<?>> getSignature(SimpleFeature f) {
        HashMap ftype = new HashMap();
        Collection properties = f.getProperties();
        for (Property p : properties) {
            Class c = p.getType().getBinding();
            if (!c.isAssignableFrom(String.class) && !c.isAssignableFrom(Boolean.class) && !c.isAssignableFrom(Integer.class) && !c.isAssignableFrom(Float.class) && !c.isAssignableFrom(Double.class) && !c.isAssignableFrom(Geometry.class)) continue;
            ftype.put(p.getName(), c);
        }
        return ftype;
    }

    private SimpleFeatureType getType(Map<Name, Class<?>> ftype) {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("puregeometries");
        b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        for (Map.Entry<Name, Class<?>> entry : ftype.entrySet()) {
            b.add(entry.getKey().toString(), entry.getValue());
        }
        return b.buildFeatureType();
    }

    public Object decode(InputStream input) throws Exception {
        SimpleFeature f;
        StreamingParser parser = new StreamingParser((Configuration)new KMLConfiguration(), input, SimpleFeature.class);
        parser.setEntityResolver(this.resolverProvider.getEntityResolver());
        ListFeatureCollection features = null;
        Map<Name, Class<?>> oldftype = null;
        SimpleFeatureType type = null;
        SimpleFeatureBuilder featureBuilder = null;
        while ((f = (SimpleFeature)parser.parse()) != null) {
            Map<Name, Class<?>> ftype = KMLPPIO.getSignature(f);
            if (oldftype == null) {
                oldftype = ftype;
                type = this.getType(ftype);
                featureBuilder = new SimpleFeatureBuilder(type);
                features = new ListFeatureCollection(type);
            } else if (!oldftype.equals(ftype)) break;
            for (Map.Entry<Name, Class<?>> entry : ftype.entrySet()) {
                featureBuilder.add(f.getAttribute(entry.getKey()));
            }
            SimpleFeature fnew = featureBuilder.buildFeature(f.getID());
            features.add(fnew);
        }
        return features;
    }

    public Object decode(String input) throws Exception {
        return this.decode(new ByteArrayInputStream(input.getBytes()));
    }

    public void encode(Object obj, OutputStream os) throws Exception {
        LOGGER.info("KMLPPIO::encode: obj is of class " + obj.getClass().getName() + ", handler is of class " + os.getClass().getName());
        KMLEncoder encoder = new KMLEncoder();
        SimpleFeatureCollection fcObj = (SimpleFeatureCollection)obj;
        CoordinateReferenceSystem crs = ((SimpleFeatureType)fcObj.getSchema()).getCoordinateReferenceSystem();
        if (crs != null && !CRS.equalsIgnoreMetadata((Object)crs, (Object)DefaultGeographicCRS.WGS84)) {
            fcObj = new ReprojectingFeatureCollection(fcObj, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        ArrayList<SimpleFeatureCollection> collections = new ArrayList<SimpleFeatureCollection>();
        collections.add(fcObj);
        WFSKmlEncodingContext context = new WFSKmlEncodingContext(collections);
        Kml kml = new Kml();
        Document document = kml.createAndSetDocument();
        List docDecorators = context.getDecoratorsForClass(Document.class);
        for (KmlDecoratorFactory.KmlDecorator decorator : docDecorators) {
            document = (Document)decorator.decorate((Feature)document, (KmlEncodingContext)context);
            if (document != null) continue;
            throw new ServiceException("Coding error in decorator " + decorator + ", document objects cannot be set to null");
        }
        for (SimpleFeatureCollection fc : collections) {
            KmlDecoratorFactory.KmlDecorator decorator;
            Folder folder = document.createAndAddFolder();
            folder.setName(((SimpleFeatureType)fc.getSchema()).getTypeName());
            List folderDecorators = context.getDecoratorsForClass(Folder.class);
            Iterator iterator = folderDecorators.iterator();
            while (iterator.hasNext() && (folder = (Folder)(decorator = (KmlDecoratorFactory.KmlDecorator)iterator.next()).decorate((Feature)folder, (KmlEncodingContext)context)) != null) {
            }
            if (folder == null) continue;
            context.setCurrentFeatureCollection(fc);
            IteratorList features = new IteratorList((IteratorFactory)new WFSFeatureIteratorFactory((KmlEncodingContext)context));
            context.addFeatures(folder, (List)features);
        }
        encoder.encode(kml, os, (KmlEncodingContext)context);
        os.flush();
    }

    public String getFileExtension() {
        return "kml";
    }

    static class WFSKmlEncodingContext
    extends KmlEncodingContext {
        private List<SimpleFeatureCollection> collections;
        private SimpleFeatureType featureType;

        public WFSKmlEncodingContext(List<SimpleFeatureCollection> collections) {
            this.service = this.getService();
            this.collections = collections;
            this.descriptionEnabled = false;
            this.kmScore = 100;
            this.extendedDataEnabled = true;
            this.kmz = false;
        }

        public List<SimpleFeatureType> getFeatureTypes() {
            ArrayList<SimpleFeatureType> results = new ArrayList<SimpleFeatureType>();
            for (SimpleFeatureCollection fc : this.collections) {
                results.add((SimpleFeatureType)fc.getSchema());
            }
            return results;
        }

        public void setCurrentFeatureCollection(SimpleFeatureCollection currentFeatureCollection) {
            super.setCurrentFeatureCollection(currentFeatureCollection);
            ++this.layerIndex;
            this.featureType = (SimpleFeatureType)currentFeatureCollection.getSchema();
        }

        public SimpleFeatureType getCurrentFeatureType() {
            return this.featureType;
        }
    }
}

