/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.resource.Resource;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.DisposableBean;

public class JDBCStatusStoreLoader
implements DisposableBean {
    private static final Logger LOGGER = Logging.getLogger(JDBCStatusStoreLoader.class);
    private static final String JDBCSTATUS_NAME = "jdbcstatusstore.props";
    private GeoServerDataDirectory dataDir;
    private DataStore store;

    public DataStore getStore() {
        return this.store;
    }

    public JDBCStatusStoreLoader(GeoServerDataDirectory dd) throws IOException {
        this.dataDir = dd;
        try {
            Properties params = this.getParameters();
            this.store = DataStoreFinder.getDataStore((Map)DataUtilities.toConnectionParameters((Properties)params));
        }
        catch (IOException e) {
            LOGGER.info("can't find or create JDBC Status store configuration file");
            LOGGER.log(Level.FINE, "no config file?", e);
        }
    }

    public Properties getParameters() throws IOException {
        InputStream is;
        Resource resource = this.dataDir.get(new String[]{JDBCSTATUS_NAME});
        if (resource.getType() == Resource.Type.UNDEFINED) {
            try (OutputStream os = resource.out();){
                is = JDBCStatusStoreLoader.class.getResourceAsStream(JDBCSTATUS_NAME);
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
        }
        Properties params = new Properties();
        is = resource.in();
        try {
            params.load(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return params;
    }

    public void saveParameters(Properties props) throws IOException {
        Resource resource = this.dataDir.get(new String[]{JDBCSTATUS_NAME});
        if (resource.getType() != Resource.Type.UNDEFINED) {
            Resource backup = this.dataDir.get(new String[]{"jdbcstatusstore.props.bak"});
            try (OutputStream os = backup.out();
                 InputStream is = resource.in();){
                IOUtils.copy((InputStream)is, (OutputStream)os);
                is.close();
                os.close();
            }
        }
        try (OutputStream os = resource.out();){
            props.store(os, "saved by GeoServer @" + new Date());
        }
    }

    public void destroy() throws Exception {
        this.store.dispose();
    }
}

