/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import net.opengis.ows11.Ows11Factory;
import net.opengis.wps10.ExecuteType;
import net.opengis.wps10.Wps10Factory;
import org.geoserver.wps.ProcessStatusStore;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.ProcessState;
import org.geoserver.wps.jdbc.JDBCStatusStoreLoader;
import org.geoserver.wps.xml.WPSConfiguration;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.transform.Definition;
import org.geotools.data.transform.TransformFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.geotools.wps.WPS;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.geotools.xsd.Parser;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.xml.sax.SAXException;

public class JDBCStatusStore
implements ProcessStatusStore {
    private static final String STACKTRACESEPERATOR = "/";
    static final Logger LOGGER = Logging.getLogger(JDBCStatusStore.class);
    static final Wps10Factory WPSFACTORY = Wps10Factory.eINSTANCE;
    static final Ows11Factory OWSFACTORY = Ows11Factory.eINSTANCE;
    static final String STACK_TRACE = "stackTrace";
    static final String EXCEPTION_MESSAGE = "exceptionMessage";
    static final String EXCEPTION_CLASS = "exceptionClass";
    static final String ASYNC = "async";
    static final String USER_NAME = "userName";
    static final String TASK = "task";
    static final String SIMPLE_PROCESS_NAME = "processName";
    static final String PROPERTIES = "properties";
    static final String PROGRESS = "progress";
    static final String PROCESS_NAME_URI = "processNameURI";
    static final String PROCESS_NAME = "processNameImpl";
    static final String PHASE = "phase";
    static final String NODE_ID = "node";
    static final String COMPLETION = "completionTime";
    static final String LASTUPDATE = "lastUpdated";
    static final String CREATION = "creationTime";
    static final String PROCESS_ID = "processId";
    static final String STATUS = "status";
    static final String EXECUTION_ID = "exceptionId";
    private static final String REQUEST = "request";
    DataStore statuses;
    SimpleFeatureType schema;
    String actualStatusName;
    List<Definition> mappingDefinitions;

    public JDBCStatusStore(JDBCStatusStoreLoader loader) {
        this(loader.getStore());
    }

    public JDBCStatusStore(DataStore store) {
        if (store == null) {
            throw new RuntimeException("Attempted to create a JDBCStatusStore with a null datastore");
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.add(PROCESS_ID, String.class);
        tb.add(CREATION, Timestamp.class);
        tb.add(LASTUPDATE, Timestamp.class);
        tb.add(COMPLETION, Timestamp.class);
        tb.add(NODE_ID, String.class);
        tb.add(PHASE, String.class);
        tb.add(PROCESS_NAME, String.class);
        tb.add(PROCESS_NAME_URI, String.class);
        tb.add(PROGRESS, Float.class);
        tb.add(REQUEST, byte[].class);
        tb.add(PROPERTIES, String.class);
        tb.add(SIMPLE_PROCESS_NAME, String.class);
        tb.add(TASK, String.class);
        tb.add(USER_NAME, String.class);
        tb.add(ASYNC, String.class);
        tb.add(EXCEPTION_CLASS, String.class);
        tb.add(EXCEPTION_MESSAGE, String.class);
        tb.add(STACK_TRACE, byte[].class);
        tb.setName(STATUS);
        this.schema = tb.buildFeatureType();
        this.statuses = store;
        try {
            SimpleFeatureType storeSchema = this.lookupStatusSchema();
            if (storeSchema == null) {
                LOGGER.fine("creating new DB table for statuses");
                this.statuses.createSchema((FeatureType)this.schema);
                storeSchema = this.lookupStatusSchema();
            }
            this.actualStatusName = storeSchema.getTypeName();
            this.mappingDefinitions = this.buildDefinitions(storeSchema, this.schema);
        }
        catch (IOException e) {
            throw new WPSException("Failed to setup the underlying store", (Throwable)e);
        }
    }

    private List<Definition> buildDefinitions(SimpleFeatureType actual, SimpleFeatureType expected) {
        ArrayList<Definition> definitions = new ArrayList<Definition>();
        boolean mappingRequired = false;
        if (!actual.getTypeName().equals(expected.getTypeName())) {
            mappingRequired = true;
        }
        List expectedDescriptors = expected.getAttributeDescriptors();
        List actualDescriptors = actual.getAttributeDescriptors();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        for (int i = 0; i < expected.getAttributeCount(); ++i) {
            Class expectedType;
            String actualName;
            AttributeDescriptor expectedDescriptor = (AttributeDescriptor)expectedDescriptors.get(i);
            AttributeDescriptor actualDescriptor = (AttributeDescriptor)actualDescriptors.get(i);
            String expectedName = expectedDescriptor.getLocalName();
            if (!expectedName.equals(actualName = actualDescriptor.getLocalName())) {
                mappingRequired = true;
            }
            if (!(expectedType = expectedDescriptor.getType().getBinding()).isAssignableFrom(actualDescriptor.getType().getBinding())) {
                mappingRequired = true;
            }
            definitions.add(new Definition(expectedName, (Expression)ff.property(actualName), expectedType));
        }
        if (mappingRequired) {
            return definitions;
        }
        return null;
    }

    private SimpleFeatureType lookupStatusSchema() throws IOException {
        String[] typeNames;
        for (String typeName : typeNames = this.statuses.getTypeNames()) {
            if (!typeName.equalsIgnoreCase(STATUS)) continue;
            return this.statuses.getSchema(typeName);
        }
        return null;
    }

    private SimpleFeatureStore getStatusFeatureStore() throws IOException {
        SimpleFeatureSource source = this.statuses.getFeatureSource(this.actualStatusName);
        if (this.mappingDefinitions != null) {
            source = TransformFactory.transform((SimpleFeatureSource)source, (Name)new NameImpl(STATUS), this.mappingDefinitions);
        }
        return (SimpleFeatureStore)source;
    }

    public void save(ExecutionStatus status) {
        DefaultTransaction transaction = new DefaultTransaction("create");
        boolean committed = false;
        try {
            SimpleFeatureStore store = this.getStatusFeatureStore();
            store.setTransaction((Transaction)transaction);
            SimpleFeature feature = this.statusToFeature(status);
            SimpleFeatureCollection featureCollection = DataUtilities.collection((SimpleFeature)feature);
            Filter filter = ECQL.toFilter((String)("processId = '" + status.getExecutionId() + "'"));
            store.removeFeatures(filter);
            store.addFeatures((FeatureCollection)featureCollection);
            transaction.commit();
            committed = true;
        }
        catch (Exception e) {
            throw new WPSException("Failure saving status " + status, (Throwable)e);
        }
        finally {
            this.closeTransaction(transaction, committed);
        }
    }

    public ExecutionStatus get(String executionId) {
        LOGGER.fine("getting status " + executionId);
        try {
            SimpleFeatureStore source = this.getStatusFeatureStore();
            Filter filter = ECQL.toFilter((String)("processId = '" + executionId + "'"));
            SimpleFeatureCollection features = source.getFeatures(filter);
            SimpleFeature f = (SimpleFeature)DataUtilities.first((FeatureCollection)features);
            ExecutionStatus stat = this.featureToStatus(f);
            return stat;
        }
        catch (IOException | CQLException e) {
            throw new WPSException("Failed to get execution status " + executionId, e);
        }
    }

    public ExecutionStatus remove(String executionId) {
        LOGGER.fine("removing status " + executionId);
        DefaultTransaction transaction = new DefaultTransaction("create");
        boolean committed = false;
        try {
            SimpleFeatureStore store = this.getStatusFeatureStore();
            Filter filter = ECQL.toFilter((String)("processId = '" + executionId + "'"));
            store.setTransaction((Transaction)transaction);
            SimpleFeatureCollection features = store.getFeatures(filter);
            SimpleFeature f = (SimpleFeature)DataUtilities.first((FeatureCollection)features);
            ExecutionStatus stat = this.featureToStatus(f);
            store.removeFeatures(filter);
            transaction.commit();
            committed = true;
            ExecutionStatus executionStatus = stat;
            return executionStatus;
        }
        catch (Exception e) {
            throw new WPSException("Failure to remove status by id: " + executionId, (Throwable)e);
        }
        finally {
            this.closeTransaction(transaction, committed);
        }
    }

    private void closeTransaction(DefaultTransaction transaction, boolean committed) {
        if (!committed) {
            try {
                transaction.rollback();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failure to roll back transaction", e);
            }
        }
        transaction.close();
    }

    public int remove(Filter filter) {
        LOGGER.fine("removing statuses matching " + filter);
        int ret = 0;
        DefaultTransaction transaction = new DefaultTransaction("create");
        boolean committed = false;
        try {
            SimpleFeatureStore store = this.getStatusFeatureStore();
            SimpleFeatureCollection features = store.getFeatures(filter);
            ret = features.size();
            if (ret == 0) {
                int n = ret;
                return n;
            }
            store.setTransaction((Transaction)transaction);
            store.removeFeatures(filter);
            transaction.commit();
            committed = true;
        }
        catch (Exception e) {
            throw new WPSException("Failure to remove status by filter: " + filter, (Throwable)e);
        }
        finally {
            this.closeTransaction(transaction, committed);
        }
        return ret;
    }

    public List<ExecutionStatus> list(Query query) {
        ArrayList<ExecutionStatus> arrayList;
        block10: {
            LOGGER.fine("listing statuses matching " + query);
            ArrayList<ExecutionStatus> ret = new ArrayList<ExecutionStatus>();
            SimpleFeatureStore source = this.getStatusFeatureStore();
            LOGGER.fine("requesting " + query);
            SimpleFeatureCollection features = source.getFeatures(query);
            SimpleFeatureIterator itr = features.features();
            try {
                while (itr.hasNext()) {
                    SimpleFeature f = (SimpleFeature)itr.next();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("adding " + f);
                    }
                    ret.add(this.featureToStatus(f));
                }
                arrayList = ret;
                if (itr == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (itr != null) {
                        try {
                            itr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new WPSException("Failed to list statuses by query " + query, (Throwable)e);
                }
            }
            itr.close();
        }
        return arrayList;
    }

    protected SimpleFeature statusToFeature(ExecutionStatus status) {
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(this.schema);
        builder.set(PROCESS_ID, (Object)status.getExecutionId());
        builder.set(CREATION, (Object)status.getCreationTime());
        builder.set(LASTUPDATE, (Object)status.getLastUpdated());
        builder.set(COMPLETION, (Object)status.getCompletionTime());
        builder.set(NODE_ID, (Object)status.getNodeId());
        builder.set(PHASE, (Object)status.getPhase());
        Name processName = status.getProcessName();
        builder.set(PROCESS_NAME, (Object)processName.getLocalPart());
        builder.set(PROCESS_NAME_URI, (Object)processName.getNamespaceURI());
        builder.set(PROGRESS, (Object)Float.valueOf(status.getProgress()));
        ExecuteType request = status.getRequest();
        if (request != null) {
            builder.set(REQUEST, (Object)this.serializeRequest(request));
        }
        builder.set(SIMPLE_PROCESS_NAME, (Object)status.getSimpleProcessName());
        builder.set(TASK, (Object)status.getTask());
        builder.set(USER_NAME, (Object)status.getUserName());
        builder.set(ASYNC, (Object)status.isAsynchronous());
        Throwable exception = status.getException();
        if (exception != null) {
            builder.set(EXCEPTION_CLASS, (Object)exception.getClass().getName());
            builder.set(EXCEPTION_MESSAGE, (Object)exception.getMessage());
            StackTraceElement[] stackTrace = exception.getStackTrace();
            StringBuffer buf = new StringBuffer();
            for (StackTraceElement el : stackTrace) {
                buf.append(el.getClassName()).append(STACKTRACESEPERATOR);
                buf.append(el.getFileName()).append(STACKTRACESEPERATOR);
                buf.append(el.getMethodName()).append(STACKTRACESEPERATOR);
                buf.append(el.getLineNumber());
                buf.append("\n");
            }
            builder.set(STACK_TRACE, (Object)buf.toString().getBytes(StandardCharsets.UTF_8));
        }
        SimpleFeature feature = builder.buildFeature(null);
        return feature;
    }

    private byte[] serializeRequest(ExecuteType request) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Encoder e = new Encoder((Configuration)new WPSConfiguration());
        e.setIndenting(true);
        try {
            e.encode((Object)request, WPS.Execute, (OutputStream)out);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Problem encountered encoding WPS Request, moving on without it", ex);
        }
        return out.toByteArray();
    }

    protected ExecutionStatus featureToStatus(SimpleFeature f) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (f == null) {
            return null;
        }
        for (Property p : f.getProperties()) {
            if (p.getValue() == null) continue;
            attrs.put(p.getName().toString(), p.getValue());
        }
        NameImpl processName = new NameImpl((String)attrs.get(PROCESS_NAME));
        String executionId = (String)attrs.get(PROCESS_ID);
        boolean asynchronous = (Boolean)Converters.convert(attrs.get(ASYNC), Boolean.class);
        ExecutionStatus status = new ExecutionStatus((Name)processName, executionId, asynchronous);
        if (attrs.containsKey(REQUEST)) {
            ExecuteType request = this.buildRequest(attrs);
            status.setRequest(request);
        }
        String phase = (String)attrs.get(PHASE);
        ProcessState state = ProcessState.valueOf((String)phase);
        status.setPhase(state);
        status.setProgress(((Float)attrs.get(PROGRESS)).floatValue());
        status.setTask((String)attrs.get(TASK));
        status.setUserName((String)attrs.get(USER_NAME));
        if (attrs.containsKey(EXCEPTION_MESSAGE)) {
            status.setException((Throwable)this.buildException(attrs, status));
        }
        status.setCreationTime((Date)attrs.get(CREATION));
        if (attrs.containsKey(COMPLETION)) {
            status.setCompletionTime((Date)attrs.get(COMPLETION));
        }
        if (attrs.containsKey(LASTUPDATE)) {
            status.setLastUpdated((Date)attrs.get(LASTUPDATE));
        }
        return status;
    }

    private ExecuteType buildRequest(HashMap<String, Object> attrs) {
        byte[] req = (byte[])attrs.get(REQUEST);
        Parser parser = new Parser((Configuration)new WPSConfiguration());
        ExecuteType request = null;
        try {
            request = (ExecuteType)parser.parse((InputStream)new ByteArrayInputStream(req));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.log(Level.WARNING, "Problem building WPS request for status", e);
        }
        return request;
    }

    private Exception buildException(HashMap<String, Object> attrs, ExecutionStatus status) {
        String message = (String)attrs.get(EXCEPTION_MESSAGE);
        Exception exc = new Exception(message);
        try {
            Constructor<?> con = this.getClass().getClassLoader().loadClass((String)attrs.get(EXCEPTION_CLASS)).getConstructor(String.class);
            exc = (Exception)con.newInstance(message);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.log(Level.FINE, "Couldn't reinstaniate Exception for WPS status", e);
        }
        byte[] r = (byte[])attrs.get(STACK_TRACE);
        ArrayList<StackTraceElement> trace = new ArrayList<StackTraceElement>();
        for (String line : new String(r, StandardCharsets.UTF_8).split("\n")) {
            String[] parts = line.split(STACKTRACESEPERATOR);
            String declaringClass = parts[0];
            String fileName = parts[1];
            String methodName = parts[2];
            int lineNumber = Integer.parseInt(parts[3]);
            StackTraceElement t = new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
            trace.add(t);
        }
        exc.setStackTrace(trace.toArray(new StackTraceElement[0]));
        return exc;
    }

    public boolean supportsPredicate() {
        return false;
    }

    public boolean supportsPaging() {
        return true;
    }
}

