/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.jdbc;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import net.opengis.ows11.CodeType;
import net.opengis.ows11.Ows11Factory;
import net.opengis.wps10.ComplexDataType;
import net.opengis.wps10.DataInputsType1;
import net.opengis.wps10.DataType;
import net.opengis.wps10.ExecuteType;
import net.opengis.wps10.InputType;
import net.opengis.wps10.Wps10Factory;
import org.geoserver.wps.AbstractProcessStoreTest;
import org.geoserver.wps.ProcessStatusStore;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.jdbc.GSFixtureUtilitiesDelegate;
import org.geoserver.wps.jdbc.JDBCStatusStore;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.feature.NameImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public abstract class AbstractJDBCStatusStoreTest
extends AbstractProcessStoreTest {
    private DataStore datastore;
    JDBCStatusStore statusStore;
    String fixtureId;

    abstract String getFixtureId();

    protected Properties getFixture() {
        Properties properties = GSFixtureUtilitiesDelegate.loadFixture(this.getFixtureId());
        Assume.assumeNotNull((Object[])new Object[]{properties});
        return properties;
    }

    @After
    public void cleanup() {
        if (this.datastore != null) {
            this.datastore.dispose();
        }
    }

    protected ProcessStatusStore buildStore() throws IOException {
        this.setupDataStore();
        if (Arrays.asList(this.datastore.getTypeNames()).contains(this.getStatusTable())) {
            this.datastore.removeSchema(this.getStatusTable());
        }
        this.statusStore = new JDBCStatusStore(this.datastore);
        return this.statusStore;
    }

    protected String getStatusTable() {
        return "status";
    }

    protected void setupDataStore() {
        Properties props = this.getFixture();
        try {
            this.datastore = DataStoreFinder.getDataStore((Map)DataUtilities.toConnectionParameters((Properties)props));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.datastore == null) {
            throw new RuntimeException("failed to create dataStore with \n " + props);
        }
    }

    @After
    public void shutdown() {
        if (this.statusStore != null) {
            this.statusStore.remove((Filter)Filter.INCLUDE);
        }
        if (this.datastore != null) {
            this.datastore.dispose();
        }
    }

    @Test
    public void testStackTrace() {
        ExecutionStatus s = new ExecutionStatus((Name)new NameImpl("tracetest"), "ian", false);
        IllegalArgumentException exception = new IllegalArgumentException("a test exception");
        exception.fillInStackTrace();
        s.setException((Throwable)exception);
        this.store.save(s);
        ExecutionStatus status = this.store.get(s.getExecutionId());
        Assert.assertEquals((Object)s, (Object)status);
        Assert.assertEquals((Object)s.getException().getMessage(), (Object)status.getException().getMessage());
        StackTraceElement[] expStackTrace = s.getException().getStackTrace();
        StackTraceElement[] obsStackTrace = status.getException().getStackTrace();
        Assert.assertEquals((long)expStackTrace.length, (long)obsStackTrace.length);
        Assert.assertEquals((Object)expStackTrace[0].toString(), (Object)obsStackTrace[0].toString());
        this.store.remove(s.getExecutionId());
    }

    @Test
    public void testRequest() {
        Wps10Factory f = Wps10Factory.eINSTANCE;
        ExecuteType ex = f.createExecuteType();
        CodeType id = Ows11Factory.eINSTANCE.createCodeType();
        ex.setIdentifier(id);
        id.setValue("foo");
        DataInputsType1 inputs = f.createDataInputsType1();
        ex.setDataInputs(inputs);
        InputType in = f.createInputType();
        inputs.getInput().add((Object)in);
        DataType data = f.createDataType();
        in.setData(data);
        ComplexDataType cd = f.createComplexDataType();
        data.setComplexData(cd);
        ExecutionStatus s = new ExecutionStatus((Name)new NameImpl("requesttest"), "ian", false);
        s.setRequest(ex);
        this.store.save(s);
        ExecutionStatus status = this.store.get(s.getExecutionId());
        Assert.assertEquals((Object)s, (Object)status);
        ExecuteType obs = status.getRequest();
        ExecuteType expected = s.getRequest();
        Assert.assertEquals((Object)expected.getBaseUrl(), (Object)obs.getBaseUrl());
        Assert.assertEquals((Object)expected.getIdentifier().getValue(), (Object)obs.getIdentifier().getValue());
    }
}

