/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.resource;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import net.opengis.wps10.ExecuteResponseType;
import net.opengis.wps10.ExecuteType;
import org.apache.commons.io.IOUtils;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.wps.ProcessEvent;
import org.geoserver.wps.ProcessListenerAdapter;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.ProcessStatusTracker;
import org.geoserver.wps.resource.DefaultProcessArtifactsStore;
import org.geoserver.wps.resource.ProcessArtifactsStore;
import org.geoserver.wps.resource.WPSResource;
import org.geoserver.wps.resource.WPSResourceResource;
import org.geoserver.wps.xml.WPSConfiguration;
import org.geotools.util.logging.Logging;
import org.geotools.wps.WPS;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.geotools.xsd.Parser;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.xml.sax.SAXException;

public class WPSResourceManager
extends ProcessListenerAdapter
implements DispatcherCallback,
ApplicationListener<ApplicationEvent>,
ApplicationContextAware {
    private static final Logger LOGGER = Logging.getLogger(WPSResourceManager.class);
    static final int COPY_BUFFER_SIZE = Integer.getInteger("org.geoserver.wps.copy.buffer.size", 16386);
    ConcurrentHashMap<String, ExecutionResources> resourceCache = new ConcurrentHashMap();
    ThreadLocal<String> executionId = new InheritableThreadLocal<String>();
    private ProcessArtifactsStore artifactsStore;
    private GeoServerResourceLoader resourceLoader;
    private File outputDirectory;

    public static int getCopyBufferSize() {
        return COPY_BUFFER_SIZE;
    }

    public WPSResourceManager(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private String getExecutionId(String executionId) {
        if (executionId == null) {
            executionId = this.getExecutionId((Boolean)null);
        }
        return executionId;
    }

    public String getExecutionId(Boolean synch) {
        String id = this.executionId.get();
        if (id == null) {
            id = UUID.randomUUID().toString();
            this.executionId.set(id);
            this.resourceCache.put(id, new ExecutionResources(synch != null ? synch : true));
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Associating process with execution id: " + id);
            }
        }
        return id;
    }

    void setCurrentExecutionId(String executionId) {
        ExecutionResources resources = this.resourceCache.get(executionId);
        if (resources == null) {
            throw new IllegalStateException("Execution id " + executionId + " is not known");
        }
        this.executionId.set(executionId);
    }

    public String getCurrentExecutionId() {
        return this.executionId.get();
    }

    void clearExecutionId() {
        this.executionId.set(null);
    }

    public void addResource(WPSResource resource) {
        String processId = this.getExecutionId((Boolean)null);
        ExecutionResources resources = this.resourceCache.get(processId);
        if (resources == null) {
            throw new IllegalStateException("The executionId was not set for the current thread!");
        }
        resources.temporary.add(resource);
    }

    public Resource getOutputResource(String executionId, String fileName) {
        executionId = this.getExecutionId(executionId);
        Resource resource = this.artifactsStore.getArtifact(executionId, ProcessArtifactsStore.ArtifactType.Output, fileName);
        return resource;
    }

    public String getOutputResourceUrl(String name, String mimeType) {
        return this.getOutputResourceUrl(null, name, null, mimeType);
    }

    public String getOutputResourceUrl(String executionId, String name, String baseUrl, String mimeType) {
        LinkedHashMap<String, String> kvp = new LinkedHashMap<String, String>();
        kvp.put("service", "WPS");
        kvp.put("version", "1.0.0");
        kvp.put("request", "GetExecutionResult");
        kvp.put("executionId", this.getExecutionId(executionId));
        kvp.put("outputId", name);
        kvp.put("mimetype", mimeType);
        if (baseUrl == null) {
            Operation op = ((Request)Dispatcher.REQUEST.get()).getOperation();
            ExecuteType execute = (ExecuteType)op.getParameters()[0];
            baseUrl = execute.getBaseUrl();
        }
        String url = ResponseUtils.buildURL((String)baseUrl, (String)"ows", kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        Resource mimeResource = this.getOutputResource(this.getExecutionId(executionId), name + ".mime");
        try (OutputStream output = mimeResource.out();){
            IOUtils.write((String)mimeType, (OutputStream)output, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new WPSException("Error storing the output resource mime type", e);
        }
        return url;
    }

    public Resource getTemporaryResource(String extension) throws IOException {
        String executionId = this.getExecutionId((Boolean)null);
        Resource resource = this.artifactsStore.getArtifact(executionId, ProcessArtifactsStore.ArtifactType.Temporary, UUID.randomUUID().toString() + extension);
        this.addResource(new WPSResourceResource(resource));
        return resource;
    }

    public Resource getStoredResponse(String executionId) {
        return this.artifactsStore.getArtifact(executionId, ProcessArtifactsStore.ArtifactType.Response, null);
    }

    public ExecuteResponseType getStoredResponseObject(String executionId) throws IOException {
        ExecuteResponseType executeResponseType;
        block9: {
            Resource resource = this.getStoredResponse(executionId);
            if (resource == null || resource.getType() == Resource.Type.UNDEFINED) {
                return null;
            }
            InputStream in = resource.in();
            try {
                WPSConfiguration config = new WPSConfiguration();
                Parser parser = new Parser((Configuration)config);
                executeResponseType = (ExecuteResponseType)parser.parse(in);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw new WPSException("Could not parse the stored WPS response", e);
                }
            }
            in.close();
        }
        return executeResponseType;
    }

    public Resource getStoredRequest(String executionId) {
        return this.artifactsStore.getArtifact(executionId, ProcessArtifactsStore.ArtifactType.Request, null);
    }

    public ExecuteType getStoredRequestObject(String executionId) throws IOException {
        ExecuteType executeType;
        block9: {
            Resource resource = this.getStoredRequest(executionId);
            if (resource == null || resource.getType() == Resource.Type.UNDEFINED) {
                return null;
            }
            InputStream in = resource.in();
            try {
                WPSConfiguration config = new WPSConfiguration();
                Parser parser = new Parser((Configuration)config);
                executeType = (ExecuteType)parser.parse(in);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw new WPSException("Could not parse the stored WPS request", e);
                }
            }
            in.close();
        }
        return executeType;
    }

    public File getExternalOutputFile(String outPath, String outFile) throws IOException {
        Object canonicalDir;
        String canonicalFile;
        if (this.outputDirectory == null) {
            throw new WPSException("Writing to external output files is disabled");
        }
        File file = outFile != null ? new File(outPath, outFile) : new File(outPath);
        String path = file.getPath();
        if (Splitter.on((char)File.separatorChar).splitToStream((CharSequence)path).anyMatch(".."::equals)) {
            throw new IllegalArgumentException("Output file contains invalid '..' in path");
        }
        if (!file.isAbsolute()) {
            file = new File(this.outputDirectory, path).getAbsoluteFile();
        }
        if ((canonicalFile = file.getCanonicalPath()).startsWith((String)(canonicalDir = (String)canonicalDir + (((String)(canonicalDir = this.outputDirectory.getCanonicalPath())).endsWith(File.separator) ? "" : File.separator)))) {
            File parent = file.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                LOGGER.severe("Unable to create directory: " + parent);
                throw new WPSException("Output file parent directory does not exist and cannot be created");
            }
            return file;
        }
        LOGGER.warning("Output file " + canonicalFile + " is not in directory: " + (String)canonicalDir);
        throw new WPSException("Output file is not in the allowed directory");
    }

    public void setExternalOutputDirectory(String directory) {
        String path;
        File file = null;
        if (directory != null && !directory.trim().isEmpty() && !(file = new File(path = directory.trim())).isAbsolute()) {
            File base = this.resourceLoader.getBaseDirectory();
            file = Resources.find((Resource)Resources.fromURL((Resource)Files.asResource((File)base), (String)path), (boolean)true);
        }
        if (file != null) {
            this.outputDirectory = file.getAbsoluteFile();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Writing to output directory is allowed: " + this.outputDirectory);
            }
        } else {
            this.outputDirectory = null;
            LOGGER.fine("Writing to external output files is disabled");
        }
    }

    public void storeRequestObject(ExecuteType execute, String executionId) throws IOException {
        Resource resource = this.getStoredRequest(executionId);
        try (OutputStream out = resource.out();){
            WPSConfiguration config = new WPSConfiguration();
            Encoder encoder = new Encoder((Configuration)config);
            encoder.encode((Object)execute, WPS.Execute, out);
        }
    }

    public void finished(Request request) {
        if (this.executionId.get() == null) {
            return;
        }
        String id = this.executionId.get();
        this.executionId.remove();
        if (this.resourceCache.get((Object)id).synchronouos) {
            this.cleanProcess(id, false);
            this.resourceCache.remove(id);
        }
    }

    public void finished(String executionId) {
        this.executionId.remove();
        this.cleanProcess(executionId, false);
        this.resourceCache.get((Object)executionId).completionTime = System.currentTimeMillis();
    }

    public void cleanProcess(String id, boolean cancelled) {
        ExecutionResources executionResources = this.resourceCache.get(id);
        for (WPSResource resource : executionResources.temporary) {
            try {
                resource.delete();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Failed to clean up the WPS resource " + resource.getName(), t);
            }
        }
        if (cancelled) {
            try {
                this.artifactsStore.clearArtifacts(id);
            }
            catch (IOException e) {
                throw new WPSException("Failed to clear the process artifacts");
            }
        }
    }

    public Request init(Request request) {
        return null;
    }

    public Operation operationDispatched(Request request, Operation operation) {
        return null;
    }

    public Object operationExecuted(Request request, Operation operation, Object result) {
        return null;
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        return null;
    }

    public Service serviceDispatched(Request request, Service service) throws ServiceException {
        return null;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextClosedEvent || event instanceof ContextStoppedEvent) {
            for (String id : this.resourceCache.keySet()) {
                this.cleanProcess(id, false);
            }
            this.resourceCache.clear();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ProcessArtifactsStore store = (ProcessArtifactsStore)GeoServerExtensions.bean(ProcessArtifactsStore.class);
        if (store == null) {
            store = new DefaultProcessArtifactsStore();
        }
        this.artifactsStore = store;
    }

    public ProcessArtifactsStore getArtifactsStore() {
        return this.artifactsStore;
    }

    public void cleanExpiredResources(long expirationThreshold, ProcessStatusTracker tracker) {
        for (Resource r : this.artifactsStore.listExecutionResourcess()) {
            ExecutionStatus status = tracker.getStatus(r.name());
            if (status != null && !status.getPhase().isExecutionCompleted()) continue;
            this.cleanupResource(r, expirationThreshold);
        }
    }

    private boolean cleanupResource(Resource resource, long expirationThreshold) {
        boolean result = true;
        Resource.Type resourceType = resource.getType();
        if (resourceType == Resource.Type.RESOURCE && resource.lastmodified() < expirationThreshold) {
            result = resource.delete();
        } else if (resourceType == Resource.Type.DIRECTORY) {
            long directoryModified = resource.lastmodified();
            for (Resource child : resource.list()) {
                result &= this.cleanupResource(child, expirationThreshold);
            }
            if (result && directoryModified < expirationThreshold) {
                result &= resource.delete();
            }
        }
        return result;
    }

    @Override
    public void dismissed(ProcessEvent event) throws WPSException {
        String executionId = event.getStatus().getExecutionId();
        this.cleanProcess(executionId, true);
    }

    static final class ExecutionResources {
        List<WPSResource> temporary;
        boolean synchronouos;
        boolean outputLocked;
        long completionTime;

        public ExecutionResources(boolean synchronouos) {
            this.synchronouos = synchronouos;
            this.temporary = new ArrayList<WPSResource>();
        }
    }
}

