/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.resource;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wps.resource.WPSResource;

public class WPSFileResource
implements WPSResource {
    List<Resource> files;

    public WPSFileResource(List<Resource> files) {
        this.files = files;
    }

    public WPSFileResource(Resource file) {
        this(Collections.singletonList(file));
    }

    public WPSFileResource(File file) {
        this(Files.asResource((File)file));
    }

    @Override
    public void delete() throws Exception {
        for (Resource file : this.files) {
            file.delete();
        }
    }

    @Override
    public String getName() {
        if (this.files.size() == 1) {
            return this.files.get(0).path();
        }
        StringBuilder sb = new StringBuilder("Files: ");
        for (Resource file : this.files) {
            sb.append(file.path()).append(" ");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

