/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.property;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.geoserver.wps.WPSException;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.util.Converters;

public class BeanPropertyAccessor
implements PropertyAccessor {
    public boolean canHandle(Object object, String xpath, Class<?> target) {
        return true;
    }

    public <T> T get(Object object, String xpath, Class<T> target) throws IllegalArgumentException {
        String value;
        try {
            value = BeanUtils.getProperty((Object)object, (String)xpath);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new WPSException("Failed to retrieve property " + xpath + " in " + object, e);
        }
        if (target != null) {
            return (T)Converters.convert((Object)value, target);
        }
        return (T)value;
    }

    public <T> void set(Object object, String xpath, T value, Class<T> target) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }
}

