/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.process;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.wps.process.RawData;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.process.ProcessFactory;
import org.geotools.util.logging.Logging;

public abstract class AbstractRawData
implements RawData {
    static final Logger LOGGER = Logging.getLogger(AbstractRawData.class);
    protected String mimeType;
    protected String extension = "bin";
    public static final String BINARY_MIME = "application/octet-stream";
    public static final String MIME_TYPES = "mimeTypes";
    public static final String DEFAULT_EXTENSION = "bin";
    public static final String SELECTION_ATTRIBUTE = "chosenMimeType";

    public AbstractRawData(String mimeType) {
        this.mimeType = mimeType;
    }

    public AbstractRawData(String mimeType, String extension) {
        this.mimeType = mimeType;
        this.extension = extension;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getFileExtension() {
        return this.extension;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.extension == null ? 0 : this.extension.hashCode());
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractRawData other = (AbstractRawData)obj;
        if (this.extension == null ? other.extension != null : !this.extension.equals(other.extension)) {
            return false;
        }
        return !(this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType));
    }

    public static String[] getMimeTypes(Parameter<?> p) {
        String mimeTypes;
        if (p.metadata != null && p.metadata.get(MIME_TYPES) != null && !(mimeTypes = (String)p.metadata.get(MIME_TYPES)).trim().isEmpty()) {
            return mimeTypes.split("\\s*,\\s*");
        }
        return new String[]{BINARY_MIME};
    }

    public static Map<String, String> getOutputMimeParameters(Name processName, ProcessFactory pf) {
        Map resultInfo = pf.getResultInfo(processName, null);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Parameter p : resultInfo.values()) {
            String attribute;
            if (!RawData.class.isAssignableFrom(p.getType()) || (attribute = (String)p.metadata.get(SELECTION_ATTRIBUTE)) == null) continue;
            if (result.containsValue(attribute)) {
                LOGGER.warning("In process " + processName + " two raw results parameter are using the same input attribute " + attribute + " to notify the process of the user chosen mime type");
                continue;
            }
            result.put(p.key, attribute);
        }
        return result;
    }

    public static String getDefaultMime(Name processName, ProcessFactory pf, String resultName) {
        Map resultInfo = pf.getResultInfo(processName, null);
        Parameter parameter = (Parameter)resultInfo.get(resultName);
        if (parameter == null) {
            LOGGER.warning("Looked up raw result " + resultName + " in process " + processName + " but found none, returned default mime type");
            return BINARY_MIME;
        }
        return AbstractRawData.getMimeTypes(parameter)[0];
    }
}

