/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.geoserver.wps.ppio.CDataPPIO;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;

public class WKTPPIO
extends CDataPPIO {
    protected WKTPPIO() {
        super(Geometry.class, Geometry.class, "application/wkt");
    }

    @Override
    public Object decode(InputStream input) throws Exception {
        return new WKTReader().read((Reader)new InputStreamReader(input));
    }

    @Override
    public Object decode(String input) throws Exception {
        return new WKTReader().read((Reader)new StringReader(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Object value, OutputStream os) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(os);
        try {
            Geometry g = (Geometry)value;
            if (g instanceof LinearRing) {
                g = g.getFactory().createLineString(((LinearRing)g).getCoordinateSequence());
            }
            new WKTWriter().write(g, (Writer)w);
        }
        finally {
            ((Writer)w).flush();
        }
    }

    @Override
    public String getFileExtension() {
        return "wkt";
    }
}

