/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wps.ppio.CDataPPIO;
import org.geotools.data.geojson.GeoJSONReader;
import org.geotools.data.geojson.GeoJSONWriter;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.locationtech.jts.geom.Geometry;

public abstract class GeoJSONPPIO
extends CDataPPIO {
    static final ObjectMapper MAPPER = new ObjectMapper();
    GeoServer gs;

    protected GeoJSONPPIO(Class<?> clazz) {
        super(clazz, clazz, "application/json");
        this.gs = (GeoServer)GeoServerExtensions.bean((String)"geoServer");
    }

    protected GeoJSONPPIO(Class<?> clazz, GeoServer gs) {
        super(clazz, clazz, "application/json");
        this.gs = gs;
    }

    @Override
    public abstract void encode(Object var1, OutputStream var2) throws IOException;

    @Override
    public abstract Object decode(InputStream var1) throws Exception;

    @Override
    public abstract Object decode(String var1) throws Exception;

    @Override
    public final String getFileExtension() {
        return "json";
    }

    static {
        JtsModule module = new JtsModule(6);
        MAPPER.registerModule((Module)module);
    }

    public static class Geometries
    extends GeoJSONPPIO {
        public Geometries() {
            super(Geometry.class);
        }

        protected Geometries(GeoServer gs) {
            super(Geometry.class, gs);
        }

        @Override
        public void encode(Object value, OutputStream os) throws IOException {
            int decimals = this.gs.getSettings().getNumDecimals();
            ObjectMapper mapper = this.getMapper(decimals);
            mapper.writeValue(os, value);
        }

        private ObjectMapper getMapper(int decimals) {
            if (decimals == 6) {
                return MAPPER;
            }
            ObjectMapper mapper = new ObjectMapper();
            JtsModule module = new JtsModule(decimals);
            mapper.registerModule((Module)module);
            return mapper;
        }

        @Override
        public Object decode(InputStream input) throws Exception {
            return MAPPER.readValue(input, Geometry.class);
        }

        @Override
        public Object decode(String input) throws Exception {
            return MAPPER.readValue(input, Geometry.class);
        }
    }

    public static class FeatureCollections
    extends GeoJSONPPIO {
        public FeatureCollections() {
            super(FeatureCollection.class);
        }

        protected FeatureCollections(GeoServer gs) {
            super(FeatureCollection.class, gs);
        }

        @Override
        public void encode(Object value, OutputStream os) throws IOException {
            int decimals = this.gs.getSettings().getNumDecimals();
            try (GeoJSONWriter writer = new GeoJSONWriter(os);){
                writer.setMaxDecimals(decimals);
                writer.writeFeatureCollection((SimpleFeatureCollection)value);
            }
        }

        @Override
        public Object decode(InputStream input) throws Exception {
            try (GeoJSONReader reader = new GeoJSONReader(input);){
                SimpleFeatureCollection simpleFeatureCollection = reader.getFeatures();
                return simpleFeatureCollection;
            }
        }

        @Override
        public Object decode(String input) throws Exception {
            try (GeoJSONReader reader = new GeoJSONReader(input);){
                SimpleFeatureCollection simpleFeatureCollection = reader.getFeatures();
                return simpleFeatureCollection;
            }
        }
    }
}

