/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.AdminRequest;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.gs.GeoServerProcess;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.gml2.SrsSyntax;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;
import org.springframework.security.core.context.SecurityContextHolder;
import org.vfny.geoserver.util.WCSUtils;

@DescribeProcess(title="Import to Catalog", description="Imports a feature collection into the catalog")
public class ImportProcess
implements GeoServerProcess {
    static final Logger LOGGER = Logging.getLogger(ImportProcess.class);
    private static final GeoTiffWriteParams DEFAULT_WRITE_PARAMS = new GeoTiffWriteParams();
    private Catalog catalog;

    public ImportProcess(Catalog catalog) {
        this.catalog = catalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DescribeResult(name="layerName", description="Name of the new featuretype, with workspace")
    public String execute(@DescribeParameter(name="features", min=0, description="Input feature collection") SimpleFeatureCollection features, @DescribeParameter(name="coverage", min=0, description="Input raster") GridCoverage2D coverage, @DescribeParameter(name="workspace", min=0, description="Target workspace (default is the system default)") String workspace, @DescribeParameter(name="store", min=0, description="Target store (default is the workspace default)") String store, @DescribeParameter(name="name", min=0, description="Name of the new featuretype/coverage (default is the name of the features in the collection)") String name, @DescribeParameter(name="srs", min=0, description="Target coordinate reference system (default is based on source when possible)") CoordinateReferenceSystem srs, @DescribeParameter(name="srsHandling", min=0, description="Desired SRS handling (default is FORCE_DECLARED, others are REPROJECT_TO_DECLARED or NONE)") ProjectionPolicy srsHandling, @DescribeParameter(name="styleName", min=0, description="Name of the style to be associated with the layer (default is a standard geometry-specific style)") String styleName, ProgressListener listener) throws ProcessException {
        WorkspaceInfo ws;
        if (listener == null) {
            listener = new NullProgressListener();
        }
        listener.started();
        listener.progress(0.0f);
        if (workspace != null) {
            ws = this.catalog.getWorkspaceByName(workspace);
            if (ws == null) {
                throw new ProcessException("Could not find workspace " + workspace);
            }
        } else {
            ws = this.catalog.getDefaultWorkspace();
            if (ws == null) {
                throw new ProcessException("The catalog is empty, could not find a default workspace");
            }
        }
        try {
            AdminRequest.start((Object)this);
            String string = this.executeAsAdminRequest(features, coverage, workspace, ws, store, name, srs, srsHandling, styleName, listener);
            return string;
        }
        finally {
            AdminRequest.finish();
        }
    }

    private String executeAsAdminRequest(SimpleFeatureCollection features, GridCoverage2D coverage, String workspace, WorkspaceInfo ws, String store, String name, CoordinateReferenceSystem srs, ProjectionPolicy srsHandling, String styleName, ProgressListener listener) {
        ImportProcess.checkAdminAccess(ws);
        CatalogBuilder cb = new CatalogBuilder(this.catalog);
        cb.setWorkspace(ws);
        DataStoreInfo storeInfo = null;
        boolean add = false;
        if (store != null) {
            if (features != null) {
                storeInfo = this.catalog.getDataStoreByName(ws.getName(), store);
            } else if (coverage != null) {
                storeInfo = this.catalog.getCoverageStoreByName(ws.getName(), store);
            }
            if (storeInfo == null) {
                if (features != null) {
                    storeInfo = this.catalog.getDefaultDataStore(ws);
                    if (storeInfo == null) {
                        throw new ProcessException("Could not find a default store in workspace " + ws.getName());
                    }
                } else if (coverage != null) {
                    storeInfo = cb.buildCoverageStore(store);
                    add = true;
                    LOGGER.info("Creating store " + store + " since it did not exist");
                }
            }
        } else if (features != null) {
            storeInfo = this.catalog.getDefaultDataStore(ws);
            if (storeInfo == null) {
                throw new ProcessException("Could not find a default store in workspace " + ws.getName());
            }
        } else if (coverage != null) {
            LOGGER.info("Auto-configuring coverage store: " + (name != null ? name : coverage.getName().toString()));
            storeInfo = cb.buildCoverageStore(name != null ? name : coverage.getName().toString());
            add = true;
            String string = store = name != null ? name : coverage.getName().toString();
            if (storeInfo == null) {
                throw new ProcessException("Could not find a default store in workspace " + ws.getName());
            }
        }
        this.checkForCancellation(listener);
        StyleInfo targetStyle = null;
        if (styleName != null && (targetStyle = this.catalog.getStyleByName(styleName)) == null) {
            throw new ProcessException("Could not find style " + styleName);
        }
        if (features != null) {
            this.checkNameConflict(features, name, ws);
            return this.importFeatures(features, name, srs, srsHandling, listener, cb, (StoreInfo)storeInfo, targetStyle);
        }
        if (coverage != null) {
            return this.importCoverage(coverage, workspace, store, name, srs, styleName, listener, cb, (StoreInfo)storeInfo, add, targetStyle);
        }
        return null;
    }

    private static void checkAdminAccess(WorkspaceInfo info) {
        WorkspaceAccessLimits wl = ((SecureCatalogImpl)GeoServerExtensions.bean(SecureCatalogImpl.class)).getResourceAccessManager().getAccessLimits(SecurityContextHolder.getContext().getAuthentication(), info);
        if (wl == null || !wl.isAdminable()) {
            throw new ProcessException("Operation unallowed with the current privileges");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String importCoverage(GridCoverage2D coverage, String workspace, String store, String name, CoordinateReferenceSystem srs, String styleName, ProgressListener listener, CatalogBuilder cb, StoreInfo storeInfo, boolean add, StyleInfo targetStyle) {
        try {
            LayerInfo layerInfo;
            CoordinateReferenceSystem cvCrs;
            File file;
            block37: {
                Resource directory = this.catalog.getResourceLoader().get(Paths.path((String[])new String[]{"data", workspace, store}));
                file = File.createTempFile(store, ".tif", directory.dir());
                ((CoverageStoreInfo)storeInfo).setURL(URLs.fileToUrl((File)file).toExternalForm());
                storeInfo.setType("GeoTIFF");
                cvCrs = coverage.getCoordinateReferenceSystem();
                if (srs != null) {
                    try {
                        String code = ResourcePool.lookupIdentifier((CoordinateReferenceSystem)srs, (boolean)true);
                        if (code == null) {
                            throw new WPSException("Could not find a EPSG code for " + srs);
                        }
                        break block37;
                    }
                    catch (Exception e) {
                        throw new ProcessException("Could not lookup the EPSG code for the provided srs", (Throwable)e);
                    }
                }
                if (cvCrs == null) {
                    srs = DefaultGeographicCRS.WGS84;
                } else {
                    CoordinateReferenceSystem nativeCrs = cvCrs;
                    if (nativeCrs == null) {
                        throw new ProcessException("The original data has no native CRS, you need to specify the srs parameter");
                    }
                    srs = CRS.decode((String)ImportProcess.getSRSFromCRS(nativeCrs), (boolean)true);
                }
            }
            this.checkForCancellation(listener);
            MathTransform tx = CRS.findMathTransform((CoordinateReferenceSystem)cvCrs, (CoordinateReferenceSystem)srs);
            if (!tx.isIdentity() || !CRS.equalsIgnoreMetadata((Object)cvCrs, (Object)srs)) {
                coverage = WCSUtils.resample((GridCoverage2D)coverage, (CoordinateReferenceSystem)cvCrs, (CoordinateReferenceSystem)srs, null, (Interpolation)Interpolation.getInstance((int)0));
            }
            GeoTiffWriter writer = new GeoTiffWriter((Object)file);
            ParameterValueGroup params = new GeoTiffFormat().getWriteParameters();
            params.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)DEFAULT_WRITE_PARAMS);
            GeneralParameterValue[] wps = params.values().toArray(new GeneralParameterValue[1]);
            try {
                writer.write((GridCoverage)coverage, wps);
            }
            finally {
                try {
                    writer.dispose();
                }
                catch (Exception exception) {}
            }
            this.checkForCancellation(listener);
            if (add) {
                this.catalog.add(storeInfo);
            } else {
                this.catalog.save(storeInfo);
            }
            cb.setStore(storeInfo);
            GeoTiffReader reader = new GeoTiffReader((Object)file);
            if (reader == null) {
                throw new ProcessException("Could not aquire reader for coverage.");
            }
            HashMap customParameters = new HashMap();
            CoverageInfo cinfo = cb.buildCoverage((GridCoverage2DReader)reader, customParameters);
            if (name != null) {
                cinfo.setName(name);
            }
            this.checkForCancellation(listener);
            if (!add) {
                CoverageInfo existing = this.catalog.getCoverageByCoverageStore((CoverageStoreInfo)storeInfo, name != null ? name : coverage.getName().toString());
                if (existing == null) {
                    List coverages = this.catalog.getCoveragesByCoverageStore((CoverageStoreInfo)storeInfo);
                    if (coverages.size() == 1) {
                        existing = (CoverageInfo)coverages.get(0);
                    }
                    if (coverages.isEmpty()) {
                        add = true;
                    } else {
                        throw new ProcessException("Unable to determine coverage to configure.");
                    }
                }
                if (existing != null) {
                    cb.updateCoverage(existing, cinfo);
                    this.catalog.save((ResourceInfo)existing);
                    cinfo = existing;
                }
            }
            if ("UNKNOWN".equals(cinfo.getSRS())) {
                cinfo.setSRS("EPSG:4326");
            }
            this.checkForCancellation(listener);
            if (add) {
                this.catalog.add((ResourceInfo)cinfo);
                layerInfo = cb.buildLayer(cinfo);
                if (styleName != null && targetStyle != null) {
                    layerInfo.setDefaultStyle(targetStyle);
                }
                boolean valid = true;
                try {
                    if (!this.catalog.validate(layerInfo, true).isValid()) {
                        valid = false;
                    }
                }
                catch (Exception e) {
                    valid = false;
                }
                layerInfo.setEnabled(valid);
                this.catalog.add(layerInfo);
                return layerInfo.prefixedName();
            }
            this.catalog.save((ResourceInfo)cinfo);
            layerInfo = this.catalog.getLayerByName(cinfo.getName());
            if (styleName != null && targetStyle != null) {
                layerInfo.setDefaultStyle(targetStyle);
            }
            listener.progress(100.0f);
            listener.complete();
            return layerInfo.prefixedName();
        }
        catch (ProcessException e) {
            throw e;
        }
        catch (MalformedURLException e) {
            throw new ProcessException("URL Error", (Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessException("I/O Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "", e);
            throw new ProcessException("Exception", (Throwable)e);
        }
    }

    private String importFeatures(SimpleFeatureCollection features, String name, CoordinateReferenceSystem srs, ProjectionPolicy srsHandling, ProgressListener listener, CatalogBuilder cb, StoreInfo storeInfo, StyleInfo targetStyle) {
        SimpleFeatureType targetType;
        String targetSRSCode = null;
        if (srs != null) {
            targetSRSCode = ImportProcess.getSRSFromCRS(srs);
        } else {
            GeometryDescriptor gd = ((SimpleFeatureType)features.getSchema()).getGeometryDescriptor();
            if (gd == null) {
                targetSRSCode = "EPSG:4326";
                srsHandling = ProjectionPolicy.FORCE_DECLARED;
            } else {
                CoordinateReferenceSystem nativeCrs = gd.getCoordinateReferenceSystem();
                if (nativeCrs == null) {
                    throw new ProcessException("The original data has no native CRS, you need to specify the srs parameter");
                }
                targetSRSCode = ImportProcess.getSRSFromCRS(nativeCrs);
            }
        }
        this.checkForCancellation(listener);
        try {
            targetType = this.importDataIntoStore(features, name, (DataStoreInfo)storeInfo, listener);
        }
        catch (IOException e) {
            throw new ProcessException("Failed to import data into the target store", (Throwable)e);
        }
        try {
            cb.setStore(storeInfo);
            FeatureTypeInfo typeInfo = cb.buildFeatureType(targetType.getName());
            if (targetSRSCode != null) {
                typeInfo.setSRS(targetSRSCode);
            }
            if (srsHandling != null) {
                typeInfo.setProjectionPolicy(srsHandling);
            }
            cb.setupBounds((ResourceInfo)typeInfo);
            LayerInfo layerInfo = cb.buildLayer(typeInfo);
            if (targetStyle != null) {
                layerInfo.setDefaultStyle(targetStyle);
            }
            this.checkForCancellation(listener);
            this.catalog.add((ResourceInfo)typeInfo);
            this.catalog.add(layerInfo);
            listener.progress(100.0f);
            listener.complete();
            return layerInfo.prefixedName();
        }
        catch (ProcessException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ProcessException("Failed to complete the import inside the GeoServer catalog", (Throwable)e);
        }
    }

    private static String getSRSFromCRS(CoordinateReferenceSystem nativeCrs) {
        String targetSRSCode;
        try {
            String identifier = ResourcePool.lookupIdentifier((CoordinateReferenceSystem)nativeCrs, (boolean)true);
            if (identifier == null) {
                throw new ProcessException("Could not find an EPSG identifier for data native spatial reference system: " + nativeCrs);
            }
            targetSRSCode = SrsSyntax.AUTH_CODE.getSRS(identifier);
        }
        catch (Exception e) {
            throw new ProcessException("Failed to loookup an official EPSG code for the source data native spatial reference system", (Throwable)e);
        }
        return targetSRSCode;
    }

    private void checkNameConflict(SimpleFeatureCollection features, String name, WorkspaceInfo ws) {
        String tentativeTargetName = name != null ? ws.getName() + ":" + name : ws.getName() + ":" + ((SimpleFeatureType)features.getSchema()).getTypeName();
        if (this.catalog.getLayer(tentativeTargetName) != null) {
            throw new ProcessException("Target layer " + tentativeTargetName + " already exists");
        }
    }

    private SimpleFeatureType importDataIntoStore(SimpleFeatureCollection features, String name, DataStoreInfo storeInfo, ProgressListener listener) throws IOException, ProcessException {
        DataStore ds = (DataStore)storeInfo.getDataStore(null);
        SimpleFeatureType sourceType = (SimpleFeatureType)features.getSchema();
        if (name != null) {
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.init(sourceType);
            tb.setName(name);
            sourceType = tb.buildFeatureType();
        }
        ds.createSchema((FeatureType)sourceType);
        SimpleFeatureType targetType = ds.getSchema(sourceType.getTypeName());
        if (targetType == null) {
            targetType = ds.getSchema(sourceType.getTypeName().toUpperCase());
        }
        if (targetType == null) {
            throw new WPSException("The target schema was created, but with a name that we cannot relate to the one we provided the data store. Cannot proceeed further");
        }
        String newLayerName = storeInfo.getWorkspace().getName() + ":" + targetType.getTypeName();
        LayerInfo layer = this.catalog.getLayerByName(newLayerName);
        if (layer != null) {
            throw new ProcessException("Target layer " + newLayerName + " already exists in the catalog");
        }
        Map<String, String> mapping = this.buildAttributeMapping(sourceType, targetType);
        this.copyFeatures(features, listener, ds, targetType, mapping);
        return targetType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFeatures(SimpleFeatureCollection features, ProgressListener listener, DataStore ds, SimpleFeatureType targetType, Map<String, String> mapping) throws IOException {
        SimpleFeatureStore fstore = (SimpleFeatureStore)ds.getFeatureSource(targetType.getTypeName());
        DefaultTransaction t = new DefaultTransaction();
        fstore.setTransaction((Transaction)t);
        boolean complete = false;
        try (SimpleFeatureIterator fi = features.features();){
            SimpleFeatureBuilder fb = new SimpleFeatureBuilder(targetType);
            while (fi.hasNext()) {
                SimpleFeature source = (SimpleFeature)fi.next();
                fb.reset();
                for (String sname : mapping.keySet()) {
                    fb.set(mapping.get(sname), source.getAttribute(sname));
                }
                SimpleFeature target = fb.buildFeature(null);
                fstore.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)target));
                this.checkForCancellation(listener);
            }
            t.commit();
            complete = true;
        }
        finally {
            if (!complete) {
                t.rollback();
            }
            t.close();
        }
    }

    private void checkForCancellation(ProgressListener listener) {
        if (listener.isCanceled()) {
            throw new ProcessException(listener.getTask().toString());
        }
    }

    Map<String, String> buildAttributeMapping(SimpleFeatureType sourceType, SimpleFeatureType targetType) {
        HashSet<String> sourceNames = new HashSet<String>();
        for (AttributeDescriptor sd : sourceType.getAttributeDescriptors()) {
            sourceNames.add(sd.getLocalName());
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String name : sourceNames) {
            if (targetType.getDescriptor(name) == null) continue;
            result.put(name, name);
        }
        sourceNames.removeAll(result.keySet());
        block2: for (String name : sourceNames) {
            for (AttributeDescriptor td : targetType.getAttributeDescriptors()) {
                if (!td.getLocalName().equalsIgnoreCase(name)) continue;
                result.put(name, td.getLocalName());
                continue block2;
            }
        }
        sourceNames.removeAll(result.keySet());
        block4: for (String name : sourceNames) {
            String loName = name.toLowerCase();
            for (AttributeDescriptor td : targetType.getAttributeDescriptors()) {
                String tdName = td.getLocalName().toLowerCase();
                if (!loName.startsWith(tdName)) continue;
                result.put(name, td.getLocalName());
                continue block4;
            }
        }
        sourceNames.removeAll(result.keySet());
        if (targetType.getGeometryDescriptor() != null && "the_geom".equals(targetType.getGeometryDescriptor().getLocalName()) && !"the_geom".equalsIgnoreCase(sourceType.getGeometryDescriptor().getLocalName())) {
            result.put(sourceType.getGeometryDescriptor().getLocalName(), "the_geom");
        }
        if (!sourceNames.isEmpty()) {
            LOGGER.warning("Could not match the following attributes " + sourceNames + " to the target feature type ones: " + targetType);
        }
        return result;
    }

    static {
        DEFAULT_WRITE_PARAMS.setCompressionMode(2);
        DEFAULT_WRITE_PARAMS.setCompressionType("LZW");
        DEFAULT_WRITE_PARAMS.setCompressionQuality(0.75f);
        DEFAULT_WRITE_PARAMS.setTilingMode(2);
        DEFAULT_WRITE_PARAMS.setTiling(512, 512);
    }
}

