/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.gs;

import com.google.common.base.Splitter;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.gs.GeoServerProcess;
import org.geoserver.wps.gs.GeorectifyConfiguration;
import org.geoserver.wps.resource.WPSFileResource;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.data.Query;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.image.ImageWorker;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.factory.DescribeResults;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;

@DescribeProcess(title="Georectify Coverage", description="Georectifies a raster via Ground Control Points using gdal_warp")
public class GeorectifyCoverage
implements GeoServerProcess {
    static final Logger LOGGER = Logging.getLogger(GeorectifyCoverage.class);
    private static final Pattern GCP_PATTERN = Pattern.compile("\\[((\\+|-)?[0-9]+(.[0-9]+)?),\\s*((\\+|-)?[0-9]+(.[0-9]+)?)(,\\s*((\\+|-)?[0-9]+(.[0-9]+)?))?\\]");
    GeorectifyConfiguration config;
    WPSResourceManager resourceManager;

    public GeorectifyConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(GeorectifyConfiguration config) {
        this.config = config;
    }

    public GeorectifyCoverage(GeorectifyConfiguration config) {
        this.config = config;
    }

    public GeorectifyCoverage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DescribeResults(value={@DescribeResult(name="result", description="Georectified raster", type=GridCoverage2D.class), @DescribeResult(name="path", description="Pathname of the generated raster on the server", type=String.class)})
    public Map<String, Object> execute(@DescribeParameter(name="data", description="Input raster") GridCoverage2D coverage, @DescribeParameter(name="gcp", description="List of Ground control points.  Points are specified as [x,y] or [x,y,z].") String gcps, @DescribeParameter(name="bbox", description="Bounding box for output", min=0) Envelope bbox, @DescribeParameter(name="targetCRS", description="Coordinate reference system to use for the output raster") CoordinateReferenceSystem crs, @DescribeParameter(name="width", description="Width of output raster in pixels", min=0) Integer width, @DescribeParameter(name="height", description="Height of output raster in pixels", min=0) Integer height, @DescribeParameter(name="warpOrder", min=0, description="Order of the warping polynomial (1 to 3)") Integer warpOrder, @DescribeParameter(name="transparent", min=0, description="Force output to have transparent background", defaultValue="true") Boolean transparent, @DescribeParameter(name="store", min=0, description="Indicates whether to keep the output file after processing", defaultValue="false") Boolean store, @DescribeParameter(name="outputPath", min=0, description="Pathname where the output file is stored") String outputPath) throws IOException {
        GeoTiffReader reader = null;
        ArrayList<File> removeFiles = new ArrayList<File>();
        String location = null;
        try {
            int[] gcpNum;
            List<String> gcp;
            File vrtFile;
            Object fileSource;
            ColorModel cm;
            File tempFolder = this.config.getTempFolder();
            File loggingFolder = this.config.getLoggingFolder();
            boolean forceTransparent = false;
            if (transparent == null) {
                transparent = true;
            }
            if ((cm = coverage.getRenderedImage().getColorModel()).getTransparency() == 1 && transparent.booleanValue()) {
                forceTransparent = true;
            }
            if ((fileSource = coverage.getProperty("OriginalFileSource")) != null && fileSource instanceof String) {
                location = (String)fileSource;
            }
            if (location == null) {
                RenderedImage image = coverage.getRenderedImage();
                if (forceTransparent) {
                    ImageWorker iw = new ImageWorker(image);
                    iw.forceComponentColorModel();
                    ImageLayout tempLayout = new ImageLayout(image);
                    tempLayout.unsetValid(512).unsetValid(256);
                    RenderedOp alpha = ConstantDescriptor.create((Float)Float.valueOf(image.getWidth()), (Float)Float.valueOf(image.getHeight()), (Number[])new Byte[]{(byte)-1}, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, tempLayout));
                    iw.addBand((RenderedImage)alpha, false);
                    image = iw.getRenderedImage();
                    cm = image.getColorModel();
                }
                File storedImageFile = this.storeImage(image, tempFolder);
                location = storedImageFile.getAbsolutePath();
                removeFiles.add(storedImageFile);
            }
            if ((vrtFile = this.addGroundControlPoints(location, gcp = this.parseGcps(gcps, gcpNum = new int[1]), GeorectifyCoverage.splitToList(this.config.getGdalTranslateParameters()))) == null || !vrtFile.exists() || !vrtFile.canRead()) {
                throw new IOException("Unable to get a valid file with attached Ground Control Points");
            }
            removeFiles.add(vrtFile);
            File warpedFile = this.warpFile(vrtFile, bbox, crs, width, height, warpOrder, tempFolder, loggingFolder, this.config.getExecutionTimeout(), GeorectifyCoverage.splitToList(this.config.getGdalTranslateParameters()));
            if (warpedFile == null || !warpedFile.exists() || !warpedFile.canRead()) {
                throw new IOException("Unable to get a valid georectified file");
            }
            boolean expand = false;
            if (cm instanceof IndexColorModel) {
                expand = true;
            } else if (cm instanceof ComponentColorModel && cm.getNumComponents() == 1 && cm.getComponentSize()[0] == 1) {
                expand = true;
            }
            if (expand) {
                removeFiles.add(warpedFile);
                warpedFile = this.expandRgba(warpedFile.getAbsolutePath());
            }
            if (Boolean.TRUE.equals(store) && outputPath != null) {
                try {
                    File output = this.resourceManager.getExternalOutputFile(outputPath, null);
                    if (output.exists() && !output.delete()) {
                        throw new WPSException("Output file " + outputPath + " exists but cannot be overwritten");
                    }
                    if (!warpedFile.renameTo(output)) {
                        throw new WPSException("Could not move " + warpedFile.getAbsolutePath() + " to " + outputPath + ", it's likely a permission issue");
                    }
                    warpedFile = output;
                }
                catch (Exception e) {
                    removeFiles.add(warpedFile);
                    throw e;
                }
            }
            if (this.resourceManager != null && !Boolean.TRUE.equals(store)) {
                this.resourceManager.addResource(new WPSFileResource(warpedFile));
            }
            reader = new GeoTiffReader((Object)warpedFile);
            GridCoverage2D cov = this.addLocationProperty(reader.read(null), warpedFile);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("result", cov);
            result.put("path", warpedFile.getAbsolutePath());
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (Throwable throwable) {}
            }
            for (File file : removeFiles) {
                GeorectifyCoverage.deleteFile(file);
            }
        }
    }

    GridCoverage2D addLocationProperty(GridCoverage2D coverage, File warpedFile) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("OriginalFileSource", warpedFile.getAbsolutePath());
        properties.putAll(coverage.getProperties());
        return new GridCoverageFactory().create((CharSequence)coverage.getName(), coverage.getRenderedImage(), coverage.getGridGeometry(), coverage.getSampleDimensions(), null, properties);
    }

    public Query invertQuery(Query targetQuery, GridGeometry gridGeometry) {
        return targetQuery;
    }

    public GridGeometry invertGridGeometry(Query targetQuery, GridGeometry targetGridGeometry) {
        return null;
    }

    private File storeImage(RenderedImage image, File tempFolder) throws IOException {
        File file = File.createTempFile("readCoverage", ".tif", tempFolder);
        new ImageWorker(image).writeTIFF((Object)file, null, 0.0f, 256, 256);
        return file;
    }

    private File warpFile(File originalFile, Envelope targetEnvelope, CoordinateReferenceSystem targetCRS, Integer width, Integer height, Integer order, File tempFolder, File loggingFolder, Long timeOut, List<String> warpingParameters) throws IOException {
        File file = File.createTempFile("warped", ".tif", tempFolder);
        String vrtFilePath = originalFile.getAbsolutePath();
        String outputFilePath = file.getAbsolutePath();
        List<String> tEnvelope = GeorectifyCoverage.parseBBox(targetEnvelope);
        String tCrs = GeorectifyCoverage.parseCrs(targetCRS);
        List<String> arguments = GeorectifyCoverage.buildWarpArguments(tEnvelope, width, height, tCrs, order, vrtFilePath, outputFilePath, warpingParameters);
        String gdalCommand = this.config.getWarpingCommand();
        GeorectifyCoverage.executeCommand(gdalCommand, arguments, loggingFolder, this.config.getEnvVariables());
        return file;
    }

    private static final List<String> buildWarpArguments(List<String> targetEnvelope, Integer width, Integer height, String targetCrs, Integer order, String inputFilePath, String outputFilePath, List<String> warpingParameters) {
        ArrayList<String> result = new ArrayList<String>();
        if (targetEnvelope != null && !targetEnvelope.isEmpty()) {
            result.add("-te");
            result.addAll(targetEnvelope);
        }
        if (width != null && height != null) {
            result.add("-ts");
            result.add(Integer.toString(width));
            result.add(Integer.toString(height));
        }
        result.add("-t_srs");
        result.add(targetCrs);
        if (order != null) {
            result.add("-order");
            result.add(Integer.toString(order));
        }
        result.addAll(warpingParameters);
        result.add(inputFilePath);
        result.add(outputFilePath);
        return result;
    }

    /*
     * Exception decompiling
     */
    private static String getError(File logFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<String> parseBBox(Envelope re) {
        if (re == null) {
            return Collections.emptyList();
        }
        return DoubleStream.of(re.getMinX(), re.getMinY(), re.getMaxX(), re.getMaxY()).mapToObj(Double::toString).collect(Collectors.toList());
    }

    private static String parseCrs(CoordinateReferenceSystem crs) {
        Utilities.ensureNonNull((String)"coordinateReferenceSystem", (Object)crs);
        try {
            return ResourcePool.lookupIdentifier((CoordinateReferenceSystem)crs, (boolean)true);
        }
        catch (FactoryException e) {
            throw new WPSException("Error occurred looking up target SRS");
        }
    }

    private File addGroundControlPoints(String originalFilePath, List<String> gcp, List<String> parameters) throws IOException {
        File vrtFile = File.createTempFile("vrt_", ".vrt", this.config.getTempFolder());
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-of");
        arguments.add("VRT");
        arguments.addAll(parameters);
        arguments.addAll(gcp);
        arguments.add(originalFilePath);
        arguments.add(vrtFile.getAbsolutePath());
        String gdalCommand = this.config.getTranslateCommand();
        GeorectifyCoverage.executeCommand(gdalCommand, arguments, this.config.getLoggingFolder(), this.config.getEnvVariables());
        if (vrtFile != null && vrtFile.exists() && vrtFile.canRead()) {
            return vrtFile;
        }
        return vrtFile;
    }

    private File expandRgba(String originalFilePath) throws IOException {
        File expandedFile = File.createTempFile("rgba", ".tif", this.config.getTempFolder());
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(GeorectifyCoverage.splitToList("-expand RGBA -co TILED=yes -co COMPRESS=LZW"));
        arguments.add(originalFilePath);
        arguments.add(expandedFile.getAbsolutePath());
        String gdalCommand = this.config.getTranslateCommand();
        GeorectifyCoverage.executeCommand(gdalCommand, arguments, this.config.getLoggingFolder(), this.config.getEnvVariables());
        return expandedFile;
    }

    private static void executeCommand(String gdalCommand, List<String> arguments, File loggingFolder, Map<String, String> envVars) throws IOException {
        File logFile = File.createTempFile("LOG", ".log", loggingFolder);
        ArrayList<String> commands = new ArrayList<String>(arguments);
        commands.add(0, gdalCommand);
        ProcessBuilder builder = new ProcessBuilder(commands);
        if (envVars != null) {
            builder.environment().putAll(envVars);
        } else {
            builder.environment().putAll(System.getenv());
        }
        builder.redirectErrorStream(true);
        int exitValue = 0;
        try (FileOutputStream log = new FileOutputStream(logFile);){
            Process p = builder.start();
            IOUtils.copy((InputStream)p.getInputStream(), (OutputStream)log);
            p.waitFor();
            log.flush();
            exitValue = p.exitValue();
        }
        catch (Exception e) {
            throw new WPSException("Error launching OS command: " + gdalCommand + " with arguments " + arguments + " and env vars " + envVars, e);
        }
        finally {
            if (exitValue != 0 && logFile.exists() && logFile.canRead()) {
                String error = GeorectifyCoverage.getError(logFile);
                throw new WPSException("Error launching OS command: '" + gdalCommand + "' with arguments '" + arguments + "' and env vars '" + envVars + "': \n" + error);
            }
            if (logFile != null) {
                logFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable() {
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        try {
            GeorectifyCoverage.executeCommand("gdal_translate", Collections.singletonList("--version"), tmp, this.config.getEnvVariables());
            GeorectifyCoverage.executeCommand("gdalwarp", Collections.singletonList("--version"), tmp, this.config.getEnvVariables());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "GDAL utilities are not available", e);
            boolean bl = false;
            return bl;
        }
        finally {
            tmp.delete();
        }
    }

    private List<String> parseGcps(String gcps, int[] gcpNum) {
        Matcher gcpMatcher = GCP_PATTERN.matcher(gcps);
        ArrayList<String> gcpCommand = new ArrayList<String>();
        int gcpPoints = 0;
        while (gcpMatcher.find()) {
            ArrayList<String> gcp = new ArrayList<String>();
            gcp.add("-gcp");
            String pixels = gcpMatcher.group(0);
            gcpMatcher.find();
            String lines = gcpMatcher.group(0);
            gcp.addAll(GeorectifyCoverage.splitToList(pixels.replace("[", "").replace("]", "").replace(",", "")));
            gcp.addAll(GeorectifyCoverage.splitToList(lines.replace("[", "").replace("]", "").replace(",", "")));
            gcpCommand.addAll(gcp);
            ++gcpPoints;
        }
        gcpNum[0] = gcpPoints;
        return gcpCommand;
    }

    private static void deleteFile(File file) {
        if (file != null && file.exists() && file.canRead()) {
            file.delete();
        }
    }

    public WPSResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(WPSResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    private static List<String> splitToList(String s) {
        return Splitter.onPattern((String)"\\s+").omitEmptyStrings().splitToList((CharSequence)s);
    }
}

