/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import org.geoserver.platform.ExtensionPriority;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wps.MemoryProcessStatusStore;
import org.geoserver.wps.ProcessEvent;
import org.geoserver.wps.ProcessListener;
import org.geoserver.wps.ProcessStatusStore;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.ProcessState;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.temporal.Before;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ProcessStatusTracker
implements ApplicationContextAware,
ProcessListener,
ExtensionPriority {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    static final Logger LOGGER = Logging.getLogger(ProcessStatusTracker.class);
    ProcessStatusStore store;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ProcessStatusStore store = (ProcessStatusStore)GeoServerExtensions.bean(ProcessStatusStore.class, (ApplicationContext)applicationContext);
        if (store == null) {
            store = new MemoryProcessStatusStore();
        }
        this.store = store;
    }

    @Override
    public void submitted(ProcessEvent event) throws WPSException {
        if (this.store == null) {
            return;
        }
        this.store.save(event.getStatus());
    }

    public void touch(String executionId) throws WPSException {
        ExecutionStatus status = this.store.get(executionId);
        if (status != null) {
            status.setLastUpdated(new Date());
            this.store.save(status);
        }
    }

    @Override
    public void succeeded(ProcessEvent event) throws WPSException {
        ExecutionStatus newStatus = event.getStatus();
        ExecutionStatus original = this.store.get(newStatus.getExecutionId());
        newStatus.setLastUpdated(new Date());
        this.store.save(newStatus);
        if (original.getPhase() == ProcessState.DISMISSING) {
            event.getStatus().setPhase(ProcessState.FAILED);
        }
    }

    @Override
    public void dismissing(ProcessEvent event) throws WPSException {
        ExecutionStatus status = event.getStatus();
        status.setLastUpdated(new Date());
        this.store.save(status);
    }

    @Override
    public void dismissed(ProcessEvent event) throws WPSException {
        ExecutionStatus status = event.getStatus();
        this.store.remove(status.getExecutionId());
    }

    @Override
    public void failed(ProcessEvent event) {
        ExecutionStatus status = event.getStatus();
        status.setLastUpdated(new Date());
        this.store.save(status);
    }

    @Override
    public void progress(ProcessEvent event) throws WPSException {
        ExecutionStatus original = this.store.get(event.getStatus().getExecutionId());
        if (original.getPhase() == ProcessState.DISMISSING) {
            event.getStatus().setPhase(ProcessState.DISMISSING);
        } else {
            ExecutionStatus newStatus = event.getStatus();
            newStatus.setLastUpdated(new Date());
            this.store.save(newStatus);
        }
    }

    public ExecutionStatus getStatus(String executionId) {
        return this.store.get(executionId);
    }

    public void cleanExpiredStatuses(long expirationThreshold) {
        Date date = new Date(expirationThreshold);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        Not completionTimenotNull = FF.not((Filter)FF.isNull((Expression)FF.property("completionTime")));
        Before completionTimeExpired = FF.before((Expression)FF.property("completionTime"), (Expression)FF.literal((Object)format.format(date)));
        And completionTimeFilter = FF.and((Filter)completionTimenotNull, (Filter)completionTimeExpired);
        Not lastUpdatedNotNull = FF.not((Filter)FF.isNull((Expression)FF.property("lastUpdated")));
        Before lastUpdatedExpired = FF.before((Expression)FF.property("lastUpdated"), (Expression)FF.literal((Object)format.format(date)));
        And lastUpdatedFilter = FF.and((Filter)lastUpdatedNotNull, (Filter)lastUpdatedExpired);
        And filter = FF.and((Filter)completionTimeFilter, (Filter)lastUpdatedFilter);
        this.store.remove((Filter)filter);
    }

    public ProcessStatusStore getStore() {
        return this.store;
    }

    public ExecutionStatus remove(String executionId) {
        return this.store.remove(executionId);
    }

    public int getPriority() {
        return 100;
    }
}

