/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.opengis.ows11.CodeType;
import net.opengis.wps10.DocumentOutputDefinitionType;
import net.opengis.wps10.ExecuteType;
import net.opengis.wps10.InputType;
import net.opengis.wps10.OutputDefinitionType;
import net.opengis.wps10.ResponseDocumentType;
import net.opengis.wps10.ResponseFormType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.ows.Ows11Util;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.AbstractInputProvider;
import org.geoserver.wps.executor.InputProvider;
import org.geoserver.wps.executor.LazyInputMap;
import org.geoserver.wps.executor.ListInputProvider;
import org.geoserver.wps.executor.StringInputProvider;
import org.geoserver.wps.executor.WPSExecutionManager;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geoserver.wps.process.AbstractRawData;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.data.ows.URLCheckerException;
import org.geotools.process.ProcessFactory;

public class ExecuteRequest {
    private final Name processName;
    private final ProcessFactory pf;
    private ExecuteType request;
    private LazyInputMap inputs;

    public ExecuteRequest(ExecuteType request) {
        this.request = request;
        this.processName = Ows11Util.name((CodeType)request.getIdentifier());
        this.pf = GeoServerProcessors.createProcessFactory(this.processName, true);
        if (this.pf == null) {
            throw new WPSException("Unknown process " + this.processName);
        }
    }

    public ExecuteType getRequest() {
        return this.request;
    }

    public boolean isAsynchronous() {
        return this.request.getResponseForm() != null && this.request.getResponseForm().getResponseDocument() != null && this.request.getResponseForm().getResponseDocument().isStoreExecuteResponse();
    }

    public boolean isStatusEnabled() {
        return this.isAsynchronous() && this.request.getResponseForm().getResponseDocument().isStatus();
    }

    public Name getProcessName() {
        return Ows11Util.name((CodeType)this.request.getIdentifier());
    }

    public LazyInputMap getProcessInputs(WPSExecutionManager manager) {
        if (this.inputs == null) {
            this.inputs = this.getInputsInternal(manager);
        }
        return this.inputs;
    }

    LazyInputMap getInputsInternal(WPSExecutionManager manager) {
        String mime;
        Map parameters = this.pf.getParameterInfo(this.processName);
        LinkedHashMap<String, InputProvider> providers = new LinkedHashMap<String, InputProvider>();
        Map<String, String> outputMimeParameters = AbstractRawData.getOutputMimeParameters(this.processName, this.pf);
        if (!outputMimeParameters.isEmpty()) {
            Map<String, String> requestedRawDataMimeTypes = this.getRequestedRawDataMimeTypes(outputMimeParameters.keySet(), this.processName, this.pf);
            for (Map.Entry<String, String> param : outputMimeParameters.entrySet()) {
                String outputName = param.getKey();
                String inputParameter = param.getValue();
                mime = requestedRawDataMimeTypes.get(outputName);
                StringInputProvider provider = new StringInputProvider(mime, inputParameter);
                providers.put(inputParameter, provider);
            }
        }
        for (Object o : this.request.getDataInputs().getInput()) {
            WPSException exception;
            InputType input = (InputType)o;
            String inputId = input.getIdentifier().getValue();
            Parameter p = (Parameter)parameters.get(inputId);
            if (p == null) {
                throw new WPSException("No such parameter: " + inputId);
            }
            mime = null;
            if (input.getData() != null && input.getData().getComplexData() != null) {
                mime = input.getData().getComplexData().getMimeType();
            } else if (input.getReference() != null) {
                mime = input.getReference().getMimeType();
            }
            ProcessParameterIO ppio = ProcessParameterIO.find(p, manager.applicationContext, mime);
            if (ppio == null) {
                throw new WPSException("Unable to decode input: " + inputId);
            }
            Collection validators = (Collection)p.metadata.get("wpsValidators");
            try {
                InputProvider provider = AbstractInputProvider.getInputProvider(input, ppio, manager, manager.applicationContext, validators);
                if (p.maxOccurs > 1) {
                    ListInputProvider lp = (ListInputProvider)providers.get(p.key);
                    if (lp == null) {
                        lp = new ListInputProvider(provider, p.getMaxOccurs());
                        providers.put(p.key, lp);
                        continue;
                    }
                    lp.add(provider);
                    continue;
                }
                providers.put(p.key, provider);
            }
            catch (URLCheckerException e) {
                exception = new WPSException("InvalidParameterValue", "Invalid input: " + inputId, e);
                exception.setLocator(inputId);
                throw exception;
            }
            catch (Exception e) {
                exception = new WPSException("Failed to parse process input: " + inputId, e);
                exception.setLocator(inputId);
                throw exception;
            }
        }
        return new LazyInputMap(providers);
    }

    private Map<String, String> getRequestedRawDataMimeTypes(Collection<String> rawResults, Name name, ProcessFactory pf) {
        HashMap<String, String> result = new HashMap<String, String>();
        ResponseFormType form = this.request.getResponseForm();
        OutputDefinitionType raw = form.getRawDataOutput();
        ResponseDocumentType document = form.getResponseDocument();
        if (form == null || raw == null && document == null) {
            for (String rawResult : rawResults) {
                String mime = AbstractRawData.getDefaultMime(name, pf, rawResult);
                result.put(rawResult, mime);
            }
        } else if (raw != null) {
            String output = raw.getIdentifier().getValue();
            String mime = raw.getMimeType() != null ? raw.getMimeType() : AbstractRawData.getDefaultMime(name, pf, output);
            result.put(output, mime);
        } else {
            for (Object o : document.getOutput()) {
                OutputDefinitionType out = (OutputDefinitionType)o;
                String outputName = out.getIdentifier().getValue();
                if (!rawResults.contains(outputName)) continue;
                String mime = out.getMimeType();
                if (mime == null || mime.trim().isEmpty()) {
                    mime = AbstractRawData.getDefaultMime(name, pf, outputName);
                }
                result.put(outputName, mime);
            }
        }
        return result;
    }

    public boolean isLineageRequested() {
        return this.request.getResponseForm() != null && this.request.getResponseForm().getResponseDocument() != null && this.request.getResponseForm().getResponseDocument().isLineage();
    }

    public List<OutputDefinitionType> getRequestedOutputs() {
        ResponseFormType responseForm = this.request.getResponseForm();
        if (responseForm == null) {
            return null;
        }
        if (responseForm.getRawDataOutput() != null) {
            return Collections.singletonList(responseForm.getRawDataOutput());
        }
        if (responseForm.getResponseDocument() != null && responseForm.getResponseDocument().getOutput() != null) {
            ArrayList<OutputDefinitionType> result = new ArrayList<OutputDefinitionType>();
            EList outputs = responseForm.getResponseDocument().getOutput();
            for (Object output : outputs) {
                result.add((OutputDefinitionType)((DocumentOutputDefinitionType)output));
            }
            return result;
        }
        return null;
    }

    public void validateOutputs(Map<String, Object> inputs) {
        Map resultInfo = this.pf.getResultInfo(this.getProcessName(), inputs);
        List<OutputDefinitionType> requestedOutputs = this.getRequestedOutputs();
        if (requestedOutputs != null) {
            for (OutputDefinitionType output : requestedOutputs) {
                String outputIdentifier = output.getIdentifier().getValue();
                if (resultInfo.containsKey(outputIdentifier)) continue;
                String locator = output instanceof DocumentOutputDefinitionType ? "ResponseDocument" : "RawDataOutput";
                throw new WPSException("Unknow output " + outputIdentifier, "InvalidParameterValue", locator);
            }
        }
    }
}

