/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.geoserver.wps.ProcessDismissedException;
import org.geotools.api.util.ProgressListener;

class CancellingOutputStream
extends FilterOutputStream {
    ProgressListener listener;

    public CancellingOutputStream(OutputStream out, ProgressListener listener) {
        super(out);
        this.listener = listener;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkCancelled();
        this.out.write(b);
    }

    private void checkCancelled() {
        if (this.listener.isCanceled()) {
            throw new ProcessDismissedException(this.listener);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkCancelled();
        this.out.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.checkCancelled();
        this.out.write(b);
    }
}

