/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.ClassAliasingMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.GeoServer;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.wps.ProcessGroupInfo;
import org.geoserver.wps.ProcessGroupInfoImpl;
import org.geoserver.wps.ProcessInfo;
import org.geoserver.wps.ProcessInfoImpl;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.WPSInfoImpl;
import org.geoserver.wps.validator.MaxSizeValidator;
import org.geoserver.wps.validator.MultiplicityValidator;
import org.geoserver.wps.validator.NumberRangeValidator;
import org.geoserver.wps.validator.WPSInputValidator;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.util.Converters;
import org.geotools.util.NumberRange;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;

public class WPSXStreamLoader
extends XStreamServiceLoader<WPSInfo> {
    static final Logger LOGGER = Logging.getLogger(WPSXStreamLoader.class);
    static final ProcessGroupInfo PROCESS_GROUP_ERROR = new ProcessGroupInfoImpl();

    public WPSXStreamLoader(GeoServerResourceLoader resourceLoader) {
        super(resourceLoader, "wps");
    }

    public Class<WPSInfo> getServiceClass() {
        return WPSInfo.class;
    }

    protected WPSInfo createServiceFromScratch(GeoServer gs) {
        WPSInfoImpl wps = new WPSInfoImpl();
        wps.setName("WPS");
        wps.setGeoServer(gs);
        wps.getVersions().add(new Version("1.0.0"));
        wps.setMaxAsynchronousProcesses(Runtime.getRuntime().availableProcessors() * 2);
        wps.setMaxSynchronousProcesses(Runtime.getRuntime().availableProcessors() * 2);
        return wps;
    }

    protected void initXStreamPersister(XStreamPersister xp, GeoServer gs) {
        super.initXStreamPersister(xp, gs);
        XStream xs = xp.getXStream();
        xs.registerConverter((Converter)new ProcessGroupConverter(xs.getMapper(), xs.getReflectionProvider()));
        xs.alias("wps", WPSInfo.class, WPSInfoImpl.class);
        xs.alias("processGroup", ProcessGroupInfoImpl.class);
        xs.alias("name", NameImpl.class);
        xs.alias("name", Name.class, NameImpl.class);
        xs.alias("accessInfo", ProcessInfoImpl.class);
        xs.registerConverter((SingleValueConverter)new NameConverter());
        ClassAliasingMapper mapper = new ClassAliasingMapper(xs.getMapper());
        mapper.addClassAlias("role", String.class);
        xs.registerLocalConverter(ProcessGroupInfoImpl.class, "roles", (Converter)new CollectionConverter((Mapper)mapper));
        xs.registerLocalConverter(ProcessInfoImpl.class, "roles", (Converter)new CollectionConverter((Mapper)mapper));
        xs.registerLocalConverter(ProcessInfoImpl.class, "validators", (Converter)new XStreamPersister.MultimapConverter((Mapper)mapper));
        xs.registerLocalConverter(WPSInfoImpl.class, "processGroups", (Converter)new WPSCollectionConverter((Mapper)mapper));
        xs.alias("maxSizeValidator", MaxSizeValidator.class);
        xs.alias("maxMultiplicityValidator", MultiplicityValidator.class);
        xs.alias("rangeValidator", NumberRangeValidator.class);
        xs.registerLocalConverter(NumberRangeValidator.class, "range", (Converter)new NumberRangeConverter(xs.getMapper(), xs.getReflectionProvider()));
        xs.allowTypeHierarchy(ProcessGroupInfo.class);
        xs.allowTypeHierarchy(WPSInputValidator.class);
    }

    protected WPSInfo initialize(WPSInfo service) {
        if (service.getKeywords() == null) {
            ((WPSInfoImpl)service).setKeywords(new ArrayList());
        }
        if (service.getExceptionFormats() == null) {
            ((WPSInfoImpl)service).setExceptionFormats(new ArrayList());
        }
        if (service.getMetadata() == null) {
            ((WPSInfoImpl)service).setMetadata(new MetadataMap());
        }
        if (service.getClientProperties() == null) {
            ((WPSInfoImpl)service).setClientProperties(new HashMap());
        }
        if (service.getVersions() == null) {
            ((WPSInfoImpl)service).setVersions(new ArrayList());
        }
        if (service.getVersions().isEmpty()) {
            service.getVersions().add(new Version("1.0.0"));
        }
        if (service.getConnectionTimeout() == 0.0) {
            service.setConnectionTimeout(WPSInfoImpl.DEFAULT_CONNECTION_TIMEOUT);
        }
        if (service.getProcessGroups() == null) {
            ((WPSInfoImpl)service).setProcessGroups(new ArrayList<ProcessGroupInfo>());
        } else {
            for (ProcessGroupInfo pg : service.getProcessGroups()) {
                if (pg.getRoles() == null) {
                    pg.setRoles(new ArrayList<String>());
                }
                if (pg.getMetadata() == null) {
                    ((ProcessGroupInfoImpl)pg).setMetadata(new MetadataMap());
                }
                if (pg.getFilteredProcesses() == null) {
                    ((ProcessGroupInfoImpl)pg).setFilteredProcesses(new ArrayList<ProcessInfo>());
                    continue;
                }
                for (ProcessInfo pi : pg.getFilteredProcesses()) {
                    if (pi.getRoles() == null) {
                        ((ProcessInfoImpl)pi).setRoles(new ArrayList<String>());
                    }
                    if (pi.getValidators() == null) {
                        ArrayListMultimap validators = ArrayListMultimap.create();
                        ((ProcessInfoImpl)pi).setValidators((Multimap<String, WPSInputValidator>)validators);
                    }
                    if (pi.getMetadata() != null) continue;
                    ((ProcessInfoImpl)pi).setMetadata(new MetadataMap());
                }
            }
        }
        if (service.getName() == null) {
            service.setName(service.getType());
        }
        return service;
    }

    public static class WPSCollectionConverter
    extends CollectionConverter {
        public WPSCollectionConverter(Mapper mapper) {
            super(mapper);
        }

        public WPSCollectionConverter(Mapper mapper, Class<?> type) {
            super(mapper, type);
        }

        protected void addCurrentElementToCollection(HierarchicalStreamReader reader, UnmarshallingContext context, Collection collection, Collection target) {
            Object item = this.readBareItem(reader, context, collection);
            if (!PROCESS_GROUP_ERROR.equals(item)) {
                target.add(item);
            }
        }
    }

    public static class NumberRangeConverter
    extends ReflectionConverter {
        public NumberRangeConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
            super(mapper, reflectionProvider);
        }

        public boolean canConvert(Class type) {
            return NumberRange.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            NumberRange range = (NumberRange)source;
            writer.startNode("minValue");
            writer.setValue(String.valueOf(range.getMinValue()));
            writer.endNode();
            writer.startNode("maxValue");
            writer.setValue(String.valueOf(range.getMaxValue()));
            writer.endNode();
            if (!range.isMinIncluded()) {
                writer.startNode("isMinIncluded");
                writer.setValue("false");
                writer.endNode();
            }
            if (!range.isMaxIncluded()) {
                writer.startNode("isMaxIncluded");
                writer.setValue("false");
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            reader.moveDown();
            double min = (Double)Converters.convert((Object)reader.getValue(), Double.class);
            reader.moveUp();
            reader.moveDown();
            double max = (Double)Converters.convert((Object)reader.getValue(), Double.class);
            reader.moveUp();
            NumberRange range = new NumberRange(Double.class, (Number)min, (Number)max);
            return range;
        }
    }

    public static class ProcessGroupConverter
    extends ReflectionConverter {
        public ProcessGroupConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
            super(mapper, reflectionProvider);
        }

        public boolean canConvert(Class clazz) {
            return ProcessGroupInfoImpl.class == clazz;
        }

        public Object doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
            try {
                ProcessGroupInfo converted = (ProcessGroupInfo)super.doUnmarshal(result, reader, context);
                if (converted.getFilteredProcesses() != null) {
                    ArrayList<ProcessInfoImpl> newFilteredProcesses = new ArrayList<ProcessInfoImpl>();
                    for (ProcessInfo fp : converted.getFilteredProcesses()) {
                        if (!(fp instanceof NameImpl)) break;
                        NameImpl ni = (NameImpl)fp;
                        ProcessInfoImpl pi = new ProcessInfoImpl();
                        pi.setName((Name)ni);
                        pi.setEnabled(false);
                        newFilteredProcesses.add(pi);
                    }
                    if (!newFilteredProcesses.isEmpty()) {
                        converted.getFilteredProcesses().clear();
                        converted.getFilteredProcesses().addAll(newFilteredProcesses);
                    }
                }
                return converted;
            }
            catch (ConversionException e) {
                LOGGER.log(Level.WARNING, "Error unmarshaling WPS Process Group", e);
                List<String> expectedHierarchy = Arrays.asList("wps", "processGroups", "processGroup");
                while (!expectedHierarchy.contains(reader.getNodeName())) {
                    reader.moveUp();
                }
                return PROCESS_GROUP_ERROR;
            }
        }
    }

    public static class NameConverter
    extends AbstractSingleValueConverter {
        public boolean canConvert(Class type) {
            return Name.class.isAssignableFrom(type);
        }

        public String toString(Object obj) {
            Name name = (Name)obj;
            return name.getNamespaceURI() + ":" + name.getLocalPart();
        }

        public Object fromString(String str) {
            int idx = str.indexOf(":");
            if (idx == -1) {
                return new NameImpl(str);
            }
            String prefix = str.substring(0, idx);
            String local = str.substring(idx + 1);
            return new NameImpl(prefix, local);
        }
    }
}

