/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Function;
import org.apache.commons.codec.binary.Base64;
import org.geoserver.util.IOUtils;
import org.geoserver.wps.JSONEncoderDelegate;
import org.geoserver.wps.process.RawData;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.xsd.EncoderDelegate;
import org.xml.sax.ContentHandler;

public class RawDataEncoderDelegate
implements EncoderDelegate,
JSONEncoderDelegate {
    private static final Function<byte[], String> BASE_64_ENCODER = buffer -> new String(Base64.encodeBase64((byte[])buffer));
    private static final Function<byte[], String> IDENTITY = buffer -> new String((byte[])buffer);
    private RawData rawData;

    public RawDataEncoderDelegate(RawData rawData) {
        this.rawData = rawData;
    }

    public RawData getRawData() {
        return this.rawData;
    }

    public void encode(ContentHandler output) throws Exception {
        this.writeEncoded(chars -> output.characters(chars, 0, chars.length), BASE_64_ENCODER);
    }

    public void encode(OutputStream os) throws IOException {
        try (InputStream stream = this.rawData.getInputStream();){
            IOUtils.copy((InputStream)stream, (OutputStream)os, (int)WPSResourceManager.getCopyBufferSize());
        }
    }

    @Override
    public void encode(JsonGenerator generator) throws Exception {
        generator.writeRaw("\"");
        Function<byte[], String> encoder = BASE_64_ENCODER;
        if (this.rawData.getMimeType().equals("text/plain")) {
            encoder = IDENTITY;
        }
        this.writeEncoded(chars -> generator.writeRaw(chars, 0, chars.length), encoder);
        generator.writeRaw("\"");
    }

    private void writeEncoded(Writer writer, Function<byte[], String> encoder) throws Exception {
        try (InputStream is = this.rawData.getInputStream();){
            byte[] buffer = new byte[4096];
            int read = 0;
            while ((read = is.read(buffer)) > 0) {
                String encoded;
                if (read == 4096) {
                    encoded = encoder.apply(buffer);
                } else {
                    byte[] reducedBuffer = new byte[read];
                    System.arraycopy(buffer, 0, reducedBuffer, 0, read);
                    encoded = encoder.apply(reducedBuffer);
                }
                char[] chars = encoded.toCharArray();
                writer.accept(chars);
            }
        }
    }

    private static interface Writer {
        public void accept(char[] var1) throws Exception;
    }
}

