/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import org.geoserver.platform.resource.Resource;
import org.geoserver.wps.GetExecutionStatusType;
import org.geoserver.wps.StatusResponseBuilder;
import org.geoserver.wps.UnknownExecutionIdException;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.ProcessState;
import org.geoserver.wps.executor.ProcessStatusTracker;
import org.geoserver.wps.resource.WPSResourceManager;
import org.springframework.context.ApplicationContext;

public class GetStatus {
    private WPSResourceManager resources;
    private ProcessStatusTracker tracker;
    private ApplicationContext ctx;

    public GetStatus(ProcessStatusTracker tracker, WPSResourceManager resources, ApplicationContext ctx) {
        this.tracker = tracker;
        this.resources = resources;
        this.ctx = ctx;
    }

    public Object run(GetExecutionStatusType request) throws WPSException {
        String executionId = request.getExecutionId();
        ExecutionStatus status = this.tracker.getStatus(executionId);
        if (status == null) {
            throw new UnknownExecutionIdException(executionId);
        }
        if (status.getPhase().isExecutionCompleted()) {
            Resource storedResponse = this.resources.getStoredResponse(executionId);
            if (storedResponse == null || storedResponse.getType() == Resource.Type.UNDEFINED) {
                throw new WPSException("The execution is completed with status " + status.getPhase() + " and yet the response cannot be located on disk, this is an internal failure");
            }
            return storedResponse;
        }
        if (status.getPhase() == ProcessState.DISMISSING) {
            throw new UnknownExecutionIdException(executionId);
        }
        return new StatusResponseBuilder(this.resources, this.ctx).buildStatusResponse(status);
    }
}

