/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.schemas.Stub;

public class GetSchema {
    public WPSInfo wps;

    public GetSchema(WPSInfo wps) {
        this.wps = wps;
    }

    public void run(HttpServletRequest request, HttpServletResponse response) {
        String name = null;
        Enumeration a = request.getParameterNames();
        while (a.hasMoreElements()) {
            String i = (String)a.nextElement();
            if (!"identifier".equalsIgnoreCase(i)) continue;
            name = request.getParameter(i);
            break;
        }
        if (null == name) {
            throw new WPSException("NoApplicableCode", "No Identifier key and value.");
        }
        try (InputStream stream = Stub.class.getResourceAsStream(name);){
            if (null == stream) {
                throw new WPSException("NoApplicableCode", "No Schema '" + name + "'.");
            }
            try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(stream));){
                StringBuilder schema = new StringBuilder();
                String line = null;
                while (null != (line = bufReader.readLine())) {
                    schema.append(line + "\n");
                }
                response.setContentType("text/xml");
                response.getOutputStream().print(schema.toString());
            }
        }
        catch (IOException e) {
            throw new WPSException("NoApplicableCode", "Error producing schema", e);
        }
    }
}

