/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.XMLGregorianCalendar;
import net.opengis.ows11.ExceptionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import net.opengis.wps10.DataType;
import net.opengis.wps10.DocumentOutputDefinitionType;
import net.opengis.wps10.ExecuteResponseType;
import net.opengis.wps10.ExecuteType;
import net.opengis.wps10.InputReferenceType;
import net.opengis.wps10.InputType;
import net.opengis.wps10.OutputDefinitionType;
import net.opengis.wps10.ResponseDocumentType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wps.GetExecutionsType;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.executor.ExecuteResponseBuilder;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.ProcessState;
import org.geoserver.wps.ppio.ComplexPPIO;
import org.geoserver.wps.ppio.FilterPPIO;
import org.geoserver.wps.ppio.LiteralPPIO;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.process.ProcessFactory;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.springframework.context.ApplicationContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class GetExecutionsTransformer
extends TransformerBase {
    static final Logger LOGGER = Logging.getLogger(GetExecutionsTransformer.class);
    private List<ExecutionStatus> executions = new ArrayList<ExecutionStatus>();
    WPSInfo wps;
    private WPSResourceManager resources;
    private ApplicationContext ctx;
    private GetExecutionsType request;
    private Integer total;
    private Integer startIndex;
    private Integer maxFeatures;

    public GetExecutionsTransformer(WPSInfo wps, WPSResourceManager resources, ApplicationContext ctx, GetExecutionsType request, Integer total, Integer startIndex, Integer maxFeatures) {
        this.wps = wps;
        this.resources = resources;
        this.ctx = ctx;
        this.request = request;
        this.total = total;
        this.startIndex = startIndex;
        this.maxFeatures = maxFeatures;
    }

    public void append(ExecutionStatus status) {
        this.executions.add(status);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new GMLTranslator(handler);
    }

    public List<ExecutionStatus> getExecutions() {
        return this.executions;
    }

    class GMLTranslator
    extends TransformerBase.TranslatorSupport {
        public GMLTranslator(ContentHandler contentHandler) {
            super(contentHandler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            NamespaceSupport namespaces = this.getNamespaceSupport();
            this.declarePrefixes(namespaces);
            AttributesImpl attributes = new AttributesImpl();
            this.registerNamespaces(this.getNamespaceSupport(), attributes);
            String proxyBaseUrl = GetExecutionsTransformer.this.wps.getGeoServer().getGlobal().getSettings().getProxyBaseUrl();
            String baseUrl = proxyBaseUrl != null ? proxyBaseUrl : "/";
            String serviceInstance = ResponseUtils.appendQueryString((String)ResponseUtils.buildURL((String)baseUrl, (String)"ows", null, (URLMangler.URLType)URLMangler.URLType.SERVICE), (String)"");
            attributes.addAttribute("", "xml:lang", "xml:lang", "", "en");
            attributes.addAttribute("", "xsi:schemaLocation", "xsi:schemaLocation", "", "http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsAll.xsd");
            attributes.addAttribute("", "service", "service", "", GetExecutionsTransformer.this.wps.getName());
            attributes.addAttribute("", "version", "version", "", "1.0.0");
            attributes.addAttribute("", "serviceInstance", "serviceInstance", "", serviceInstance);
            AttributesImpl getExecutionsAttributes = new AttributesImpl(attributes);
            getExecutionsAttributes.addAttribute("", "count", "count", "", String.valueOf(GetExecutionsTransformer.this.total));
            this.getPaginationAttributes(serviceInstance, getExecutionsAttributes);
            this.start("wps:GetExecutionsResponse", getExecutionsAttributes);
            for (ExecutionStatus status : GetExecutionsTransformer.this.executions) {
                ExecuteType execute = status.getRequest();
                this.encodeExecute(attributes, status, execute);
            }
            this.end("wps:GetExecutionsResponse");
        }

        private void encodeExecute(AttributesImpl attributes, ExecutionStatus status, ExecuteType execute) {
            try {
                if (execute == null) {
                    execute = GetExecutionsTransformer.this.resources.getStoredRequestObject(status.getExecutionId());
                }
                if (execute == null) {
                    throw new WPSException("Could not locate the original request for execution id: " + status.getExecutionId());
                }
                ExecuteResponseBuilder builder = new ExecuteResponseBuilder(execute, GetExecutionsTransformer.this.ctx, status);
                ExecuteResponseType responseType = builder.build();
                this.start("wps:ExecuteResponse");
                AttributesImpl processAttributes = new AttributesImpl();
                this.addAttribute(processAttributes, "wps:processVersion", responseType.getProcess().getProcessVersion());
                this.start("wps:Process", processAttributes);
                this.element("ows:Identifier", responseType.getProcess().getIdentifier().getValue());
                this.element("ows:Title", responseType.getProcess().getTitle().getValue());
                this.element("ows:Abstract", responseType.getProcess().getAbstract().getValue());
                this.end("wps:Process");
                AttributesImpl statusAttributes = new AttributesImpl();
                if (status.getCreationTime() != null) {
                    this.addAttribute(statusAttributes, "creationTime", responseType.getStatus().getCreationTime().toString());
                }
                if (status.getCompletionTime() != null) {
                    this.addAttribute(statusAttributes, "completionTime", this.getISOTme(status.getCompletionTime()));
                }
                if (status.getLastUpdated() != null) {
                    this.addAttribute(statusAttributes, "lastUpdated", this.getISOTme(status.getLastUpdated()));
                }
                this.start("wps:Status", statusAttributes);
                this.element("wps:JobID", status.getExecutionId());
                this.element("wps:Identifier", responseType.getProcess().getIdentifier().getValue());
                this.element("wps:Owner", status.getUserName());
                this.element("wps:Status", status.getPhase().name());
                if (status.getEstimatedCompletion() != null) {
                    this.element("wps:EstimatedCompletion", this.getISOTme(status.getEstimatedCompletion()));
                }
                this.element("wps:ExpirationDate", this.getISOTme(status.getExpirationDate()));
                this.element("wps:NextPoll", this.getISOTme(status.getNextPoll()));
                this.element("wps:PercentCompleted", String.valueOf(status.getProgress()));
                if (status.getException() != null) {
                    StringBuffer stackTrace = new StringBuffer();
                    EList exceptions = responseType.getStatus().getProcessFailed().getExceptionReport().getException();
                    for (Object ex : exceptions) {
                        if (!(ex instanceof ExceptionType)) continue;
                        stackTrace.append(((ExceptionType)ex).getExceptionCode());
                        stackTrace.append(": ");
                        stackTrace.append(((ExceptionType)ex).getExceptionText());
                        stackTrace.append("\n");
                    }
                    this.element("wps:ProcessFailed", stackTrace.toString());
                } else if (status.getPhase() == ProcessState.QUEUED) {
                    this.element("wps:ProcessAccepted", responseType.getStatus().getProcessAccepted());
                } else if (status.getPhase() == ProcessState.RUNNING) {
                    this.element("wps:ProcessStarted", responseType.getStatus().getProcessStarted().getValue());
                } else {
                    this.element("wps:ProcessSucceeded", responseType.getStatus().getProcessSucceeded());
                }
                if (responseType.getStatusLocation() != null) {
                    this.element("wps:StatusLocation", responseType.getStatusLocation());
                }
                if (responseType.getDataInputs() != null && !responseType.getDataInputs().getInput().isEmpty()) {
                    EList inputs = responseType.getDataInputs().getInput();
                    this.encodeDataInputs(status, inputs, attributes);
                }
                if (responseType.getOutputDefinitions() != null && !responseType.getOutputDefinitions().getOutput().isEmpty()) {
                    EList outputs = responseType.getOutputDefinitions().getOutput();
                    this.encodeDataOutputs(status, outputs, attributes);
                }
                this.end("wps:Status");
                this.end("wps:ExecuteResponse");
            }
            catch (IOException e) {
                throw new WPSException("InternalServerError", e);
            }
        }

        private void addAttribute(AttributesImpl atts, String name, String value) {
            atts.addAttribute("", name, name, "", value);
        }

        private String getISOTme(Date completionTime) {
            return ((XMLGregorianCalendar)Converters.convert((Object)completionTime, XMLGregorianCalendar.class)).toString();
        }

        private void declarePrefixes(NamespaceSupport namespaces) {
            namespaces.declarePrefix("wps", "http://www.opengis.net/wps/1.0.0");
            namespaces.declarePrefix("wfs", "http://www.opengis.net/wfs");
            namespaces.declarePrefix("wcs", "http://www.opengis.net/wcs/1.1.1");
            namespaces.declarePrefix("ogc", "http://www.opengis.net/ogc");
            namespaces.declarePrefix("ows", "http://www.opengis.net/ows/1.1");
            namespaces.declarePrefix("gml", "http://www.opengis.net/gml/3.2");
            namespaces.declarePrefix("xs", "http://www.w3.org/2001/XMLSchema");
            namespaces.declarePrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            namespaces.declarePrefix("xlink", "http://www.w3.org/1999/xlink");
        }

        protected void encodeExecuteRequest(ExecutionStatus status, ExecuteType exec, AttributesImpl attributes) {
            AttributesImpl executeTypeAttributes = new AttributesImpl(attributes);
            this.start("wps:Execute", executeTypeAttributes);
            this.element("ows:Identifier", exec.getIdentifier().getValue());
            this.encodeDataInputs(status, exec.getDataInputs().getInput(), executeTypeAttributes);
            this.start("wps:ResponseForm");
            if (exec.getResponseForm() != null) {
                if (exec.getResponseForm().getRawDataOutput() != null) {
                    OutputDefinitionType rawDataOutput = exec.getResponseForm().getRawDataOutput();
                    AttributesImpl rawDataOutputAttributes = new AttributesImpl();
                    if (rawDataOutput.getMimeType() != null) {
                        rawDataOutputAttributes.addAttribute("", "mimeType", "mimeType", "", rawDataOutput.getMimeType());
                    }
                    if (rawDataOutput.getEncoding() != null) {
                        rawDataOutputAttributes.addAttribute("", "encoding", "encoding", "", rawDataOutput.getEncoding());
                    }
                    if (rawDataOutput.getSchema() != null) {
                        rawDataOutputAttributes.addAttribute("", "schema", "schema", "", rawDataOutput.getSchema());
                    }
                    if (rawDataOutput.getUom() != null) {
                        rawDataOutputAttributes.addAttribute("", "uom", "uom", "", rawDataOutput.getUom());
                    }
                    this.start("wps:RawDataOutput", rawDataOutputAttributes);
                    this.element("ows:Identifier", rawDataOutput.getIdentifier().getValue());
                    this.end("wps:RawDataOutput");
                }
                if (exec.getResponseForm().getResponseDocument() != null) {
                    ResponseDocumentType responseDocument = exec.getResponseForm().getResponseDocument();
                    AttributesImpl responseDocumentAttributes = new AttributesImpl();
                    responseDocumentAttributes.addAttribute("", "status", "status", "", String.valueOf(responseDocument.isSetStatus()));
                    responseDocumentAttributes.addAttribute("", "storeExecuteResponse", "storeExecuteResponse", "", String.valueOf(responseDocument.isSetStoreExecuteResponse()));
                    responseDocumentAttributes.addAttribute("", "lineage", "lineage", "", String.valueOf(responseDocument.isSetLineage()));
                    this.start("wps:ResponseDocument", responseDocumentAttributes);
                    this.end("wps:ResponseDocument");
                }
            }
            this.end("wps:ResponseForm");
            this.end("wps:Execute");
        }

        protected void encodeDataInputs(ExecutionStatus status, EList inputs, AttributesImpl attributes) {
            this.start("wps:DataInputs");
            for (Object input : inputs) {
                DataType data;
                InputReferenceType reference;
                if (!(input instanceof InputType)) continue;
                InputType ii = (InputType)input;
                this.start("wps:Input");
                if (ii.getIdentifier() != null) {
                    this.element("ows:Identifier", ii.getIdentifier().getValue());
                }
                if (ii.getTitle() != null) {
                    this.element("ows:Title", ii.getTitle().getValue());
                }
                if (ii.getAbstract() != null) {
                    this.element("ows:Abstract", ii.getAbstract().getValue());
                }
                if ((reference = ii.getReference()) != null) {
                    this.encodeReference(status, attributes, ii, reference);
                }
                if ((data = ii.getData()) != null) {
                    AttributesImpl inputAttributes = new AttributesImpl();
                    if (data.getComplexData() != null) {
                        this.start("wps:Data");
                        for (Object complexData : data.getComplexData().getData()) {
                            if (data.getComplexData().getMimeType() != null) {
                                inputAttributes.addAttribute("", "mimeType", "mimeType", "", data.getComplexData().getMimeType());
                            }
                            Name processName = status.getProcessName();
                            ProcessFactory pf = GeoServerProcessors.createProcessFactory(processName, true);
                            Map parameters = pf.getParameterInfo(processName);
                            String inputId = ii.getIdentifier().getValue();
                            List<ProcessParameterIO> ppio = ProcessParameterIO.findEncoder((Parameter)parameters.get(inputId), GetExecutionsTransformer.this.ctx);
                            ProcessParameterIO processParameterIO = ppio.get(0);
                            if (ppio != null && !ppio.isEmpty()) {
                                if (!ProcessParameterIO.isComplex((Parameter)parameters.get(inputId), GetExecutionsTransformer.this.ctx)) continue;
                                this.element("wps:ComplexData", "<![CDATA[" + complexData.toString() + "]]", inputAttributes);
                                continue;
                            }
                            if (!(processParameterIO instanceof LiteralPPIO)) continue;
                            try {
                                this.element("wps:LiteralData", ((LiteralPPIO)processParameterIO).encode(complexData), inputAttributes);
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.WARNING, "", e);
                            }
                        }
                        this.end("wps:Data");
                    }
                    if (data.getLiteralData() != null) {
                        if (data.getLiteralData().getDataType() != null) {
                            inputAttributes.addAttribute("", "dataType", "dataType", "", data.getLiteralData().getDataType());
                        }
                        if (data.getLiteralData().getUom() != null) {
                            inputAttributes.addAttribute("", "uom", "uom", "", data.getLiteralData().getUom());
                        }
                        this.start("wps:Data", inputAttributes);
                        this.element("wps:LiteralData", data.getLiteralData().getValue());
                        this.end("wps:Data");
                    }
                    if (data.getBoundingBoxData() != null) {
                        if (data.getBoundingBoxData().getDimensions() != null) {
                            this.addAttribute(inputAttributes, "dimensions", data.getBoundingBoxData().getDimensions().toString());
                        }
                        if (data.getBoundingBoxData().getCrs() != null) {
                            inputAttributes.addAttribute("", "crs", "crs", "", data.getBoundingBoxData().getCrs());
                        }
                        this.start("wps:BoundingBoxData", inputAttributes);
                        if (data.getBoundingBoxData().getLowerCorner() != null) {
                            StringBuffer lowerCorner = new StringBuffer();
                            for (Object coord : data.getBoundingBoxData().getLowerCorner()) {
                                lowerCorner.append(coord).append(" ");
                            }
                            this.element("ows:LowerCorner", lowerCorner.toString().trim());
                        }
                        if (data.getBoundingBoxData().getUpperCorner() != null) {
                            StringBuffer upperCorner = new StringBuffer();
                            for (Object coord : data.getBoundingBoxData().getUpperCorner()) {
                                upperCorner.append(coord).append(" ");
                            }
                            this.element("ows:UpperCorner", upperCorner.toString().trim());
                        }
                        this.end("wps:BoundingBoxData");
                    }
                }
                this.end("wps:Input");
            }
            this.end("wps:DataInputs");
        }

        private void encodeReference(ExecutionStatus status, AttributesImpl attributes, InputType ii, InputReferenceType reference) {
            AttributesImpl inputAttributes = new AttributesImpl();
            if (reference.getHref() != null) {
                inputAttributes.addAttribute("", "xlink:href", "xlink:href", "", reference.getHref());
            }
            if (reference.getMimeType() != null) {
                inputAttributes.addAttribute("", "mimeType", "mimeType", "", reference.getMimeType());
            }
            if (reference.getSchema() != null) {
                inputAttributes.addAttribute("", "schema", "schema", "", reference.getSchema());
            }
            if (reference.getEncoding() != null) {
                inputAttributes.addAttribute("", "encoding", "encoding", "", reference.getSchema());
            }
            if (reference.getMethod() != null) {
                inputAttributes.addAttribute("", "method", "method", "", reference.getMethod().getName());
            }
            this.start("wps:Reference", inputAttributes);
            if (reference.getBody() != null) {
                this.start("wps:Body");
                Name processName = status.getProcessName();
                ProcessFactory pf = GeoServerProcessors.createProcessFactory(processName, true);
                Map parameters = pf.getParameterInfo(processName);
                String inputId = ii.getIdentifier().getValue();
                List<ProcessParameterIO> ppios = ProcessParameterIO.findDecoder((Parameter)parameters.get(inputId), GetExecutionsTransformer.this.ctx);
                if (ppios != null && !ppios.isEmpty()) {
                    for (ProcessParameterIO ppio : ppios) {
                        if (ProcessParameterIO.isComplex((Parameter)parameters.get(inputId), GetExecutionsTransformer.this.ctx)) {
                            this.encodeComplexInput(status, attributes, reference, inputAttributes, (ComplexPPIO)ppio);
                            continue;
                        }
                        if (!(ppio instanceof LiteralPPIO)) continue;
                        try {
                            this.element("wps:LiteralData", ((LiteralPPIO)ppio).encode(reference.getBody()));
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "", e);
                        }
                    }
                }
                this.end("wps:Body");
            }
            if (reference.getBodyReference() != null) {
                this.element("wps:BodyReference", ii.getReference().getBodyReference().getHref());
            }
            this.end("wps:Reference");
        }

        private void encodeComplexInput(ExecutionStatus status, AttributesImpl attributes, InputReferenceType reference, AttributesImpl inputAttributes, ComplexPPIO ppio) {
            try {
                Object out = ppio.decode(reference.getBody());
                if (out instanceof ExecuteType) {
                    ExecuteType exec = (ExecuteType)out;
                    this.start("wps:ComplexData", inputAttributes);
                    this.encodeExecuteRequest(status, exec, attributes);
                    this.end("wps:ComplexData");
                } else if (out instanceof GetFeatureType) {
                    this.encodeGetFeatureType(inputAttributes, (GetFeatureType)out);
                } else {
                    this.element("wps:ComplexData", "<![CDATA[" + out.toString() + "]]", inputAttributes);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "", e);
            }
        }

        private void encodeGetFeatureType(AttributesImpl inputAttributes, GetFeatureType out) throws Exception {
            GetFeatureType features = out;
            AttributesImpl atts = new AttributesImpl(inputAttributes);
            if (features.getService() != null) {
                this.addAttribute(atts, "service", features.getService());
            }
            if (features.getVersion() != null) {
                this.addAttribute(atts, "version", features.getVersion());
            }
            if (features.getBaseUrl() != null) {
                this.addAttribute(atts, "baseUrl", features.getBaseUrl());
            }
            if (features.getOutputFormat() != null) {
                this.addAttribute(atts, "outputFormat", features.getOutputFormat());
            }
            if (features.getMaxFeatures() != null) {
                this.addAttribute(atts, "maxFeatures", String.valueOf(features.getMaxFeatures()));
            }
            this.start("wfs:GetFeature", atts);
            EList queries = features.getQuery();
            if (queries != null && !queries.isEmpty()) {
                for (Object query : queries) {
                    QueryType qt = (QueryType)query;
                    this.encodeQuery(inputAttributes, qt);
                }
            }
            this.end("wfs:GetFeature");
        }

        private void encodeQuery(AttributesImpl inputAttributes, QueryType qt) throws Exception {
            AttributesImpl atts = new AttributesImpl(inputAttributes);
            if (qt.getTypeName() != null && !qt.getTypeName().isEmpty()) {
                this.addAttribute(atts, "typeName", qt.getTypeName().get(0).toString());
            }
            this.start("wfs:Query", atts);
            Filter filter = qt.getFilter();
            if (filter != null) {
                FilterPPIO.Filter11 fppio = new FilterPPIO.Filter11();
                fppio.encode((Object)filter, this.contentHandler);
            }
            this.end("wfs:Query");
        }

        protected void encodeDataOutputs(ExecutionStatus status, EList outputs, AttributesImpl attributes) {
            this.start("wps:DataOutputs");
            for (Object output : outputs) {
                if (!(output instanceof DocumentOutputDefinitionType)) continue;
                DocumentOutputDefinitionType oo = (DocumentOutputDefinitionType)output;
                AttributesImpl outputDefinitionTypeAttributes = new AttributesImpl();
                outputDefinitionTypeAttributes.addAttribute("", "asReference", "asReference", "", String.valueOf(oo.isSetAsReference()));
                if (oo.getMimeType() != null) {
                    outputDefinitionTypeAttributes.addAttribute("", "mimeType", "mimeType", "", oo.getMimeType());
                }
                if (oo.getEncoding() != null) {
                    outputDefinitionTypeAttributes.addAttribute("", "encoding", "encoding", "", oo.getEncoding());
                }
                if (oo.getSchema() != null) {
                    outputDefinitionTypeAttributes.addAttribute("", "schema", "schema", "", oo.getSchema());
                }
                if (oo.getUom() != null) {
                    outputDefinitionTypeAttributes.addAttribute("", "uom", "uom", "", oo.getUom());
                }
                this.start("wps:Output", outputDefinitionTypeAttributes);
                if (oo.getIdentifier() != null) {
                    this.element("ows:Identifier", oo.getIdentifier().getValue());
                }
                if (oo.getTitle() != null) {
                    this.element("ows:Title", oo.getTitle().getValue());
                }
                if (oo.getAbstract() != null) {
                    this.element("ows:Abstract", oo.getAbstract().getValue());
                }
                this.end("wps:Output");
            }
            this.end("wps:DataOutputs");
        }

        protected void getPaginationAttributes(String serviceInstance, AttributesImpl attributes) {
            String baseRequestUrl = serviceInstance + "service=" + GetExecutionsTransformer.this.request.service + "&version=" + GetExecutionsTransformer.this.request.version + "&request=GetExecutions&";
            if (GetExecutionsTransformer.this.request.identifier != null) {
                baseRequestUrl = baseRequestUrl + "identifier=" + GetExecutionsTransformer.this.request.identifier;
            }
            if (GetExecutionsTransformer.this.request.owner != null) {
                baseRequestUrl = baseRequestUrl + "owner=" + GetExecutionsTransformer.this.request.owner;
            }
            if (GetExecutionsTransformer.this.request.status != null) {
                baseRequestUrl = baseRequestUrl + "status=" + GetExecutionsTransformer.this.request.status;
            }
            if (GetExecutionsTransformer.this.request.orderBy != null) {
                baseRequestUrl = baseRequestUrl + "orderBy=" + GetExecutionsTransformer.this.request.orderBy;
            }
            if (GetExecutionsTransformer.this.request.maxFeatures != null) {
                baseRequestUrl = baseRequestUrl + "maxFeatures=" + GetExecutionsTransformer.this.request.maxFeatures;
            }
            if (GetExecutionsTransformer.this.maxFeatures != null && GetExecutionsTransformer.this.maxFeatures > 0) {
                int index;
                int n = index = GetExecutionsTransformer.this.startIndex != null ? GetExecutionsTransformer.this.startIndex : 0;
                if (index > 0) {
                    attributes.addAttribute("", "previous", "previous", "", baseRequestUrl + "&startIndex=" + (index - Math.min(GetExecutionsTransformer.this.maxFeatures, index)));
                }
                if (GetExecutionsTransformer.this.total - GetExecutionsTransformer.this.maxFeatures > index) {
                    attributes.addAttribute("", "next", "next", "", baseRequestUrl + "&startIndex=" + (index + GetExecutionsTransformer.this.maxFeatures));
                }
            }
        }

        protected void registerNamespaces(NamespaceSupport ns, AttributesImpl attributes) {
            Enumeration<String> declaredPrefixes = ns.getDeclaredPrefixes();
            while (declaredPrefixes.hasMoreElements()) {
                String prefix = declaredPrefixes.nextElement();
                String uri = ns.getURI(prefix);
                if ("xml".equals(prefix)) continue;
                String prefixDef = "xmlns:" + prefix;
                attributes.addAttribute("", prefixDef, prefixDef, "", uri);
            }
        }
    }
}

