/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInitializer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wps.ProcessGroupInfo;
import org.geoserver.wps.ProcessInfo;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geoserver.wps.process.ProcessSelector;
import org.geotools.api.feature.type.Name;
import org.geotools.process.ProcessFactory;

public class DisabledProcessesSelector
extends ProcessSelector
implements GeoServerInitializer {
    Set<Name> disabledProcesses = new HashSet<Name>();

    public DisabledProcessesSelector() {
    }

    public DisabledProcessesSelector(Set<Name> disabled) {
        this.disabledProcesses.addAll(disabled);
    }

    @Override
    protected boolean allowProcess(Name processName) {
        return !this.disabledProcesses.contains(processName);
    }

    public void initialize(GeoServer geoServer) throws Exception {
        WPSInfo wps = (WPSInfo)geoServer.getService(WPSInfo.class);
        if (wps != null) {
            this.updateFilters(wps);
        }
        geoServer.addListener((ConfigurationListener)new ConfigurationListenerAdapter(){

            public void handlePostServiceChange(ServiceInfo service) {
                if (service instanceof WPSInfo) {
                    DisabledProcessesSelector.this.updateFilters((WPSInfo)service);
                }
            }
        });
    }

    private void updateFilters(WPSInfo wps) {
        List<ProcessGroupInfo> groups = wps.getProcessGroups();
        this.disabledProcesses.clear();
        if (groups != null) {
            for (ProcessGroupInfo group : groups) {
                if (!group.isEnabled()) {
                    ProcessFactory factory = GeoServerProcessors.getProcessFactory(group.getFactoryClass(), false);
                    if (factory == null) continue;
                    this.disabledProcesses.addAll(factory.getNames());
                    continue;
                }
                if (group.getFilteredProcesses() == null) continue;
                for (ProcessInfo fp : group.getFilteredProcesses()) {
                    if (fp.isEnabled()) continue;
                    this.disabledProcesses.add(fp.getName());
                }
            }
        }
    }
}

