/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.awt.RenderingHints;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.ContextLoadedEvent;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.api.util.InternationalString;
import org.geotools.feature.NameImpl;
import org.geotools.process.Process;
import org.geotools.process.ProcessFactory;
import org.geotools.process.Processors;
import org.geotools.text.Text;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;

public class DeprecatedProcessFactory
implements ProcessFactory,
DisposableBean,
ApplicationListener<ApplicationEvent> {
    volatile Map<Name, Name> map;
    GeoServer geoServer;
    ConfigurationListener listener;

    public DeprecatedProcessFactory() {
        Processors.addProcessFactory((ProcessFactory)this);
    }

    public void destroy() throws Exception {
        if (this.geoServer != null) {
            this.geoServer.removeListener(this.listener);
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return null;
    }

    public InternationalString getTitle() {
        return Text.text((String)"Deprecated processes");
    }

    public Set<Name> getNames() {
        return this.getProcessMappings().keySet();
    }

    public InternationalString getTitle(Name name) {
        return this.doAction(name, (f, oldName, newName, args) -> f.getTitle(newName), new Object[0]);
    }

    public InternationalString getDescription(Name name) {
        return this.doAction(name, (f, oldName, newName, args) -> f.getDescription(newName), new Object[0]);
    }

    public String getVersion(Name name) {
        return this.doAction(name, (f, oldName, newName, args) -> f.getVersion(newName), new Object[0]);
    }

    public Map<String, Parameter<?>> getParameterInfo(Name name) {
        return this.doAction(name, (f, oldName, newName, args) -> f.getParameterInfo(newName), new Object[0]);
    }

    public Map<String, Parameter<?>> getResultInfo(Name name, Map<String, Object> parameters) throws IllegalArgumentException {
        return this.doAction(name, (f, oldName, newName, args) -> f.getResultInfo(newName, (Map)args[0]), parameters);
    }

    public boolean supportsProgress(Name name) {
        Boolean b = this.doAction(name, (f, oldName, newName, args) -> f.supportsProgress(newName), new Object[0]);
        return b != null ? b : false;
    }

    public Process create(Name name) {
        return this.doAction(name, (f, oldName, newName, args) -> f.create(newName), new Object[0]);
    }

    <T> T doAction(Name oldName, Action<T> a, Object ... args) {
        Name newName;
        ProcessFactory pf;
        Map<Name, Name> map = this.getProcessMappings();
        if (map.containsKey(oldName) && (pf = GeoServerProcessors.createProcessFactory(newName = map.get(oldName), false)) != null) {
            return a.perform(pf, oldName, newName, args);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Map<Name, Name> getProcessMappings() {
        if (this.map != null) return this.map;
        Class<DeprecatedProcessFactory> clazz = DeprecatedProcessFactory.class;
        synchronized (DeprecatedProcessFactory.class) {
            if (this.map != null) return this.map;
            this.map = new LinkedHashMap<Name, Name>();
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "length"), (Name)new NameImpl("geo", "length"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "isEmpty"), (Name)new NameImpl("geo", "isEmpty"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "contains"), (Name)new NameImpl("geo", "contains"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "disjoint"), (Name)new NameImpl("geo", "disjoint"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "intersects"), (Name)new NameImpl("geo", "intersects"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "isClosed"), (Name)new NameImpl("geo", "isClosed"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "isValid"), (Name)new NameImpl("geo", "isValid"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "buffer"), (Name)new NameImpl("geo", "buffer"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "getY"), (Name)new NameImpl("geo", "getY"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "getX"), (Name)new NameImpl("geo", "getX"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "union"), (Name)new NameImpl("geo", "union"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "intersection"), (Name)new NameImpl("geo", "intersection"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "difference"), (Name)new NameImpl("geo", "difference"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "distance"), (Name)new NameImpl("geo", "distance"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "envelope"), (Name)new NameImpl("geo", "envelope"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "dimension"), (Name)new NameImpl("geo", "dimension"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "overlaps"), (Name)new NameImpl("geo", "overlaps"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "reproject"), (Name)new NameImpl("geo", "reproject"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "simplify"), (Name)new NameImpl("geo", "simplify"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "isSimple"), (Name)new NameImpl("geo", "isSimple"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "equalsExact"), (Name)new NameImpl("geo", "equalsExact"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "getGeometryN"), (Name)new NameImpl("geo", "getGeometryN"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "isWithinDistance"), (Name)new NameImpl("geo", "isWithinDistance"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "touches"), (Name)new NameImpl("geo", "touches"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "crosses"), (Name)new NameImpl("geo", "crosses"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "within"), (Name)new NameImpl("geo", "within"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "relate"), (Name)new NameImpl("geo", "relate"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "convexHull"), (Name)new NameImpl("geo", "convexHull"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "symDifference"), (Name)new NameImpl("geo", "symDifference"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "centroid"), (Name)new NameImpl("geo", "centroid"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "interiorPoint"), (Name)new NameImpl("geo", "interiorPoint"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "numPoints"), (Name)new NameImpl("geo", "numPoints"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "area"), (Name)new NameImpl("geo", "area"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "isRing"), (Name)new NameImpl("geo", "isRing"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "exteriorRing"), (Name)new NameImpl("geo", "exteriorRing"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "numInteriorRing"), (Name)new NameImpl("geo", "numInteriorRing"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "numGeometries"), (Name)new NameImpl("geo", "numGeometries"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "geometryType"), (Name)new NameImpl("geo", "geometryType"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "boundary"), (Name)new NameImpl("geo", "boundary"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "densify"), (Name)new NameImpl("geo", "densify"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "relatePattern"), (Name)new NameImpl("geo", "relatePattern"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "equalsExactTolerance"), (Name)new NameImpl("geo", "equalsExactTolerance"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "pointN"), (Name)new NameImpl("geo", "pointN"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "startPoint"), (Name)new NameImpl("geo", "startPoint"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "endPoint"), (Name)new NameImpl("geo", "endPoint"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "interiorRingN"), (Name)new NameImpl("geo", "interiorRingN"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "polygonize"), (Name)new NameImpl("geo", "polygonize"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("JTS", "splitPolygon"), (Name)new NameImpl("geo", "splitPolygon"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "ReprojectGeometry"), (Name)new NameImpl("geo", "reproject"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "Aggregate"), (Name)new NameImpl("vec", "Aggregate"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "Bounds"), (Name)new NameImpl("vec", "Bounds"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "BufferFeatureCollection"), (Name)new NameImpl("vec", "BufferFeatureCollection"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "Centroid"), (Name)new NameImpl("vec", "Centroid"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "Clip"), (Name)new NameImpl("vec", "Clip"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "CollectGeometries"), (Name)new NameImpl("vec", "CollectGeometries"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "Count"), (Name)new NameImpl("vec", "Count"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "Feature"), (Name)new NameImpl("vec", "Feature"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "Grid"), (Name)new NameImpl("vec", "Grid"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "InclusionFeatureCollection"), (Name)new NameImpl("vec", "InclusionFeatureCollection"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "IntersectionFeatureCollection"), (Name)new NameImpl("vec", "IntersectionFeatureCollection"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "LRSGeocode"), (Name)new NameImpl("vec", "LRSGeocode"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "LRSMeasure"), (Name)new NameImpl("vec", "LRSMeasure"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "LRSSegment"), (Name)new NameImpl("vec", "LRSSegment"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "Nearest"), (Name)new NameImpl("vec", "Nearest"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "PointBuffers"), (Name)new NameImpl("vec", "PointBuffers"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "PointStacker"), (Name)new NameImpl("vec", "PointStacker"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "Query"), (Name)new NameImpl("vec", "Query"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "RectangularClip"), (Name)new NameImpl("vec", "RectangularClip"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "Reproject"), (Name)new NameImpl("vec", "Reproject"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "Simplify"), (Name)new NameImpl("vec", "Simplify"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "Snap"), (Name)new NameImpl("vec", "Snap"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "Transform"), (Name)new NameImpl("vec", "Transform"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "UnionFeatureCollection"), (Name)new NameImpl("vec", "UnionFeatureCollection"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "Unique"), (Name)new NameImpl("vec", "Unique"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "VectorZonalStatistics"), (Name)new NameImpl("vec", "VectorZonalStatistics"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "Heatmap"), (Name)new NameImpl("vec", "Heatmap"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "BarnesSurface"), (Name)new NameImpl("vec", "BarnesSurface"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "AddCoverages"), (Name)new NameImpl("ras", "AddCoverages"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "AreaGrid"), (Name)new NameImpl("ras", "AreaGrid"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "Contour"), (Name)new NameImpl("ras", "Contour"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "CropCoverage"), (Name)new NameImpl("ras", "CropCoverage"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "MultiplyCoverages"), (Name)new NameImpl("ras", "MultiplyCoverages"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "PolygonExtraction"), (Name)new NameImpl("ras", "PolygonExtraction"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "RangeLookup"), (Name)new NameImpl("ras", "RangeLookup"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "RasterAsPointCollection"), (Name)new NameImpl("ras", "RasterAsPointCollection"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "RasterZonalStatistics"), (Name)new NameImpl("ras", "RasterZonalStatistics"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "ScaleCoverage"), (Name)new NameImpl("ras", "ScaleCoverage"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gs", "StyleCoverage"), (Name)new NameImpl("ras", "StyleCoverage"), this.map);
            DeprecatedProcessFactory.registerProcessMapping((Name)new NameImpl("gt", "VectorToRaster"), (Name)new NameImpl("vec", "VectorToRaster"), this.map);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.map;
        }
    }

    void resetProcessMappings() {
        this.map = null;
    }

    static void registerProcessMapping(Name oldName, Name newName, Map<Name, Name> map) {
        if (GeoServerProcessors.createProcess(newName) != null) {
            map.put(oldName, newName);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextLoadedEvent) {
            this.geoServer = (GeoServer)GeoServerExtensions.bean(GeoServer.class, (ApplicationContext)((ContextLoadedEvent)event).getApplicationContext());
            this.listener = new ConfigurationListenerAdapter(){

                public void handleServiceChange(ServiceInfo service, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
                    if (service instanceof WPSInfo) {
                        DeprecatedProcessFactory.this.resetProcessMappings();
                    }
                }
            };
            this.geoServer.addListener(this.listener);
        }
        if (event instanceof ContextRefreshedEvent) {
            Processors.addProcessFactory((ProcessFactory)this);
        } else if (event instanceof ContextClosedEvent) {
            Processors.removeProcessFactory((ProcessFactory)this);
        }
    }

    static interface Action<T> {
        public T perform(ProcessFactory var1, Name var2, Name var3, Object ... var4);
    }
}

