/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.output.WriterOutputStream;
import org.geoserver.wps.ppio.CDataPPIO;
import org.geotools.xsd.EncoderDelegate;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class CDataEncoderDelegate
implements EncoderDelegate {
    CDataPPIO ppio;
    Object object;

    public CDataEncoderDelegate(CDataPPIO ppio, Object object) {
        this.ppio = ppio;
        this.object = object;
    }

    public void encode(ContentHandler output) throws Exception {
        ((LexicalHandler)((Object)output)).startCDATA();
        try (WriterOutputStream os = ((WriterOutputStream.Builder)WriterOutputStream.builder().setWriter((Writer)new ContentHandlerWriter(output))).setCharset(StandardCharsets.UTF_8).get();){
            this.ppio.encode(this.object, (OutputStream)os);
        }
        ((LexicalHandler)((Object)output)).endCDATA();
    }

    public void encode(OutputStream os) throws Exception {
        this.ppio.encode(this.object, os);
    }

    public CDataPPIO getPPIO() {
        return this.ppio;
    }

    static class ContentHandlerWriter
    extends Writer {
        ContentHandler ch;

        public ContentHandlerWriter(ContentHandler ch) {
            this.ch = ch;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            try {
                this.ch.characters(cbuf, off, len);
            }
            catch (SAXException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

