/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.validator;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.ExtensionPriority;
import org.geoserver.wps.ProcessGroupInfo;
import org.geoserver.wps.ProcessInfo;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geoserver.wps.process.DelegatingProcessFactory;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geoserver.wps.process.ProcessFilter;
import org.geoserver.wps.validator.MaxSizeValidator;
import org.geoserver.wps.validator.MultiplicityValidator;
import org.geoserver.wps.validator.NumberRangeValidator;
import org.geoserver.wps.validator.WPSInputValidator;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.geotools.process.ProcessFactory;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.validation.Validator;

public class ProcessLimitsFilter
implements ProcessFilter,
ApplicationContextAware,
ExtensionPriority {
    static final Logger LOGGER = Logging.getLogger(ProcessLimitsFilter.class);
    static final Multimap<String, WPSInputValidator> EMPTY_MULTIMAP = ImmutableMultimap.of();
    public static final String VALIDATORS_KEY = "wpsValidators";
    GeoServer geoServer;
    private ApplicationContext applicationContext;

    public ProcessLimitsFilter(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    @Override
    public ProcessFactory filterFactory(ProcessFactory pf) {
        return new ProcessLimitFactory(pf);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    class ProcessLimitFactory
    extends DelegatingProcessFactory {
        public ProcessLimitFactory(ProcessFactory delegate) {
            super(delegate);
        }

        @Override
        public Map<String, Parameter<?>> getParameterInfo(Name name) {
            WPSInfo wps = (WPSInfo)ProcessLimitsFilter.this.geoServer.getService(WPSInfo.class);
            ProcessFactory factory = GeoServerProcessors.createProcessFactory(name, false);
            ProcessInfo processInfo = null;
            for (ProcessGroupInfo group : wps.getProcessGroups()) {
                if (!group.getFactoryClass().equals(factory.getClass())) continue;
                List<ProcessInfo> filteredProcesses = group.getFilteredProcesses();
                for (ProcessInfo pi : filteredProcesses) {
                    if (!name.equals((Object)pi.getName())) continue;
                    processInfo = pi;
                    break;
                }
                if (processInfo == null) continue;
                break;
            }
            Map<String, Parameter<?>> result = super.getParameterInfo(name);
            int maxComplexInputSize = wps.getMaxComplexInputSize();
            if (maxComplexInputSize <= 0 && (processInfo == null || processInfo.getValidators() == null || processInfo.getValidators().isEmpty())) {
                return result;
            }
            Multimap<String, WPSInputValidator> validatorsMap = processInfo != null ? processInfo.getValidators() : EMPTY_MULTIMAP;
            LinkedHashMap params = new LinkedHashMap(result);
            for (String paramName : ((HashMap)params).keySet()) {
                Parameter param = (Parameter)((HashMap)params).get(paramName);
                Collection validators = validatorsMap.get((Object)paramName);
                if (validators == null && (maxComplexInputSize <= 0 || !ProcessParameterIO.isComplex(param, ProcessLimitsFilter.this.applicationContext))) continue;
                HashMap<String, Object> metadataClone = new HashMap<String, Object>(param.metadata);
                if (wps.getMaxComplexInputSize() > 0) {
                    metadataClone.put(MaxSizeValidator.PARAMETER_KEY, wps.getMaxComplexInputSize());
                }
                int maxOccurs = param.getMaxOccurs();
                if (validators != null) {
                    metadataClone.put(ProcessLimitsFilter.VALIDATORS_KEY, validators);
                    for (Validator validator : validators) {
                        MultiplicityValidator mv;
                        int max;
                        if (validator instanceof MaxSizeValidator) {
                            MaxSizeValidator msv = (MaxSizeValidator)validator;
                            int maxSizeMB = msv.getMaxSizeMB();
                            metadataClone.put(MaxSizeValidator.PARAMETER_KEY, maxSizeMB);
                            continue;
                        }
                        if (validator instanceof NumberRangeValidator) {
                            NumberRangeValidator rv = (NumberRangeValidator)validator;
                            this.validate(param, metadataClone, rv);
                            continue;
                        }
                        if (!(validator instanceof MultiplicityValidator) || (max = (mv = (MultiplicityValidator)validator).getMaxInstances()) >= maxOccurs) continue;
                        maxOccurs = max;
                    }
                }
                Parameter substitute = new Parameter(param.key, param.type, param.title, param.description, param.required, param.minOccurs, maxOccurs, param.sample, metadataClone);
                params.put(param.key, substitute);
            }
            return params;
        }

        private void validate(Parameter<?> param, Map<String, Object> metadataClone, NumberRangeValidator rv) {
            NumberRange<?> range = rv.getRange();
            Comparable min = (Comparable)param.metadata.get("min");
            Comparable max = (Comparable)param.metadata.get("max");
            boolean restricting = false;
            if (range.getMinValue() != null && (min == null || min.compareTo(range.getMinValue()) < 0)) {
                min = range.getMinValue();
                restricting = true;
            }
            if (range.getMaxValue() != null && (max == null || max.compareTo(range.getMaxValue()) > 0)) {
                max = range.getMaxValue();
                restricting = true;
            }
            if (restricting) {
                if (min != null) {
                    metadataClone.put("min", min);
                }
                if (max != null) {
                    metadataClone.put("max", max);
                }
            }
        }
    }
}

