/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.validator;

import org.geoserver.wps.validator.ObjectSizeEstimators;
import org.geoserver.wps.validator.WPSInputValidator;
import org.springframework.validation.Errors;

public class MaxSizeValidator
implements WPSInputValidator {
    private static final long serialVersionUID = 6486547223545859567L;
    public static String PARAMETER_KEY = "MaxSizeMB";
    static final long MB = 0x100000L;
    static final String CODE = "ExcessSize";
    int maxSizeMB;

    public MaxSizeValidator(int maxSizeMB) {
        this.maxSizeMB = maxSizeMB;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public void validate(Object target, Errors errors) {
        long size = ObjectSizeEstimators.getSizeOf(target);
        if (size > 0L && size > (long)this.maxSizeMB * 0x100000L) {
            errors.reject(CODE, this.getErrorMessage(size));
        }
    }

    public String getErrorMessage(long size) {
        return "The size of the input has been estimated to " + size + ", which exceeds the maximum allowed " + (long)this.maxSizeMB * 0x100000L;
    }

    public int getMaxSizeMB() {
        return this.maxSizeMB;
    }

    public void setMaxSizeMB(int maxSizeMB) {
        this.maxSizeMB = maxSizeMB;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maxSizeMB;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MaxSizeValidator other = (MaxSizeValidator)obj;
        return this.maxSizeMB == other.maxSizeMB;
    }

    public String toString() {
        return "MaxSizeValidator [maxSizeMB=" + this.maxSizeMB + "]";
    }

    @Override
    public WPSInputValidator copy() {
        return new MaxSizeValidator(this.maxSizeMB);
    }

    @Override
    public boolean isUnset() {
        return this.maxSizeMB <= 0;
    }
}

