/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.resource;

import java.util.Map;
import org.geoserver.threadlocals.ThreadLocalTransfer;
import org.geoserver.wps.resource.WPSResourceManager;

public class ExecutionIdThreadLocalTransfer
implements ThreadLocalTransfer {
    static final String KEY = ExecutionIdThreadLocalTransfer.class.getCanonicalName() + ".key";
    WPSResourceManager manager;

    public ExecutionIdThreadLocalTransfer(WPSResourceManager manager) {
        this.manager = manager;
    }

    public void collect(Map<String, Object> storage) {
        String executionId = this.manager.getCurrentExecutionId();
        if (executionId != null) {
            storage.put(KEY, executionId);
        }
    }

    public void apply(Map<String, Object> storage) {
        String executionId = (String)storage.get(KEY);
        if (executionId != null) {
            this.manager.setCurrentExecutionId(executionId);
        }
    }

    public void cleanup() {
        this.manager.clearExecutionId();
    }
}

