/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.resource;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.geoserver.wcs.CoverageCleanerCallback;
import org.geoserver.wps.ProcessEvent;
import org.geoserver.wps.ProcessListenerAdapter;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.resource.GridCoverageResource;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.api.coverage.grid.GridCoverage;

public class CoverageResourceListener
extends ProcessListenerAdapter {
    WPSResourceManager resourceManager;
    CoverageCleanerCallback cleaner;
    Map<String, ResourceStatus> resourceStates = new ConcurrentHashMap<String, ResourceStatus>();

    public CoverageResourceListener(WPSResourceManager resourceManager, CoverageCleanerCallback cleaner) {
        this.resourceManager = resourceManager;
        this.cleaner = cleaner;
    }

    @Override
    public void progress(ProcessEvent event) throws WPSException {
        this.checkInputOutput(event);
    }

    private void checkInputOutput(ProcessEvent event) {
        Map<String, Object> inputs = event.getInputs();
        Map<String, Object> outputs = event.getOutputs();
        if ((inputs == null || inputs.isEmpty()) && (outputs == null || outputs.isEmpty())) {
            return;
        }
        String executionId = event.getStatus().getExecutionId();
        ResourceStatus status = this.resourceStates.get(executionId);
        if (status == null) {
            status = new ResourceStatus();
            this.resourceStates.put(executionId, status);
        }
        Set<String> inputsChecked = status.inputsChecked;
        if (inputs != null && inputsChecked.size() < inputs.size()) {
            for (Map.Entry<String, Object> entry : inputs.entrySet()) {
                Object input = entry.getValue();
                if (input == null || !inputsChecked.add(entry.getKey()) || !(input instanceof GridCoverage)) continue;
                this.resourceManager.addResource(new GridCoverageResource((GridCoverage)input));
            }
        }
        Set<String> outputsChecked = status.outputsChecked;
        if (outputs != null && outputsChecked.size() < outputs.size()) {
            for (Map.Entry<String, Object> entry : outputs.entrySet()) {
                Object output = entry.getValue();
                if (output == null || !outputsChecked.add(entry.getKey()) || !(output instanceof GridCoverage)) continue;
                this.resourceManager.addResource(new GridCoverageResource((GridCoverage)output));
            }
        }
    }

    @Override
    public void succeeded(ProcessEvent event) throws WPSException {
        this.cleanResourceStatus(event);
    }

    @Override
    public void dismissed(ProcessEvent event) throws WPSException {
        this.cleanResourceStatus(event);
    }

    @Override
    public void failed(ProcessEvent event) {
        this.cleanResourceStatus(event);
        this.cleaner.clean();
    }

    private void cleanResourceStatus(ProcessEvent event) {
        this.checkInputOutput(event);
        this.resourceStates.remove(event.getStatus().getExecutionId());
    }

    private static class ResourceStatus {
        final Set<String> inputsChecked = new HashSet<String>();
        final Set<String> outputsChecked = new HashSet<String>();

        private ResourceStatus() {
        }
    }
}

