/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.WfsFactory;
import net.opengis.wfs20.FeatureCollectionType;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geoserver.wfs.xml.v1_1_0.WFS;
import org.geoserver.wps.ppio.XMLPPIO;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gml2.SrsSyntax;
import org.geotools.gml3.GML;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.v1_0.WFSConfiguration_1_0;
import org.geotools.wfs.v1_1.WFSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.geotools.xsd.Parser;
import org.locationtech.jts.geom.Geometry;
import org.xml.sax.ContentHandler;

public class WFSPPIO
extends XMLPPIO {
    Configuration configuration;
    private static final Logger LOGGER = Logging.getLogger(WFSPPIO.class);
    private static final String METADATA = GML.metaDataProperty.getLocalPart();
    private static final String BOUNDEDBY = GML.boundedBy.getLocalPart();
    private static final String LOCATION = GML.location.getLocalPart();

    protected WFSPPIO(Configuration configuration, String mimeType, QName element) {
        super(net.opengis.wfs.FeatureCollectionType.class, FeatureCollection.class, mimeType, element);
        this.configuration = configuration;
    }

    @Override
    public Object decode(InputStream input) throws Exception {
        Object result;
        Parser p = this.getParser(this.configuration);
        byte[] streamBytes = null;
        if (LOGGER.isLoggable(Level.FINEST)) {
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                ByteStreams.copy((InputStream)input, (OutputStream)outputStream);
                streamBytes = outputStream.toByteArray();
            }
            input = new ByteArrayInputStream(streamBytes);
        }
        if ((result = p.parse(input)) instanceof net.opengis.wfs.FeatureCollectionType) {
            net.opengis.wfs.FeatureCollectionType fct = (net.opengis.wfs.FeatureCollectionType)result;
            return this.decode(fct);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Decoding the following WFS response did not result in an object of type FeatureCollectionType: \n" + new String(streamBytes));
        }
        throw new IllegalArgumentException("Decoded WFS result is not a feature collection, got a: " + result);
    }

    @Override
    public Object decode(Object input) throws Exception {
        CoordinateReferenceSystem crs;
        SimpleFeatureCollection fc;
        net.opengis.wfs.FeatureCollectionType fct;
        if (input instanceof String) {
            Parser p = this.getParser(this.configuration);
            input = p.parse((Reader)new StringReader((String)input));
        }
        if (input instanceof net.opengis.wfs.FeatureCollectionType) {
            fct = (net.opengis.wfs.FeatureCollectionType)input;
            fc = (SimpleFeatureCollection)fct.getFeature().get(0);
        } else {
            fct = (FeatureCollectionType)input;
            fc = (SimpleFeatureCollection)fct.getMember().get(0);
        }
        if (((SimpleFeatureType)fc.getSchema()).getGeometryDescriptor() != null && (crs = this.getCollectionCRS(fc)) != null) {
            String eastNorthId;
            CoordinateReferenceSystem lonLatCrs;
            String identifier;
            CoordinateReferenceSystem nativeCrs = ((SimpleFeatureType)fc.getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem();
            if (nativeCrs == null) {
                fc = new ForceCoordinateSystemFeatureResults((FeatureCollection)fc, crs, false);
            }
            if ((identifier = ResourcePool.lookupIdentifier((CoordinateReferenceSystem)crs, (boolean)false)) != null && !CRS.equalsIgnoreMetadata((Object)crs, (Object)(lonLatCrs = CRS.decode((String)(eastNorthId = SrsSyntax.AUTH_CODE.getSRS(identifier)), (boolean)true)))) {
                fc = new ReprojectingFeatureCollection(fc, lonLatCrs);
            }
        }
        return this.eliminateFeatureBounds(fc);
    }

    private SimpleFeatureCollection eliminateFeatureBounds(SimpleFeatureCollection fc) {
        SimpleFeatureType original = (SimpleFeatureType)fc.getSchema();
        ArrayList<String> names = new ArrayList<String>();
        boolean alternateGeometry = false;
        for (AttributeDescriptor ad : original.getAttributeDescriptors()) {
            String name = ad.getLocalName();
            if (!BOUNDEDBY.equals(name) && !METADATA.equals(name)) {
                names.add(name);
            }
            if (LOCATION.equals(name) || !(ad instanceof GeometryDescriptor)) continue;
            alternateGeometry = true;
        }
        if (alternateGeometry) {
            names.remove("location");
        }
        if (names.size() < original.getDescriptors().size()) {
            String[] namesArray = names.toArray(new String[names.size()]);
            SimpleFeatureType target = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)original, (String[])namesArray);
            return new RetypingFeatureCollection(fc, target);
        }
        return fc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CoordinateReferenceSystem getCollectionCRS(SimpleFeatureCollection fc) throws Exception {
        if (((SimpleFeatureType)fc.getSchema()).getCoordinateReferenceSystem() != null) {
            return ((SimpleFeatureType)fc.getSchema()).getCoordinateReferenceSystem();
        }
        CoordinateReferenceSystem crs = null;
        try (SimpleFeatureIterator fi = fc.features();){
            block13: {
                while (fi.hasNext()) {
                    Geometry g;
                    SimpleFeature f = (SimpleFeature)fi.next();
                    CoordinateReferenceSystem featureCrs = null;
                    GeometryDescriptor gd = f.getType().getGeometryDescriptor();
                    if (gd != null && gd.getCoordinateReferenceSystem() != null) {
                        featureCrs = gd.getCoordinateReferenceSystem();
                    }
                    if (f.getDefaultGeometry() != null && (g = (Geometry)f.getDefaultGeometry()).getUserData() instanceof CoordinateReferenceSystem) {
                        featureCrs = (CoordinateReferenceSystem)g.getUserData();
                    }
                    if (featureCrs == null) continue;
                    if (crs == null) {
                        crs = featureCrs;
                        continue;
                    }
                    if (CRS.equalsIgnoreMetadata((Object)featureCrs, (Object)crs)) {
                        continue;
                    }
                    break block13;
                }
                return crs;
            }
            CoordinateReferenceSystem coordinateReferenceSystem = null;
            return coordinateReferenceSystem;
        }
    }

    @Override
    public void encode(Object object, ContentHandler handler) throws Exception {
        FeatureCollection features = (FeatureCollection)object;
        SimpleFeatureType featureType = (SimpleFeatureType)features.getSchema();
        net.opengis.wfs.FeatureCollectionType fc = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fc.getFeature().add((Object)features);
        Encoder e = new Encoder(this.configuration);
        e.getNamespaces().declarePrefix("feature", featureType.getName().getNamespaceURI());
        e.encode((Object)fc, this.getElement(), handler);
    }

    public static class WFS20
    extends WFSPPIO {
        public WFS20() {
            super((Configuration)new org.geoserver.wfs.xml.v2_0.WFSConfiguration(), "text/xml", org.geotools.wfs.v2_0.WFS.FeatureCollection);
        }
    }

    public static class WFS11Alternate
    extends WFSPPIO {
        public WFS11Alternate() {
            super((Configuration)new WFSConfiguration(), "application/wfs-collection-1.1", WFS.FEATURECOLLECTION);
        }
    }

    public static class WFS11
    extends WFSPPIO {
        public WFS11() {
            super((Configuration)new WFSConfiguration(), "text/xml; subtype=wfs-collection/1.1", WFS.FEATURECOLLECTION);
        }
    }

    public static class WFS10Alternate
    extends WFSPPIO {
        public WFS10Alternate() {
            super((Configuration)new WFSConfiguration_1_0(), "application/wfs-collection-1.0", org.geoserver.wfs.xml.v1_0_0.WFS.FEATURECOLLECTION);
        }
    }

    public static class WFS10
    extends WFSPPIO {
        public WFS10() {
            super((Configuration)new WFSConfiguration_1_0(), "text/xml; subtype=wfs-collection/1.0", org.geoserver.wfs.xml.v1_0_0.WFS.FEATURECOLLECTION);
        }
    }
}

