/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.ppio;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;
import org.jaitools.numeric.Range;

public class JAIToolsRangeConverterFactory
implements ConverterFactory {
    private static final String RE_OPEN = "(\\(|\\[)";
    private static final String RE_CLOSE = "(\\)|\\])";
    private static final String RE_NUM = "(\\-?\\d+(?:\\.\\d*)?)?";
    private static final String RANGE_REGEX = "(\\(|\\[)(\\-?\\d+(?:\\.\\d*)?)?;(\\-?\\d+(?:\\.\\d*)?)?(\\)|\\])";
    private static final Pattern RANGE_PATTERN = Pattern.compile("(\\(|\\[)(\\-?\\d+(?:\\.\\d*)?)?;(\\-?\\d+(?:\\.\\d*)?)?(\\)|\\])");
    private static final String RANGELIST_REGEX = "((\\(|\\[)(\\-?\\d+(?:\\.\\d*)?)?;(\\-?\\d+(?:\\.\\d*)?)?(\\)|\\]))+";
    private static final Pattern RANGELIST_PATTERN = Pattern.compile("((\\(|\\[)(\\-?\\d+(?:\\.\\d*)?)?;(\\-?\\d+(?:\\.\\d*)?)?(\\)|\\]))+");

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (target.equals(Range.class) && source.equals(String.class)) {
            return new Converter(){

                public <T> T convert(Object source, Class<T> target) throws Exception {
                    String sRange = (String)source;
                    Matcher m = RANGE_PATTERN.matcher(sRange);
                    if (!m.matches()) {
                        return null;
                    }
                    return (T)JAIToolsRangeConverterFactory.parseRangeInternal(m, sRange);
                }
            };
        }
        return null;
    }

    static Range<Double> parseRangeInternal(Matcher m, String sRange) {
        boolean inclmax;
        boolean inclmin;
        Double min = null;
        Double max = null;
        if (m.groupCount() != 4) {
            throw new IllegalStateException("Range returned wrong group count (" + sRange + ") : " + m.groupCount());
        }
        if (m.group(2) != null) {
            min = Double.valueOf(m.group(2));
        }
        if (m.group(3) != null) {
            max = Double.valueOf(m.group(3));
        }
        if (m.group(1).equals("(")) {
            inclmin = false;
        } else if (m.group(1).equals("[")) {
            inclmin = true;
        } else {
            throw new IllegalArgumentException("Bad min delimiter (" + sRange + ")");
        }
        if (m.group(4).equals(")")) {
            inclmax = false;
        } else if (m.group(4).equals("]")) {
            inclmax = true;
        } else {
            throw new IllegalArgumentException("Bad max delimiter (" + sRange + ")");
        }
        if (min != null && max != null && min > max) {
            throw new IllegalArgumentException("Bad min/max relation (" + sRange + ")");
        }
        return new Range((Number)min, inclmin, (Number)max, inclmax);
    }

    public static List<Range<Double>> parseRanges(String sRangeList) {
        Matcher m = RANGELIST_PATTERN.matcher(sRangeList);
        if (!m.matches()) {
            throw new IllegalArgumentException("Bad range definition '" + sRangeList + "'");
        }
        m = RANGE_PATTERN.matcher(sRangeList);
        ArrayList<Range<Double>> ret = new ArrayList<Range<Double>>();
        while (m.find()) {
            Range<Double> range = JAIToolsRangeConverterFactory.parseRangeInternal(m, sRangeList);
            ret.add(range);
        }
        return ret;
    }
}

