/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.platform.ExtensionPriority;
import org.geoserver.wps.process.DelegatingProcessFactory;
import org.geoserver.wps.process.ProcessFilter;
import org.geotools.api.feature.type.Name;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.util.DelegateProgressListener;
import org.geotools.process.Process;
import org.geotools.process.ProcessException;
import org.geotools.process.ProcessFactory;
import org.geotools.util.logging.Logging;

public class ProcessStartupFilter
implements ProcessFilter,
ExtensionPriority {
    static final Logger LOGGER = Logging.getLogger(ProcessStartupFilter.class);

    @Override
    public ProcessFactory filterFactory(ProcessFactory pf) {
        return new ProcessStartupFactory(pf);
    }

    public int getPriority() {
        return 101;
    }

    class ProcessStartupFactory
    extends DelegatingProcessFactory {
        public ProcessStartupFactory(ProcessFactory delegate) {
            super(delegate);
        }

        @Override
        public Process create(Name name) {
            Process process = this.delegate.create(name);
            return new ProcessStartupWrapper(process);
        }
    }

    public class ProcessStartupWrapper
    implements Process {
        Process delegate;

        public ProcessStartupWrapper(Process delegate) {
            this.delegate = delegate;
        }

        public Map<String, Object> execute(Map<String, Object> input, ProgressListener monitor) throws ProcessException {
            if (monitor != null) {
                monitor.started();
                monitor = new DelegateProgressListener((ProgressListener)monitor){

                    public void started() {
                    }
                };
            }
            return this.delegate.execute(input, monitor);
        }
    }
}

