/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.wps.ProcessDismissedException;
import org.geoserver.wps.ProcessEvent;
import org.geoserver.wps.ProcessListener;
import org.geoserver.wps.executor.ExecuteRequest;
import org.geoserver.wps.executor.ExecutionStatus;
import org.geoserver.wps.executor.LazyInputMap;
import org.geoserver.wps.executor.ProcessState;
import org.geotools.api.util.InternationalString;
import org.geotools.api.util.ProgressListener;
import org.geotools.util.logging.Logging;

public class ProcessListenerNotifier {
    static final Logger LOGGER = Logging.getLogger(ProcessListenerNotifier.class);
    ExecutionStatus status;
    List<ProcessListener> listeners;
    WPSProgressListener progressListener;
    LazyInputMap inputs;
    Map<String, Object> outputs;
    ExecuteRequest request;

    public ProcessListenerNotifier(ExecutionStatus status, ExecuteRequest request, LazyInputMap inputs, List<ProcessListener> listeners) {
        this.status = status;
        this.request = request;
        this.progressListener = new WPSProgressListener();
        this.inputs = inputs;
        this.listeners = listeners;
        this.fireProcessSubmitted();
    }

    public void fireProcessSubmitted() {
        ProcessEvent event = new ProcessEvent(this.status, this.inputs);
        for (ProcessListener listener : this.listeners) {
            listener.submitted(event);
        }
    }

    public void fireProgress(float progress, String task) {
        if (progress > this.status.progress || StringUtils.equals((CharSequence)task, (CharSequence)this.status.task)) {
            if (this.status.getPhase() == ProcessState.QUEUED) {
                this.status.setPhase(ProcessState.RUNNING);
            }
            this.status.setProgress(progress);
            this.status.setTask(task);
            if (progress > 0.0f) {
                long timeElapsedMillis = new Date().getTime() - this.status.getCreationTime().getTime();
                int estimatedCompletionMillis = (int)((float)timeElapsedMillis / progress * (float)timeElapsedMillis + (float)timeElapsedMillis);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(this.status.getCreationTime());
                calendar.add(14, estimatedCompletionMillis);
                this.status.setEstimatedCompletion(calendar.getTime());
            }
            ProcessEvent event = new ProcessEvent(this.status, this.inputs, this.outputs);
            for (ProcessListener listener : this.listeners) {
                listener.progress(event);
            }
        }
    }

    public void fireFailed(Throwable e) {
        this.status.setPhase(ProcessState.FAILED);
        if (e != null) {
            this.status.setException(e);
        }
        ProcessEvent event = new ProcessEvent(this.status, this.inputs, this.outputs);
        for (ProcessListener listener : this.listeners) {
            listener.failed(event);
        }
    }

    public void fireSucceded() {
        this.status.setPhase(ProcessState.SUCCEEDED);
        this.status.setProgress(100.0f);
        this.status.setTask(null);
        ProcessEvent event = new ProcessEvent(this.status, this.inputs, this.outputs);
        for (ProcessListener listener : this.listeners) {
            listener.succeeded(event);
        }
    }

    public void fireCompleted() {
        if (this.status.getPhase() == ProcessState.RUNNING) {
            this.fireSucceded();
        } else if (this.status.getPhase() == ProcessState.DISMISSING) {
            this.fireDismissed();
        } else {
            this.fireFailed(null);
        }
    }

    public void dismiss() {
        this.status.phase = ProcessState.DISMISSING;
        ProcessEvent event = new ProcessEvent(this.status, this.inputs, this.outputs);
        for (ProcessListener listener : this.listeners) {
            listener.dismissing(event);
        }
    }

    public void fireDismissed() {
        this.status.phase = ProcessState.FAILED;
        ProcessEvent event = new ProcessEvent(this.status, this.inputs, this.outputs);
        for (ProcessListener listener : this.listeners) {
            listener.dismissed(event);
        }
    }

    public WPSProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void checkDismissed() {
        if (this.status.getPhase() == ProcessState.DISMISSING) {
            throw new ProcessDismissedException();
        }
    }

    class WPSProgressListener
    implements ProgressListener {
        InternationalString task;
        String description;
        Throwable exception;

        WPSProgressListener() {
        }

        public InternationalString getTask() {
            return this.task;
        }

        public void setTask(InternationalString task) {
            this.task = task;
            ProcessListenerNotifier.this.checkDismissed();
            ProcessListenerNotifier.this.fireProgress(ProcessListenerNotifier.this.status.progress, task.toString());
        }

        public void started() {
            this.progress(0.0f);
        }

        public void progress(float percent) {
            ProcessListenerNotifier.this.checkDismissed();
            ProcessListenerNotifier.this.fireProgress(percent, this.task != null ? this.task.toString() : null);
        }

        public float getProgress() {
            return ProcessListenerNotifier.this.status.progress;
        }

        public void complete() {
            this.progress(100.0f);
        }

        public void dispose() {
        }

        public boolean isCanceled() {
            return ProcessListenerNotifier.this.status.phase == ProcessState.DISMISSING;
        }

        public void setCanceled(boolean cancel) {
            ProcessListenerNotifier.this.dismiss();
        }

        public void warningOccurred(String source, String location, String warning) {
            LOGGER.log(Level.WARNING, "Got a warning during process execution " + ProcessListenerNotifier.this.status.getExecutionId() + ": " + warning);
            ProcessListenerNotifier.this.checkDismissed();
        }

        public void exceptionOccurred(Throwable exception) {
            if (ProcessListenerNotifier.this.status.phase != ProcessState.DISMISSING) {
                this.exception = exception;
                ProcessListenerNotifier.this.fireFailed(exception);
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

