/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.geoserver.platform.ExtensionPriority;
import org.geoserver.threadlocals.ThreadLocalsTransfer;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.ProcessManager;
import org.geoserver.wps.process.GeoServerProcessors;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.api.feature.type.Name;
import org.geotools.api.util.ProgressListener;
import org.geotools.process.Process;
import org.geotools.process.ProcessException;
import org.geotools.process.ProcessFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

public class DefaultProcessManager
implements ProcessManager,
ExtensionPriority,
ApplicationListener<ApplicationEvent> {
    ConcurrentHashMap<String, Future<Map<String, Object>>> executions = new ConcurrentHashMap();
    ThreadPoolExecutor synchService;
    ThreadPoolExecutor asynchService;
    WPSResourceManager resourceManager;

    public DefaultProcessManager(WPSResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void setMaxAsynchronousProcesses(int maxAsynchronousProcesses) {
        if (this.asynchService == null) {
            this.asynchService = new ThreadPoolExecutor(maxAsynchronousProcesses, maxAsynchronousProcesses, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        } else {
            this.asynchService.setCorePoolSize(1);
            this.asynchService.setMaximumPoolSize(maxAsynchronousProcesses);
            this.asynchService.setCorePoolSize(maxAsynchronousProcesses);
        }
    }

    public void setMaxSynchronousProcesses(int maxSynchronousProcesses) {
        if (this.synchService == null) {
            this.synchService = new ThreadPoolExecutor(maxSynchronousProcesses, maxSynchronousProcesses, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        } else {
            this.synchService.setCorePoolSize(1);
            this.synchService.setMaximumPoolSize(maxSynchronousProcesses);
            this.synchService.setCorePoolSize(maxSynchronousProcesses);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextClosedEvent) {
            this.synchService.shutdownNow();
            this.asynchService.shutdownNow();
        }
    }

    @Override
    public boolean canHandle(Name processName) {
        return true;
    }

    @Override
    public Map<String, Object> submitChained(String executionId, Name processName, Map<String, Object> inputs, ProgressListener listener) throws ProcessException {
        ProcessFactory pf = GeoServerProcessors.createProcessFactory(processName, true);
        if (pf == null) {
            throw new WPSException("No such process: " + processName);
        }
        Process p = pf.create(processName);
        Map result = p.execute(inputs, listener);
        return result;
    }

    @Override
    public void submit(String executionId, Name processName, Map<String, Object> inputs, ProgressListener listener, boolean background) throws ProcessException {
        ProcessCallable callable = new ProcessCallable(processName, inputs, listener);
        Future<Map<String, Object>> future = background ? this.asynchService.submit(callable) : this.synchService.submit(callable);
        this.executions.put(executionId, future);
    }

    @Override
    public Map<String, Object> getOutput(String executionId, long timeout) throws ProcessException {
        Future<Map<String, Object>> future = this.executions.get(executionId);
        if (future == null) {
            return null;
        }
        boolean timedOut = false;
        try {
            Map<String, Object> result = timeout <= 0L ? future.get() : future.get(timeout, TimeUnit.MILLISECONDS);
            Map<String, Object> map = result;
            return map;
        }
        catch (TimeoutException e) {
            timedOut = true;
            throw new ProcessException((Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof ExecutionException && e.getCause() instanceof Exception) {
                e = (Exception)e.getCause();
            }
            if (e instanceof ProcessException) {
                throw (ProcessException)e;
            }
            if (e instanceof WPSException) {
                throw (WPSException)((Object)e);
            }
            throw new ProcessException("Process execution " + executionId + " failed", (Throwable)e);
        }
        finally {
            if (!timedOut) {
                this.executions.remove(executionId);
            }
        }
    }

    @Override
    public void cancel(String executionId) {
        Future<Map<String, Object>> future = this.executions.get(executionId);
        if (future != null) {
            future.cancel(true);
        }
    }

    public int getPriority() {
        return 100;
    }

    class ProcessCallable
    implements Callable<Map<String, Object>> {
        Name processName;
        Map<String, Object> inputs;
        ThreadLocalsTransfer threadLocalTransfer;
        ProgressListener listener;

        public ProcessCallable(Name processName, Map<String, Object> inputs, ProgressListener listener) {
            this.processName = processName;
            this.inputs = inputs;
            this.listener = listener;
            this.threadLocalTransfer = new ThreadLocalsTransfer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> call() throws Exception {
            try {
                Map result;
                this.threadLocalTransfer.apply();
                ProcessFactory pf = GeoServerProcessors.createProcessFactory(this.processName, true);
                if (pf == null) {
                    throw new WPSException("No such process: " + this.processName);
                }
                Process p = pf.create(this.processName);
                Map map = result = p.execute(this.inputs, this.listener);
                return map;
            }
            finally {
                this.threadLocalTransfer.cleanup();
            }
        }
    }
}

