/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps.executor;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.opengis.wps10.InputReferenceType;
import net.opengis.wps10.InputType;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.ows.util.KvpMap;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.wps.WPSException;
import org.geoserver.wps.executor.InputProvider;
import org.geoserver.wps.executor.InternalWCSInputProvider;
import org.geoserver.wps.executor.InternalWFSInputProvider;
import org.geoserver.wps.executor.InternalWPSInputProvider;
import org.geoserver.wps.executor.RemoteRequestInputProvider;
import org.geoserver.wps.executor.SimpleInputProvider;
import org.geoserver.wps.executor.ValidatingInputProvider;
import org.geoserver.wps.executor.WPSExecutionManager;
import org.geoserver.wps.ppio.ComplexPPIO;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geoserver.wps.validator.MaxSizeValidator;
import org.geoserver.wps.validator.Validators;
import org.geotools.api.util.ProgressListener;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.Validator;

public abstract class AbstractInputProvider
implements InputProvider {
    InputType input;
    ProcessParameterIO ppio;
    Object value;
    String inputId;

    public static InputProvider getInputProvider(InputType input, ProcessParameterIO ppio, WPSExecutionManager executor, ApplicationContext context, Collection<Validator> validators) throws Exception {
        AbstractInputProvider provider;
        if (input.getReference() != null) {
            InputReferenceType ref = input.getReference();
            String href = ref.getHref();
            if (href.startsWith("http://geoserver/wfs")) {
                provider = new InternalWFSInputProvider(input, ppio, context);
            } else if (href.startsWith("http://geoserver/wcs")) {
                provider = new InternalWCSInputProvider(input, ppio, context);
            } else if (href.startsWith("http://geoserver/wps")) {
                provider = new InternalWPSInputProvider(input, ppio, executor, context);
            } else {
                if (executor.isRemoteInputDisabled()) {
                    throw new WPSException("Remote complex input references are disabled");
                }
                int maxSizeMB = Validators.getMaxSizeMB(validators);
                validators = Validators.filterOutClasses(validators, MaxSizeValidator.class);
                provider = new RemoteRequestInputProvider(input, (ComplexPPIO)ppio, executor.getConnectionTimeout(), maxSizeMB * 1024 * 1024);
            }
        } else {
            provider = new SimpleInputProvider(input, ppio);
        }
        return ValidatingInputProvider.wrap(provider, validators);
    }

    public AbstractInputProvider(InputType input, ProcessParameterIO ppio) {
        this.input = input;
        this.ppio = ppio;
        this.inputId = input.getIdentifier().getValue();
    }

    @Override
    public String getInputId() {
        return this.inputId;
    }

    @Override
    public boolean resolved() {
        return this.value != null;
    }

    @Override
    public final Object getValue(ProgressListener listener) throws Exception {
        if (this.value == null) {
            this.value = this.getValueInternal(listener);
        }
        return this.value;
    }

    protected abstract Object getValueInternal(ProgressListener var1) throws Exception;

    protected Object kvpParse(String href, KvpRequestReader reader) throws Exception {
        KvpMap original = new KvpMap(KvpUtils.parseQueryString((String)href));
        KvpUtils.normalize((Map)original);
        KvpMap parsed = new KvpMap((Map)original);
        List errors = KvpUtils.parse((Map)parsed);
        if (!errors.isEmpty()) {
            throw new WPSException("Failed to parse KVP request", (Throwable)errors.get(0));
        }
        Request r = (Request)Dispatcher.REQUEST.get();
        if (r != null) {
            r.setKvp((Map)new CaseInsensitiveMap((Map)parsed));
        }
        return reader.read(reader.createRequest(), (Map)parsed, (Map)original);
    }

    protected String getVersion(String href) {
        return (String)new KvpMap(KvpUtils.parseQueryString((String)href)).get((Object)"VERSION");
    }
}

