/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.io.IOException;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ConfigurationException;
import org.geoserver.wcs.response.WCSStorageCleaner;
import org.geoserver.wps.executor.ProcessStatusTracker;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.util.logging.Logging;

public class WPSStorageCleaner
extends TimerTask {
    Logger LOGGER = Logging.getLogger(WCSStorageCleaner.class);
    long expirationDelay;
    WPSResourceManager resourceManager;
    ProcessStatusTracker statusTracker;

    public WPSStorageCleaner(WPSResourceManager resourceManager, ProcessStatusTracker statusTracker) throws IOException, ConfigurationException {
        this.resourceManager = resourceManager;
        this.statusTracker = statusTracker;
    }

    @Override
    public void run() {
        try {
            if (this.resourceManager.getArtifactsStore() == null || this.expirationDelay == 0L) {
                return;
            }
            long expirationThreshold = System.currentTimeMillis() - this.expirationDelay;
            this.statusTracker.cleanExpiredStatuses(expirationThreshold);
            this.resourceManager.cleanExpiredResources(expirationThreshold, this.statusTracker);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, "Error occurred while trying to clean up old coverages from temp storage", e);
        }
    }

    public long getExpirationDelay() {
        return this.expirationDelay;
    }

    public void setExpirationDelay(long expirationDelay) {
        this.expirationDelay = expirationDelay;
    }
}

