/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerReinitializer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.FileLockProvider;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.LockProvider;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceStore;
import org.geoserver.platform.resource.Resources;
import org.geoserver.wps.ProcessGroupInfo;
import org.geoserver.wps.ProcessGroupInfoImpl;
import org.geoserver.wps.WPSInfo;
import org.geoserver.wps.WPSStorageCleaner;
import org.geoserver.wps.executor.DefaultProcessManager;
import org.geoserver.wps.executor.WPSExecutionManager;
import org.geoserver.wps.resource.DefaultProcessArtifactsStore;
import org.geoserver.wps.resource.WPSResourceManager;
import org.geotools.process.ProcessFactory;
import org.geotools.process.Processors;
import org.geotools.util.logging.Logging;

public class WPSInitializer
implements GeoServerReinitializer {
    static final Logger LOGGER = Logging.getLogger(WPSInitializer.class);
    WPSExecutionManager executionManager;
    DefaultProcessManager processManager;
    WPSStorageCleaner cleaner;
    WPSResourceManager resources;
    GeoServerResourceLoader resourceLoader;
    ConfigurationListenerAdapter configurationListener;

    public WPSInitializer(WPSExecutionManager executionManager, DefaultProcessManager processManager, WPSStorageCleaner cleaner, WPSResourceManager resources, GeoServerResourceLoader resourceLoader) {
        this.executionManager = executionManager;
        this.processManager = processManager;
        this.cleaner = cleaner;
        this.resources = resources;
        this.resourceLoader = resourceLoader;
        this.configurationListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(final GeoServer geoServer) throws Exception {
        this.initWPS((WPSInfo)geoServer.getService(WPSInfo.class), geoServer);
        WPSInitializer wPSInitializer = this;
        synchronized (wPSInitializer) {
            if (this.configurationListener == null) {
                this.configurationListener = new ConfigurationListenerAdapter(){

                    public void handlePostGlobalChange(GeoServerInfo global) {
                        WPSInfo wpsInfo = (WPSInfo)geoServer.getService(WPSInfo.class);
                        if (wpsInfo != null) {
                            WPSInitializer.this.initWPS(wpsInfo, geoServer);
                        }
                    }
                };
            }
            geoServer.addListener((ConfigurationListener)this.configurationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeReinitialize(GeoServer geoServer) throws Exception {
        super.beforeReinitialize(geoServer);
        WPSInitializer wPSInitializer = this;
        synchronized (wPSInitializer) {
            if (this.configurationListener != null) {
                geoServer.removeListener((ConfigurationListener)this.configurationListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitialize(GeoServer geoServer) throws Exception {
        WPSInitializer wPSInitializer = this;
        synchronized (wPSInitializer) {
            if (this.configurationListener != null) {
                geoServer.addListener((ConfigurationListener)this.configurationListener);
            }
        }
        this.initWPS((WPSInfo)geoServer.getService(WPSInfo.class), geoServer);
    }

    void initWPS(WPSInfo info, GeoServer geoServer) {
        if (info == null) {
            throw new NullPointerException("WPS configuration not available for initialization");
        }
        double connectionTimeout = info.getConnectionTimeout();
        if (connectionTimeout > 0.0) {
            this.executionManager.setConnectionTimeout((int)connectionTimeout * 1000);
        } else {
            this.executionManager.setConnectionTimeout(0);
        }
        this.executionManager.setRemoteInputDisabled(info.isRemoteInputDisabled());
        int expirationTimeout = info.getResourceExpirationTimeout() * 1000;
        if (expirationTimeout < 0) {
            expirationTimeout = 300000;
        }
        this.cleaner.setExpirationDelay(expirationTimeout);
        this.executionManager.setHeartbeatDelay(expirationTimeout / 2);
        int defaultMaxProcesses = Runtime.getRuntime().availableProcessors() * 2;
        int maxSynch = info.getMaxSynchronousProcesses();
        if (maxSynch > 0) {
            this.processManager.setMaxSynchronousProcesses(maxSynch);
        } else {
            this.processManager.setMaxSynchronousProcesses(defaultMaxProcesses);
        }
        int maxAsynch = info.getMaxAsynchronousProcesses();
        if (maxAsynch > 0) {
            this.processManager.setMaxAsynchronousProcesses(maxAsynch);
        } else {
            this.processManager.setMaxAsynchronousProcesses(defaultMaxProcesses);
        }
        if (this.resources.getArtifactsStore() instanceof DefaultProcessArtifactsStore) {
            FileSystemResourceStore resourceStore;
            String outputStorageDirectory;
            WPSInfo wps = (WPSInfo)geoServer.getService(WPSInfo.class);
            String string = outputStorageDirectory = wps != null ? wps.getStorageDirectory() : null;
            if (outputStorageDirectory == null || outputStorageDirectory.trim().isEmpty()) {
                Resource temp = this.resourceLoader.get("temp/wps");
                resourceStore = new FileSystemResourceStore(temp.dir());
            } else {
                File storage = new File(outputStorageDirectory);
                if (!storage.isAbsolute()) {
                    storage = Resources.find((Resource)Resources.fromURL((Resource)Files.asResource((File)this.resourceLoader.getBaseDirectory()), (String)outputStorageDirectory), (boolean)true);
                }
                if (storage.exists() && !storage.isDirectory()) {
                    throw new IllegalArgumentException("Invalid wps storage path, it represents a file: " + storage.getPath());
                }
                if (!storage.exists() && !storage.mkdirs()) {
                    throw new IllegalArgumentException("Invalid wps storage path, it does not exists and cannot be created: " + storage.getPath());
                }
                resourceStore = new FileSystemResourceStore(storage);
            }
            try {
                Resource lockDirectory = this.resourceLoader.get("tmp");
                resourceStore.setLockProvider((LockProvider)new FileLockProvider(lockDirectory.dir()));
            }
            catch (IllegalStateException e) {
                throw new RuntimeException("Unexpected failure searching for tmp directory inside geoserver data dir", e);
            }
            DefaultProcessArtifactsStore artifactsStore = (DefaultProcessArtifactsStore)this.resources.getArtifactsStore();
            artifactsStore.setResourceStore((ResourceStore)resourceStore);
        }
        this.resources.setExternalOutputDirectory(info.getExternalOutputDirectory());
        WPSInitializer.lookupNewProcessGroups(info, geoServer);
    }

    static void lookupNewProcessGroups(WPSInfo info, GeoServer geoServer) {
        ArrayList<ProcessGroupInfo> newGroups = new ArrayList<ProcessGroupInfo>();
        for (ProcessGroupInfo available : WPSInitializer.lookupProcessGroups()) {
            boolean found = false;
            for (ProcessGroupInfo configured : info.getProcessGroups()) {
                if (!configured.getFactoryClass().equals(available.getFactoryClass())) continue;
                found = true;
                break;
            }
            if (found) continue;
            newGroups.add(available);
        }
        if (!newGroups.isEmpty()) {
            info.getProcessGroups().addAll(newGroups);
            geoServer.save((ServiceInfo)info);
        }
    }

    static List<ProcessGroupInfo> lookupProcessGroups() {
        ArrayList<ProcessGroupInfo> processFactories = new ArrayList<ProcessGroupInfo>();
        ArrayList factories = new ArrayList(Processors.getProcessFactories());
        Collections.sort(factories, (o1, o2) -> {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getClass().getName().compareTo(o2.getClass().getName());
        });
        for (ProcessFactory pf : factories) {
            ProcessGroupInfoImpl pfi = new ProcessGroupInfoImpl();
            pfi.setEnabled(true);
            pfi.setFactoryClass(pf.getClass());
            processFactories.add(pfi);
        }
        return processFactories;
    }
}

