/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.wps.ProcessGroupInfo;
import org.geoserver.wps.ProcessInfo;
import org.geotools.process.ProcessFactory;

public class ProcessGroupInfoImpl
implements ProcessGroupInfo {
    private static final long serialVersionUID = 4850653421657310854L;
    Class<? extends ProcessFactory> factoryClass;
    boolean enabled;
    List<String> roles = new ArrayList<String>();
    List<ProcessInfo> filteredProcesses = new ArrayList<ProcessInfo>();
    MetadataMap metadata = new MetadataMap();

    public String getId() {
        return "wpsProcessFactory-" + this.factoryClass.getName();
    }

    @Override
    public Class<? extends ProcessFactory> getFactoryClass() {
        return this.factoryClass;
    }

    @Override
    public void setFactoryClass(Class<? extends ProcessFactory> factoryClass) {
        this.factoryClass = factoryClass;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public List<ProcessInfo> getFilteredProcesses() {
        return this.filteredProcesses;
    }

    public void setFilteredProcesses(List<ProcessInfo> filteredProcesses) {
        this.filteredProcesses = filteredProcesses;
    }

    @Override
    public MetadataMap getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataMap metadataMap) {
        this.metadata = metadataMap;
    }

    @Override
    public ProcessGroupInfo clone() {
        ProcessGroupInfoImpl clone = new ProcessGroupInfoImpl();
        clone.setEnabled(this.enabled);
        clone.setFactoryClass(this.factoryClass);
        clone.setRoles(this.roles);
        if (this.filteredProcesses != null) {
            clone.setFilteredProcesses(new ArrayList<ProcessInfo>(this.filteredProcesses));
        }
        if (this.metadata != null) {
            clone.metadata = new MetadataMap(new HashMap(this.metadata));
        }
        return clone;
    }

    @Override
    public List<String> getRoles() {
        return this.roles;
    }

    @Override
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.factoryClass == null ? 0 : this.factoryClass.hashCode());
        result = 31 * result + (this.filteredProcesses == null ? 0 : this.filteredProcesses.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessGroupInfoImpl other = (ProcessGroupInfoImpl)obj;
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.factoryClass == null ? other.factoryClass != null : !this.factoryClass.equals(other.factoryClass)) {
            return false;
        }
        if (this.filteredProcesses == null ? other.filteredProcesses != null : !this.filteredProcesses.equals(other.filteredProcesses)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals((Object)other.metadata)) {
            return false;
        }
        return !(this.roles == null ? other.roles != null : !this.roles.equals(other.roles));
    }
}

